/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.common.actors;

import com.isencia.passerelle.core.PortHandler;
import com.isencia.passerelle.core.PortListener;
import com.isencia.passerelle.util.LoggerManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.actor.NoTokenException;
import ptolemy.actor.process.TerminateProcessException;
import ptolemy.data.Token;
import ptolemy.kernel.util.IllegalActionException;

public class RecordingPortHandler
extends PortHandler {
    private static final Logger logger = LoggerFactory.getLogger(RecordingPortHandler.class);
    private boolean recordPorts = false;
    private Map<Integer, Object> portRecord;

    public RecordingPortHandler(IOPort iOPort) {
        this(iOPort, null);
    }

    public RecordingPortHandler(IOPort iOPort, boolean bl) {
        this(iOPort, bl, null);
    }

    public RecordingPortHandler(IOPort iOPort, PortListener portListener) {
        this(iOPort, false, portListener);
    }

    private RecordingPortHandler(IOPort iOPort, boolean bl, PortListener portListener) {
        super(iOPort, portListener);
        this.setRecordPorts(bl);
    }

    protected Thread createChannelHandler(int n) {
        return new RecordingHandler(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Token getToken() {
        Token token;
        block15: {
            if (logger.isTraceEnabled()) {
                logger.trace(String.valueOf(this.getName()) + " getToken() - entry");
            }
            token = null;
            Object object = this.channelLock;
            synchronized (object) {
                if (this.channelCount == 0 && this.hasNoMoreTokens()) {
                    return null;
                }
            }
            if (this.mustUseHandlers()) {
                try {
                    token = (Token)this.queue.take();
                    if (Token.NIL.equals(token)) {
                        this.queue.offer(token);
                        token = null;
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                try {
                    if (!this.ioPort.hasToken(0)) break block15;
                    token = this.ioPort.get(0);
                    if (this.recordPorts) {
                        this.portRecord.put(0, token != null ? token : new Object());
                    }
                }
                catch (NoTokenException noTokenException) {
                }
                catch (IllegalActionException illegalActionException) {}
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getName()) + " getToken() - exit - token : " + token);
        }
        return token;
    }

    public boolean isInputComplete() {
        int n;
        boolean bl;
        if (this.queue == null || this.portRecord == null) {
            return false;
        }
        if (!this.queue.isEmpty()) {
            return false;
        }
        int n2 = this.portRecord.size();
        boolean bl2 = bl = n2 >= (n = this.ioPort.getWidth());
        if (bl) {
            this.portRecord.clear();
        }
        return bl;
    }

    public boolean isRecordPorts() {
        return this.recordPorts;
    }

    public void setRecordPorts(boolean bl) {
        this.recordPorts = bl;
        this.portRecord = bl ? new ConcurrentHashMap<Integer, Object>(7) : null;
    }

    private class RecordingHandler
    extends Thread {
        private Token token = null;
        private boolean terminated = false;
        private int channelIndex = 0;

        public RecordingHandler(int n) {
            this.channelIndex = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    LoggerManager.pushMDC((String)"actor", (String)RecordingPortHandler.this.actorInfo);
                    if (logger.isInfoEnabled()) {
                        logger.info(String.valueOf(RecordingPortHandler.this.ioPort.getFullName()) + " ChannelHandler." + this.channelIndex + " run() - entry");
                    }
                    while (!this.terminated) {
                        this.fetch();
                    }
                    Object object = RecordingPortHandler.this.channelLock;
                    synchronized (object) {
                        RecordingPortHandler recordingPortHandler = RecordingPortHandler.this;
                        recordingPortHandler.channelCount = recordingPortHandler.channelCount - 1;
                    }
                    if (RecordingPortHandler.this.channelCount == 0) {
                        RecordingPortHandler.this.queue.offer(Token.NIL);
                        if (RecordingPortHandler.this.listener != null) {
                            RecordingPortHandler.this.listener.noMoreTokens();
                        }
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info(String.valueOf(RecordingPortHandler.this.ioPort.getFullName()) + " ChannelHandler." + this.channelIndex + " run() - exit");
                    }
                }
                catch (Throwable throwable) {
                    logger.error(String.valueOf(RecordingPortHandler.this.ioPort.getFullName()) + " - Error in ChannelHandler", throwable);
                    throwable.printStackTrace();
                    throw new RuntimeException(throwable);
                }
            }
            finally {
                LoggerManager.popMDC((String)"actor");
            }
        }

        private void fetch() {
            if (logger.isTraceEnabled()) {
                logger.trace(String.valueOf(RecordingPortHandler.this.ioPort.getFullName()) + " ChannelHandler." + this.channelIndex + " fetch() - entry");
            }
            try {
                if (RecordingPortHandler.this.ioPort.hasToken(this.channelIndex)) {
                    this.token = RecordingPortHandler.this.ioPort.get(this.channelIndex);
                    if (RecordingPortHandler.this.recordPorts) {
                        RecordingPortHandler.this.portRecord.put(this.channelIndex, this.token != null ? this.token : new Object());
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.valueOf(RecordingPortHandler.this.ioPort.getFullName()) + " ChannelHandler." + this.channelIndex + " fetch() - got token : " + this.token);
                    }
                    if (this.token != null) {
                        RecordingPortHandler.this.queue.offer(this.token);
                    } else {
                        this.terminated = true;
                    }
                }
                if (RecordingPortHandler.this.listener != null) {
                    RecordingPortHandler.this.listener.tokenReceived();
                }
            }
            catch (TerminateProcessException terminateProcessException) {
                this.terminated = true;
            }
            catch (IllegalActionException illegalActionException) {
                this.terminated = true;
            }
            catch (NoTokenException noTokenException) {
                this.terminated = true;
            }
            if (logger.isTraceEnabled()) {
                logger.trace(String.valueOf(RecordingPortHandler.this.ioPort.getFullName()) + " ChannelHandler." + this.channelIndex + " fetch() - exit");
            }
        }
    }
}

