/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.common.actors;

import com.isencia.passerelle.actor.Actor;
import javax.management.MBeanServerConnection;
import org.dawb.workbench.jmx.RemoteWorkbenchAgent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActorUtils {
    private static Logger logger = LoggerFactory.getLogger(ActorUtils.class);
    private static MBeanServerConnection workbenchConnection;
    private static boolean isWorkbenchPresentChecked;

    static {
        isWorkbenchPresentChecked = false;
    }

    public static void setActorExecuting(Actor actor, boolean bl) {
        MBeanServerConnection mBeanServerConnection;
        boolean bl2;
        if (actor.getManager() == null) {
            return;
        }
        if (Platform.getBundle((String)"org.dawb.workbench.ui") != null && !(bl2 = (mBeanServerConnection = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.dawb.workbench.ui")).getBoolean("org.dawb.actor.highlight.choice"))) {
            return;
        }
        try {
            mBeanServerConnection = ActorUtils.getWorkbenchConnection();
            if (mBeanServerConnection == null) {
                return;
            }
            mBeanServerConnection.invoke(RemoteWorkbenchAgent.REMOTE_WORKBENCH, "setActorSelected", new Object[]{actor.getContainer().getSource(), actor.getName(), bl, 9}, new String[]{String.class.getName(), String.class.getName(), Boolean.TYPE.getName(), Integer.TYPE.getName()});
        }
        catch (Exception exception) {
            logger.trace("Cannot set actor selected", (Throwable)exception);
            return;
        }
    }

    public static MBeanServerConnection getWorkbenchConnection() throws Exception {
        if (isWorkbenchPresentChecked) {
            return workbenchConnection;
        }
        workbenchConnection = RemoteWorkbenchAgent.getServerConnection((long)1000L);
        isWorkbenchPresentChecked = true;
        return workbenchConnection;
    }
}

