/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.common.actors;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.util.ptolemy.ResourceParameter;
import com.isencia.passerelle.workbench.model.actor.IResourceActor;
import com.isencia.passerelle.workbench.model.actor.ResourceObject;
import com.isencia.passerelle.workbench.model.utils.ModelUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.dawb.common.util.io.IFileUtils;
import org.dawb.passerelle.common.actors.AbstractPassModeTransformer;
import org.dawb.passerelle.common.actors.ActorUtils;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.DataMessageException;
import org.dawb.passerelle.common.message.MessageUtils;
import org.dawb.passerelle.common.parameter.ParameterUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gmf.runtime.common.core.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;

public abstract class AbstractScriptTransformer
extends AbstractPassModeTransformer
implements IResourceActor {
    private static final long serialVersionUID = 780021329637752897L;
    private static Logger logger = LoggerFactory.getLogger(AbstractScriptTransformer.class);
    protected ResourceParameter scriptFileParam;
    protected String scriptFilePath;
    private final List<DataMessageComponent> cache = new ArrayList<DataMessageComponent>(7);

    public AbstractScriptTransformer(CompositeEntity compositeEntity, String string) throws Exception {
        super(compositeEntity, ModelUtils.findUniqueActorName((CompositeEntity)compositeEntity, (String)string));
        this.scriptFileParam = this.getScriptParameter((Actor)this);
        this.registerConfigurableParameter((Parameter)this.scriptFileParam);
        this.memoryManagementParam.setVisibility(Settable.NONE);
        this.dataSetNaming.setVisibility(Settable.NONE);
    }

    protected abstract ResourceParameter getScriptParameter(Actor var1) throws Exception;

    protected abstract DataMessageComponent getTransformedMessage(List<DataMessageComponent> var1) throws Exception;

    private DataMessageComponent getTransformedMessageInternal(List<DataMessageComponent> list) throws Exception {
        if (list == null || list.isEmpty()) {
            return null;
        }
        try {
            ActorUtils.setActorExecuting((Actor)this, true);
            DataMessageComponent dataMessageComponent = this.getTransformedMessage(list);
            return dataMessageComponent;
        }
        finally {
            ActorUtils.setActorExecuting((Actor)this, false);
        }
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        super.attributeChanged(attribute);
    }

    protected void doFire(ManagedMessage managedMessage) throws ProcessingException {
        try {
            DataMessageComponent dataMessageComponent;
            if (managedMessage != null) {
                dataMessageComponent = MessageUtils.coerceMessage(managedMessage);
                this.cache.add(dataMessageComponent);
            }
            if (this.isFireInLoop()) {
                dataMessageComponent = this.getTransformedMessageInternal(this.cache);
                if (dataMessageComponent == null) {
                    return;
                }
                this.sendOutputMsg(this.output, MessageUtils.getDataMessage(dataMessageComponent));
                this.cache.clear();
            }
        }
        catch (ProcessingException processingException) {
            throw processingException;
        }
        catch (Exception exception) {
            throw this.createDataMessageException("Cannot add data from '" + managedMessage + "'", exception);
        }
    }

    protected boolean doPostFire() throws ProcessingException {
        boolean bl = this.isFinishRequested();
        boolean bl2 = this.isInputRoundComplete();
        if ((bl || bl2) && this.isFireEndLoop()) {
            DataMessageComponent dataMessageComponent = null;
            try {
                dataMessageComponent = this.getTransformedMessageInternal(this.cache);
                if (dataMessageComponent == null) {
                    return !bl;
                }
                this.sendOutputMsg(this.output, MessageUtils.getDataMessage(dataMessageComponent));
            }
            catch (ProcessingException processingException) {
                throw processingException;
            }
            catch (Exception exception) {
                logger.error("Cannot add data from '" + dataMessageComponent + "'", (Throwable)exception);
            }
        }
        return !bl;
    }

    protected IResource getResource() throws Exception {
        Object object;
        Object object2;
        String string = this.scriptFileParam.getExpression();
        IFile iFile = null;
        if (string == null || "".equals(string)) {
            object2 = this.getProject();
            object = object2.getFolder("src");
            iFile = IFileUtils.getUniqueIFile((IContainer)object, (String)"python_script", (String)"py");
            string = iFile.getFullPath().toOSString();
            string = StringUtil.replace((String)string, (String)("/" + iFile.getProject().getName() + "/"), (String)"/${project_name}/", (boolean)true);
            this.scriptFileParam.setExpression(string);
        } else if (ResourcesPlugin.getWorkspace().getRoot().findMember(string) != null && ResourcesPlugin.getWorkspace().getRoot().findMember(string).exists()) {
            this.scriptFileParam.setExpression(string);
            iFile = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(string);
        }
        if (iFile == null) {
            Object object3;
            string = ParameterUtils.substitute(string, (NamedObj)this);
            object2 = this.getProject();
            IContainer iContainer = (IContainer)object2.findMember((String)(object = IFileUtils.getPathWithoutProject((String)string.substring(0, string.lastIndexOf(47)))));
            if (iContainer == null) {
                try {
                    object3 = object2.getFolder((String)object);
                    object3.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                    iContainer = object3;
                }
                catch (Exception exception) {
                    logger.error("Cannot create folder " + (String)object, (Throwable)exception);
                }
            }
            if ((iFile = (IFile)iContainer.findMember((String)(object3 = string.substring(string.lastIndexOf(47))))) == null && iContainer instanceof IProject) {
                iFile = ((IProject)iContainer).getFile((String)object3);
            }
            if (iFile == null && iContainer instanceof IFolder) {
                iFile = ((IFolder)iContainer).getFile((String)object3);
            }
        }
        try {
            if (!iFile.exists()) {
                object2 = new ByteArrayInputStream(this.createScript().getBytes("UTF-8"));
                iFile.create((InputStream)object2, true, (IProgressMonitor)new NullProgressMonitor());
                iFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception exception) {
            logger.error("Cannot create file " + string, (Throwable)exception);
        }
        return iFile;
    }

    protected abstract String createScript();

    protected String getResourceTypeName() throws Exception {
        String string = this.getResource().getName();
        if (string == null) {
            return "";
        }
        return "'" + this.getResource().getName() + "'";
    }

    public int getResourceCount() {
        return 1;
    }

    public ResourceObject getResource(int n) throws Exception {
        if (n == 0) {
            ResourceObject resourceObject = new ResourceObject();
            resourceObject.setResource((Object)this.getResource());
            resourceObject.setResourceTypeName(this.getResourceTypeName());
            return resourceObject;
        }
        return null;
    }

    protected DataMessageException createDataMessageException(String string, Throwable throwable) throws DataMessageException {
        return new DataMessageException(string, (Object)this, this.cache, throwable);
    }

    protected void setUpstreamValues(DataMessageComponent dataMessageComponent, List<DataMessageComponent> list) {
        dataMessageComponent.setMeta(MessageUtils.getMeta(list));
        dataMessageComponent.addScalar(MessageUtils.getScalar(list));
    }
}

