/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.common.actors;

import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.TerminationException;
import com.isencia.passerelle.actor.Transformer;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.PasserelleToken;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageHelper;
import com.isencia.passerelle.util.ptolemy.StringChoiceParameter;
import com.isencia.passerelle.workbench.model.utils.ModelUtils;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServerConnection;
import org.dawb.passerelle.common.actors.ActorUtils;
import org.dawb.passerelle.common.actors.RecordingPortHandler;
import org.dawb.passerelle.common.message.AbstractDatasetProvider;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.IVariableProvider;
import org.dawb.passerelle.common.message.MessageUtils;
import org.dawb.passerelle.common.message.Variable;
import org.dawb.workbench.jmx.RemoteWorkbenchAgent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;

public abstract class AbstractPassModeTransformer
extends Transformer
implements IVariableProvider {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPassModeTransformer.class);
    private static final long serialVersionUID = -1903160956377231213L;
    protected static List<String> EXPRESSION_MODE = new ArrayList<String>(3);
    protected static List<String> MEMORY_MODE;
    protected static List<String> NAME_MODE;
    protected final StringChoiceParameter passModeParameter = new StringChoiceParameter((NamedObj)this, "Expression Mode", this.getExpressionModes(), 4);
    protected String passMode;
    protected final StringChoiceParameter memoryManagementParam;
    protected String memoryMode;
    protected final StringChoiceParameter dataSetNaming;
    protected String namingMode;
    protected RecordingPortHandler recInputHandler;
    private ArrayList<IVariable> cachedUpstreamVariables;
    public IOPort finishedPort;
    protected ManagedMessage lastOutput;

    static {
        EXPRESSION_MODE.add("Evaluate on every data input");
        EXPRESSION_MODE.add("Evaluate after all data received");
        MEMORY_MODE = new ArrayList<String>(3);
        MEMORY_MODE.add("Create copy of data leaving original data intact.");
        MEMORY_MODE.add("Operate on data directly to save memory.");
        NAME_MODE = new ArrayList<String>(3);
        NAME_MODE.add("Attempt to use image name if there is one.");
        NAME_MODE.add("Leave as name based on previous nodes.");
        NAME_MODE.add("Use name of this actor as the data set name.");
    }

    public AbstractPassModeTransformer(final CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, ModelUtils.findUniqueActorName((CompositeEntity)compositeEntity, (String)string));
        this.passModeParameter.setExpression(EXPRESSION_MODE.get(0));
        this.registerConfigurableParameter((Parameter)this.passModeParameter);
        this.passMode = EXPRESSION_MODE.get(0);
        this.memoryManagementParam = new StringChoiceParameter((NamedObj)this, "Memory Mode", this.getMemoryModes(), 4);
        this.memoryManagementParam.setExpression(MEMORY_MODE.get(0));
        this.registerConfigurableParameter((Parameter)this.memoryManagementParam);
        this.memoryMode = MEMORY_MODE.get(0);
        this.dataSetNaming = new StringChoiceParameter((NamedObj)this, "Name Mode", this.getNameModes(), 4);
        this.dataSetNaming.setExpression(NAME_MODE.get(0));
        this.registerConfigurableParameter((Parameter)this.dataSetNaming);
        this.namingMode = NAME_MODE.get(0);
        this.cachedUpstreamVariables = new ArrayList(7);
        compositeEntity.addChangeListener(new ChangeListener(){

            public void changeFailed(ChangeRequest changeRequest, Exception exception) {
            }

            public void changeExecuted(ChangeRequest changeRequest) {
                AbstractPassModeTransformer.this.cachedUpstreamVariables.clear();
                if (!compositeEntity.deepContains((NamedObj)AbstractPassModeTransformer.this)) {
                    compositeEntity.removeChangeListener((ChangeListener)this);
                }
            }
        });
        List list = this.outputPortList();
        if (list != null) {
            for (Object e : list) {
                IOPort iOPort;
                if (!(e instanceof IOPort) || (iOPort = (IOPort)e).getName() == null || !iOPort.getName().equals("hasFinished")) continue;
                this.finishedPort = iOPort;
            }
        }
    }

    protected void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        this.recInputHandler = new RecordingPortHandler((IOPort)this.input, true);
        if (this.input.getWidth() > 0) {
            this.recInputHandler.start();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected boolean doPreFire() throws ProcessingException {
        Token token;
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doPreFire() - entry");
        }
        if ((token = this.recInputHandler.getToken()) != null) {
            try {
                this.message = MessageHelper.getMessageFromToken((Token)token);
            }
            catch (PasserelleException passerelleException) {
                throw new ProcessingException("Error handling token", (Object)token, (Throwable)passerelleException);
            }
        } else {
            this.message = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doPreFire() - exit");
        }
        return true;
    }

    protected List<String> getExpressionModes() {
        return EXPRESSION_MODE;
    }

    protected List<String> getMemoryModes() {
        return MEMORY_MODE;
    }

    protected List<String> getNameModes() {
        return NAME_MODE;
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.passModeParameter) {
            this.passMode = this.passModeParameter.getExpression();
        }
        super.attributeChanged(attribute);
    }

    protected String getPassMode() {
        return this.passMode;
    }

    protected void setPassMode(String string) {
        this.passMode = string;
    }

    protected boolean isFireInLoop() {
        return EXPRESSION_MODE.get(0).equals(this.passMode);
    }

    protected boolean isFireEndLoop() {
        return EXPRESSION_MODE.get(1).equals(this.passMode);
    }

    protected boolean isCreateClone() {
        return MEMORY_MODE.get(0).equals(this.memoryMode);
    }

    @Override
    public List<IVariable> getOutputVariables() {
        List<IVariable> list = this.getScalarOutputVariables();
        return list;
    }

    protected List<IVariable> getScalarOutputVariables() {
        ArrayList<IVariable> arrayList = new ArrayList<IVariable>(7);
        List<IVariable> list = this.getInputVariables();
        for (IVariable iVariable : list) {
            if (iVariable.getVariableType() != IVariable.VARIABLE_TYPE.PATH && iVariable.getVariableType() != IVariable.VARIABLE_TYPE.SCALAR && iVariable.getVariableType() != IVariable.VARIABLE_TYPE.XML) continue;
            arrayList.add(iVariable);
        }
        arrayList.add(new Variable("project_name", IVariable.VARIABLE_TYPE.SCALAR, this.getProject().getName()));
        if (this.dataSetNaming.getVisibility() != Settable.NONE && NAME_MODE.get(2).equals(this.dataSetNaming.getExpression())) {
            arrayList.add(new Variable(this.getName(), IVariable.VARIABLE_TYPE.ARRAY, new AbstractDatasetProvider(), AbstractDataset.class));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IVariable> getInputVariables() {
        ArrayList<IVariable> arrayList = this.cachedUpstreamVariables;
        synchronized (arrayList) {
            if (this.cachedUpstreamVariables.isEmpty()) {
                List list = this.input.connectedPortList();
                for (Object e : list) {
                    List<IVariable> list2;
                    IOPort iOPort = (IOPort)e;
                    NamedObj namedObj = iOPort.getContainer();
                    if (!(namedObj instanceof IVariableProvider) || (list2 = ((IVariableProvider)namedObj).getOutputVariables()) == null) continue;
                    this.cachedUpstreamVariables.addAll(list2);
                }
            }
        }
        return this.cachedUpstreamVariables;
    }

    public boolean isUpstreamVariable(String string) {
        List<IVariable> list = this.getInputVariables();
        for (IVariable iVariable : list) {
            if (!iVariable.getVariableName().equals(string)) continue;
            return true;
        }
        return false;
    }

    protected abstract String getOperationName();

    protected String getExtendedInfo() {
        return this.getOperationName();
    }

    public static void refreshResource(IResource iResource) {
        if (!(iResource instanceof IContainer)) {
            iResource = iResource.getParent();
        }
        String string = iResource.getFullPath().toPortableString();
        try {
            MBeanServerConnection mBeanServerConnection = ActorUtils.getWorkbenchConnection();
            Object object = mBeanServerConnection.invoke(RemoteWorkbenchAgent.REMOTE_WORKBENCH, "refresh", new Object[]{iResource.getProject().getName(), string}, new String[]{String.class.getName(), String.class.getName()});
            if (object == null || !((Boolean)object).booleanValue()) {
                logger.error("Cannot refresh resource " + string);
            }
        }
        catch (Exception exception) {
            logger.error("Refreshing project remotely " + string);
            logger.trace("Refreshing project remotely " + string, (Throwable)exception);
        }
    }

    protected IProject getProject() {
        try {
            return ModelUtils.getProject((NamedObj)this);
        }
        catch (Exception exception) {
            logger.error("Cannot get the project for actor " + this.getName(), (Throwable)exception);
            return null;
        }
    }

    protected void setDataNames(DataMessageComponent dataMessageComponent, List<DataMessageComponent> list) {
        List<IDataset> list2;
        if (NAME_MODE.get(2).equals(this.dataSetNaming.getExpression()) && (list2 = MessageUtils.getDatasets(dataMessageComponent)) != null) {
            for (IDataset iDataset : list2) {
                iDataset.setName(this.getName());
            }
        }
        if (NAME_MODE.get(0).equals(this.dataSetNaming.getExpression())) {
            IDataset iDataset;
            list2 = MessageUtils.getDatasets(dataMessageComponent);
            if (list2 != null && list2.size() == 1 && (iDataset = list2.get(0)).getShape().length == 2) {
                Object object = dataMessageComponent.getScalar("file_name");
                if (object == null && list != null && list.size() == 1) {
                    DataMessageComponent dataMessageComponent2 = list.get(0);
                    object = dataMessageComponent2.getScalar("file_name");
                }
                if (object != null) {
                    try {
                        iDataset.setName(((String)object).substring(0, ((String)object).lastIndexOf(46)));
                    }
                    catch (Exception exception) {
                        logger.debug("Could not assign data set name from '" + (String)object + "'");
                    }
                }
            }
            return;
        }
    }

    protected void setLastOutput(ManagedMessage managedMessage) {
        this.lastOutput = managedMessage;
    }

    protected void sendOutputMsg(Port port, ManagedMessage managedMessage) throws ProcessingException, IllegalArgumentException {
        if (port == this.output && this.finishedPort != null && this.finishedPort.numberOfSinks() > 0) {
            this.lastOutput = managedMessage;
        }
        super.sendOutputMsg(port, managedMessage);
    }

    protected void doWrapUp() throws TerminationException {
        super.doWrapUp();
        try {
            try {
                if (this.lastOutput != null && this.finishedPort != null && this.finishedPort.numberOfSinks() > 0) {
                    this.finishedPort.broadcast((Token)new PasserelleToken(this.lastOutput));
                }
            }
            catch (Exception exception) {
                logger.error(this.getInfo(), (Throwable)exception);
                this.lastOutput = null;
            }
        }
        finally {
            this.lastOutput = null;
        }
    }

    protected boolean isInputRoundComplete() {
        return this.recInputHandler.isInputComplete();
    }
}

