/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.common.actors;

import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.Sink;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.message.MessageHelper;
import com.isencia.passerelle.util.ptolemy.StringChoiceParameter;
import com.isencia.passerelle.workbench.model.utils.ModelUtils;
import java.util.ArrayList;
import java.util.List;
import org.dawb.passerelle.common.actors.RecordingPortHandler;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.IVariableProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.Actor;
import ptolemy.actor.IOPort;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public abstract class AbstractPassModeSink
extends Sink
implements IVariableProvider {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPassModeSink.class);
    private static final long serialVersionUID = -1903160956377231213L;
    protected static List<String> EXPRESSION_MODE = new ArrayList<String>(3);
    protected static List<String> MEMORY_MODE;
    protected final StringChoiceParameter passModeParameter = new StringChoiceParameter((NamedObj)this, "Expression Mode", this.getExpressionModes(), 4);
    protected String passMode;
    protected final StringChoiceParameter memoryManagementParam;
    protected String memoryMode;
    private RecordingPortHandler recInputHandler;
    protected ArrayList<IVariable> cachedUpstreamVariables;

    static {
        EXPRESSION_MODE.add("Evaluate on every data input");
        EXPRESSION_MODE.add("Evaluate after all data received");
        EXPRESSION_MODE.add("Evaluate on finished");
        EXPRESSION_MODE.add("Evaluate on first message then never again");
        MEMORY_MODE = new ArrayList<String>(3);
        MEMORY_MODE.add("Create copy of data leaving original data intact.");
        MEMORY_MODE.add("Operate on data directly to save memory.");
    }

    public AbstractPassModeSink(final CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, ModelUtils.findUniqueActorName((CompositeEntity)compositeEntity, (String)string));
        this.passModeParameter.setExpression(EXPRESSION_MODE.get(0));
        this.registerConfigurableParameter((Parameter)this.passModeParameter);
        this.passMode = EXPRESSION_MODE.get(0);
        this.memoryManagementParam = new StringChoiceParameter((NamedObj)this, "Memory Mode", this.getMemoryModes(), 4);
        this.memoryManagementParam.setExpression(MEMORY_MODE.get(0));
        this.registerConfigurableParameter((Parameter)this.memoryManagementParam);
        this.memoryMode = MEMORY_MODE.get(0);
        this.cachedUpstreamVariables = new ArrayList(7);
        compositeEntity.addChangeListener(new ChangeListener(){

            public void changeFailed(ChangeRequest changeRequest, Exception exception) {
            }

            public void changeExecuted(ChangeRequest changeRequest) {
                AbstractPassModeSink.this.cachedUpstreamVariables.clear();
                if (!compositeEntity.deepContains((NamedObj)AbstractPassModeSink.this)) {
                    compositeEntity.removeChangeListener((ChangeListener)this);
                }
            }
        });
    }

    protected void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        if (this.input.getWidth() > 0) {
            this.recInputHandler = new RecordingPortHandler((IOPort)this.input, true);
            this.recInputHandler.start();
        } else {
            this.requestFinish();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected boolean doPreFire() throws ProcessingException {
        Token token;
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doPreFire() - entry");
        }
        if ((token = this.recInputHandler.getToken()) != null) {
            try {
                this.message = MessageHelper.getMessageFromToken((Token)token);
            }
            catch (PasserelleException passerelleException) {
                throw new ProcessingException("Error handling token", (Object)token, (Throwable)passerelleException);
            }
        } else {
            this.message = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doPreFire() - exit");
        }
        return true;
    }

    protected List<String> getExpressionModes() {
        return EXPRESSION_MODE;
    }

    protected List<String> getMemoryModes() {
        return MEMORY_MODE;
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.passModeParameter) {
            this.passMode = this.passModeParameter.getExpression();
        }
        super.attributeChanged(attribute);
    }

    protected String getPassMode() {
        return this.passMode;
    }

    protected void setPassMode(String string) {
        this.passMode = string;
    }

    protected boolean isFireInLoop() {
        return EXPRESSION_MODE.get(0).equals(this.passMode);
    }

    protected boolean isFireEndLoop() {
        return EXPRESSION_MODE.get(1).equals(this.passMode);
    }

    protected boolean isFireOnFinished() {
        return EXPRESSION_MODE.get(2).equals(this.passMode);
    }

    protected boolean isFireOnce() {
        return EXPRESSION_MODE.get(3).equals(this.passMode);
    }

    protected boolean isCreateClone() {
        return MEMORY_MODE.get(0).equals(this.memoryMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IVariable> getInputVariables() {
        ArrayList<IVariable> arrayList = this.cachedUpstreamVariables;
        synchronized (arrayList) {
            if (this.cachedUpstreamVariables.isEmpty()) {
                List list = this.input.connectedPortList();
                for (Object e : list) {
                    List<IVariable> list2;
                    IOPort iOPort = (IOPort)e;
                    Actor actor = (Actor)iOPort.getContainer();
                    if (!(actor instanceof IVariableProvider) || (list2 = ((IVariableProvider)actor).getOutputVariables()) == null) continue;
                    this.cachedUpstreamVariables.addAll(list2);
                }
            }
        }
        return this.cachedUpstreamVariables;
    }

    public boolean isUpstreamVariable(String string) {
        List<IVariable> list = this.getInputVariables();
        for (IVariable iVariable : list) {
            if (!iVariable.getVariableName().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<IVariable> getOutputVariables() {
        return null;
    }

    protected boolean isInputRoundComplete() {
        return this.recInputHandler.isInputComplete();
    }
}

