/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.common.actors;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.TerminationException;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortFactory;
import com.isencia.passerelle.core.PortHandler;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageHelper;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dawb.passerelle.common.actors.AbstractPassModeTransformer;
import org.dawb.passerelle.common.actors.ActorUtils;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.DataMessageException;
import org.dawb.passerelle.common.message.MessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.data.Token;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public abstract class AbstractDataMessageTransformer2Port
extends AbstractPassModeTransformer {
    private static final long serialVersionUID = -6609512817357858738L;
    protected final List<DataMessageComponent> port1Cache = new ArrayList<DataMessageComponent>(7);
    protected final List<DataMessageComponent> port2Cache = new ArrayList<DataMessageComponent>(7);
    public Port inputPort2;
    private PortHandler inputHandler2;
    protected static final List<String> TWO_PORT_EXPRESSION_MODES = new ArrayList<String>(7);
    protected static final Logger logger;

    static {
        TWO_PORT_EXPRESSION_MODES.addAll(EXPRESSION_MODE);
        TWO_PORT_EXPRESSION_MODES.add("Evaluate when input to a and cache b");
        logger = LoggerFactory.getLogger(AbstractDataMessageTransformer2Port.class);
    }

    public AbstractDataMessageTransformer2Port(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.input.setName("a");
        this.inputPort2 = PortFactory.getInstance().createInputPort((Entity)this, "b", ManagedMessage.class);
        this.passModeParameter.setExpression(TWO_PORT_EXPRESSION_MODES.get(2));
        this.passMode = TWO_PORT_EXPRESSION_MODES.get(2);
    }

    public void doPreInitialize() {
        this.port1Cache.clear();
        this.port2Cache.clear();
    }

    @Override
    protected List<String> getExpressionModes() {
        return TWO_PORT_EXPRESSION_MODES;
    }

    @Override
    protected boolean isFireInLoop() {
        if (this.port1Cache == null || this.port1Cache.size() < this.getMinimumCacheSize()) {
            return false;
        }
        if (this.port2Cache == null || this.port2Cache.size() < this.getMinimumCacheSize()) {
            return false;
        }
        return super.isFireInLoop();
    }

    protected int getMinimumCacheSize() {
        return 1;
    }

    protected abstract DataMessageComponent getTransformedMessage(List<DataMessageComponent> var1, List<DataMessageComponent> var2) throws ProcessingException;

    @Override
    protected void doInitialize() throws InitializationException {
        this.inputHandler2 = new PortHandler((IOPort)this.inputPort2);
        if (this.inputPort2.getWidth() > 0) {
            this.inputHandler2.start();
        }
        super.doInitialize();
    }

    @Override
    protected boolean doPreFire() throws ProcessingException {
        if (this.passMode.equals(TWO_PORT_EXPRESSION_MODES.get(2))) {
            Token token = null;
            try {
                while ((token = this.inputHandler2.getToken()) != null) {
                    ManagedMessage managedMessage = MessageHelper.getMessageFromToken((Token)token);
                    DataMessageComponent dataMessageComponent = MessageUtils.coerceMessage(managedMessage);
                    this.port2Cache.add(dataMessageComponent);
                }
            }
            catch (Exception exception) {
                throw new ProcessingException("Error handling token", (Object)token, (Throwable)exception);
            }
        }
        Token token = this.inputHandler2.getToken();
        if (token != null) {
            try {
                ManagedMessage managedMessage = MessageHelper.getMessageFromToken((Token)token);
                DataMessageComponent dataMessageComponent = MessageUtils.coerceMessage(managedMessage);
                this.port2Cache.add(dataMessageComponent);
            }
            catch (Exception exception) {
                throw new ProcessingException("Error handling token", (Object)token, (Throwable)exception);
            }
        }
        return super.doPreFire();
    }

    protected void doFire(ManagedMessage managedMessage) throws ProcessingException {
        try {
            DataMessageComponent dataMessageComponent;
            if (managedMessage != null) {
                dataMessageComponent = MessageUtils.coerceMessage(managedMessage);
                this.port1Cache.add(dataMessageComponent);
            }
            if (this.isFireInLoop() || this.isLoopPort1SumPort2(true)) {
                dataMessageComponent = this.getDespatch();
                if (dataMessageComponent == null) {
                    return;
                }
                this.sendOutputMsg(this.output, MessageUtils.getDataMessage(dataMessageComponent));
            }
        }
        catch (ProcessingException processingException) {
            throw processingException;
        }
        catch (Exception exception) {
            throw this.createDataMessageException("Cannot add data from '" + managedMessage + "'", exception);
        }
    }

    private DataMessageComponent getDespatch() throws ProcessingException {
        try {
            ActorUtils.setActorExecuting((Actor)this, true);
            if (MessageUtils.isScalarOnly(this.port1Cache)) {
                throw this.createDataMessageException("Cannot send messages with scalar data only to port 'a' of '" + this.getName() + "'", null);
            }
            DataMessageComponent dataMessageComponent = this.getTransformedMessage(this.port1Cache, MessageUtils.mergeScalar(this.port2Cache));
            if (dataMessageComponent != null) {
                this.setDataNames(dataMessageComponent, this.port1Cache);
            }
            this.port1Cache.clear();
            if (!this.isLoopPort1SumPort2(false)) {
                this.port2Cache.clear();
            }
            if (dataMessageComponent == null) {
                return null;
            }
            dataMessageComponent.putScalar("operation.time." + this.getName(), DateFormat.getDateTimeInstance().format(new Date()));
            dataMessageComponent.putScalar("operation.type." + this.getName(), this.getOperationName());
            DataMessageComponent dataMessageComponent2 = dataMessageComponent;
            return dataMessageComponent2;
        }
        finally {
            ActorUtils.setActorExecuting((Actor)this, false);
        }
    }

    protected boolean doPostFire() throws ProcessingException {
        boolean bl = this.isFinishRequested();
        boolean bl2 = this.isInputRoundComplete();
        if (bl2 && this.isFireEndLoop()) {
            try {
                DataMessageComponent dataMessageComponent = this.getDespatch();
                if (dataMessageComponent == null) {
                    return !bl;
                }
                this.sendOutputMsg(this.output, MessageUtils.getDataMessage(dataMessageComponent));
            }
            catch (ProcessingException processingException) {
                throw processingException;
            }
            catch (Exception exception) {
                logger.error("Cannot transform data", (Throwable)exception);
            }
        }
        return !bl;
    }

    @Override
    protected void doWrapUp() throws TerminationException {
        super.doWrapUp();
        if (this.isFinishRequested()) {
            this.port1Cache.clear();
            this.port2Cache.clear();
        }
    }

    protected boolean isLoopPort1SumPort2(boolean bl) {
        if (bl) {
            if (this.port1Cache == null || this.port1Cache.size() < this.getMinimumCacheSize()) {
                return false;
            }
            if (this.passMode.equals(TWO_PORT_EXPRESSION_MODES.get(2))) {
                int n = this.inputPort2.getWidth();
                if (this.port2Cache == null || this.port2Cache.size() < n) {
                    return false;
                }
            } else if (this.port2Cache == null || this.port2Cache.size() < this.getMinimumCacheSize()) {
                return false;
            }
        }
        return this.passMode.equals(TWO_PORT_EXPRESSION_MODES.get(2));
    }

    protected void setUpstreamValues(DataMessageComponent dataMessageComponent, List<DataMessageComponent> list, List<DataMessageComponent> list2) {
        dataMessageComponent.setMeta(MessageUtils.getMeta(list));
        dataMessageComponent.addScalar(MessageUtils.getScalar(list));
        dataMessageComponent.addScalar(MessageUtils.getScalar(list2), false);
    }

    protected DataMessageException createDataMessageException(String string, Throwable throwable) throws DataMessageException {
        ArrayList<DataMessageComponent> arrayList = new ArrayList<DataMessageComponent>(7);
        arrayList.addAll(this.port2Cache);
        arrayList.addAll(this.port1Cache);
        return new DataMessageException(string, (Object)this, arrayList, throwable);
    }
}

