/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.common.actors;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.TerminationException;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageFactory;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dawb.passerelle.common.actors.AbstractPassModeTransformer;
import org.dawb.passerelle.common.actors.ActorUtils;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.DataMessageException;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.MessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public abstract class AbstractDataMessageTransformer
extends AbstractPassModeTransformer {
    private static final long serialVersionUID = 8697753304302318301L;
    protected final List<DataMessageComponent> cache = new ArrayList<DataMessageComponent>(7);
    private static final Logger logger = LoggerFactory.getLogger(AbstractDataMessageTransformer.class);
    protected boolean alreadyFiredOneBlankMessage = false;

    public AbstractDataMessageTransformer(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
    }

    public void doPreInitialize() throws InitializationException {
        this.cache.clear();
    }

    @Override
    protected boolean doPreFire() throws ProcessingException {
        boolean bl = super.doPreFire();
        if (this.getMinimumCacheSize() < 1 && this.message == null && this.input.getWidth() < 1 && !this.alreadyFiredOneBlankMessage) {
            this.alreadyFiredOneBlankMessage = true;
            this.message = MessageFactory.getInstance().createMessage();
        }
        return bl;
    }

    protected abstract DataMessageComponent getTransformedMessage(List<DataMessageComponent> var1) throws ProcessingException;

    protected void doFire(ManagedMessage managedMessage) throws ProcessingException {
        try {
            DataMessageComponent dataMessageComponent;
            if (managedMessage != null) {
                dataMessageComponent = MessageUtils.coerceMessage(managedMessage);
                this.cache.add(dataMessageComponent);
            }
            if (this.isFireInLoop()) {
                dataMessageComponent = this.getDespatch();
                if (dataMessageComponent == null) {
                    return;
                }
                this.sendOutputMsg(this.output, MessageUtils.getDataMessage(dataMessageComponent));
                this.cache.clear();
            }
        }
        catch (ProcessingException processingException) {
            throw processingException;
        }
        catch (Exception exception) {
            throw this.createDataMessageException("Cannot add data from '" + managedMessage + "'", exception);
        }
    }

    private DataMessageComponent getDespatch() throws ProcessingException {
        try {
            ActorUtils.setActorExecuting((Actor)this, true);
            DataMessageComponent dataMessageComponent = this.getTransformedMessage(this.cache);
            if (dataMessageComponent != null) {
                this.setDataNames(dataMessageComponent, this.cache);
            }
            if (dataMessageComponent == null) {
                return null;
            }
            dataMessageComponent.putScalar("operation.time." + this.getName(), DateFormat.getDateTimeInstance().format(new Date()));
            dataMessageComponent.putScalar("operation.type." + this.getName(), this.getOperationName());
            DataMessageComponent dataMessageComponent2 = dataMessageComponent;
            return dataMessageComponent2;
        }
        finally {
            ActorUtils.setActorExecuting((Actor)this, false);
        }
    }

    @Override
    protected boolean isFireInLoop() {
        if (this.cache == null || this.cache.size() < this.getMinimumCacheSize()) {
            return false;
        }
        return super.isFireInLoop();
    }

    protected int getMinimumCacheSize() {
        return 1;
    }

    protected boolean doPostFire() throws ProcessingException {
        boolean bl = this.isFinishRequested();
        boolean bl2 = this.isInputRoundComplete();
        if (bl2 && this.isFireEndLoop() && this.cache.size() >= this.getMinimumCacheSize()) {
            DataMessageComponent dataMessageComponent = null;
            try {
                dataMessageComponent = this.getDespatch();
                if (dataMessageComponent == null) {
                    return !bl;
                }
                this.sendOutputMsg(this.output, MessageUtils.getDataMessage(dataMessageComponent));
            }
            catch (ProcessingException processingException) {
                throw processingException;
            }
            catch (Exception exception) {
                logger.error("Cannot add data from '" + dataMessageComponent + "'", (Throwable)exception);
            }
        }
        return !bl;
    }

    @Override
    protected void doWrapUp() throws TerminationException {
        super.doWrapUp();
        if (this.isFinishRequested()) {
            this.cache.clear();
        }
    }

    protected DataMessageException createDataMessageException(String string, Throwable throwable) throws DataMessageException {
        return new DataMessageException(string, (Object)this, this.cache, throwable);
    }

    protected String getModelPath() {
        if (this.getContainer() == null) {
            return null;
        }
        String string = this.getContainer().getSource();
        return string;
    }

    public Map<String, String> getExampleValues() {
        HashMap<String, String> hashMap = new HashMap<String, String>(7);
        List<IVariable> list = this.getInputVariables();
        int n = 0;
        while (n < list.size()) {
            IVariable iVariable = list.get(n);
            if (iVariable != null) {
                Object object = iVariable.getExampleValue();
                hashMap.put(iVariable.getVariableName(), object != null ? object.toString() : "");
            }
            ++n;
        }
        return hashMap;
    }
}

