/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.common.actors;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.TriggeredSource;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.workbench.model.utils.ModelUtils;
import java.util.ArrayList;
import java.util.List;
import org.dawb.passerelle.common.actors.ActorUtils;
import org.dawb.passerelle.common.message.DataMessageException;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.IVariableProvider;
import org.dawb.passerelle.common.message.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.actor.NoRoomException;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public abstract class AbstractDataMessageSource
extends TriggeredSource
implements IVariableProvider {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDataMessageSource.class);
    private static final long serialVersionUID = -5224572869848106075L;
    protected ArrayList<IVariable> cachedUpstreamVariables = new ArrayList(7);

    public AbstractDataMessageSource(final CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        compositeEntity.addChangeListener(new ChangeListener(){

            public void changeFailed(ChangeRequest changeRequest, Exception exception) {
            }

            public void changeExecuted(ChangeRequest changeRequest) {
                AbstractDataMessageSource.this.cachedUpstreamVariables.clear();
                if (!compositeEntity.deepContains((NamedObj)AbstractDataMessageSource.this)) {
                    compositeEntity.removeChangeListener((ChangeListener)this);
                }
            }
        });
    }

    protected final ManagedMessage getMessage() throws ProcessingException {
        try {
            ActorUtils.setActorExecuting((Actor)this, true);
            ManagedMessage managedMessage = this.getDataMessage();
            return managedMessage;
        }
        finally {
            ActorUtils.setActorExecuting((Actor)this, false);
        }
    }

    protected abstract ManagedMessage getDataMessage() throws ProcessingException;

    @Override
    public List<IVariable> getOutputVariables() {
        return this.getScalarOutputVariables();
    }

    protected List<IVariable> getScalarOutputVariables() {
        ArrayList<IVariable> arrayList = new ArrayList<IVariable>(7);
        List<IVariable> list = this.getInputVariables();
        for (IVariable iVariable : list) {
            if (iVariable.getVariableType() != IVariable.VARIABLE_TYPE.PATH && iVariable.getVariableType() != IVariable.VARIABLE_TYPE.SCALAR && iVariable.getVariableType() != IVariable.VARIABLE_TYPE.XML) continue;
            arrayList.add(iVariable);
        }
        try {
            arrayList.add(new Variable("project_name", IVariable.VARIABLE_TYPE.SCALAR, ModelUtils.getProject((NamedObj)this).getName()));
        }
        catch (Exception exception) {
            logger.error("Cannot find project!", (Throwable)exception);
        }
        return arrayList;
    }

    protected void sendOutputMsg(Port port, ManagedMessage managedMessage) throws ProcessingException, IllegalArgumentException {
        if (port != this.output) {
            super.sendOutputMsg(port, managedMessage);
            return;
        }
        while (true) {
            try {
                super.sendOutputMsg(port, managedMessage);
            }
            catch (Exception exception) {
                if (exception.getCause() != null && exception.getCause() instanceof NoRoomException) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw (NoRoomException)exception.getCause();
                    }
                    continue;
                }
                throw this.createDataMessageException("Cannot send output!", exception);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IVariable> getInputVariables() {
        ArrayList<IVariable> arrayList = this.cachedUpstreamVariables;
        synchronized (arrayList) {
            if (this.cachedUpstreamVariables.isEmpty()) {
                List list = this.trigger.connectedPortList();
                for (Object e : list) {
                    List<IVariable> list2;
                    IOPort iOPort = (IOPort)e;
                    ptolemy.actor.Actor actor = (ptolemy.actor.Actor)iOPort.getContainer();
                    if (!(actor instanceof IVariableProvider) || (list2 = ((IVariableProvider)actor).getOutputVariables()) == null) continue;
                    this.cachedUpstreamVariables.addAll(list2);
                }
            }
        }
        return this.cachedUpstreamVariables;
    }

    public boolean isUpstreamVariable(String string) {
        List<IVariable> list = this.getInputVariables();
        for (IVariable iVariable : list) {
            if (!iVariable.getVariableName().equals(string)) continue;
            return true;
        }
        return false;
    }

    protected DataMessageException createDataMessageException(String string, Throwable throwable) throws DataMessageException {
        return new DataMessageException(string, this, throwable);
    }

    protected String getModelPath() {
        if (this.getContainer() == null) {
            return null;
        }
        String string = this.getContainer().getSource();
        return string;
    }
}

