/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.common.actors;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.TerminationException;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.internal.ErrorMessageContainer;
import java.util.ArrayList;
import java.util.List;
import org.dawb.passerelle.common.actors.AbstractPassModeSink;
import org.dawb.passerelle.common.actors.ActorUtils;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.DataMessageException;
import org.dawb.passerelle.common.message.MessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public abstract class AbstractDataMessageSink
extends AbstractPassModeSink {
    private static Logger logger = LoggerFactory.getLogger(AbstractDataMessageSink.class);
    private static final long serialVersionUID = -8638005806521694925L;
    private List<DataMessageComponent> cache = new ArrayList<DataMessageComponent>(7);
    private boolean firedOnce = false;

    public AbstractDataMessageSink(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
    }

    public void doPreInitialize() {
        this.cache.clear();
    }

    protected void sendMessage(ManagedMessage managedMessage) throws ProcessingException {
        try {
            DataMessageComponent dataMessageComponent = MessageUtils.coerceMessage(managedMessage);
            if (this.isFireOnce()) {
                if (!this.firedOnce) {
                    this.cache.add(dataMessageComponent);
                    this.sendCachedDataInternal(this.cache);
                    this.firedOnce = true;
                } else {
                    this.cache.clear();
                    return;
                }
            }
            this.cache.add(dataMessageComponent);
            if (managedMessage instanceof ErrorMessageContainer) {
                this.sendCachedDataInternal(this.cache);
                this.cache.clear();
                this.requestFinish();
            } else if (this.isFireInLoop()) {
                this.sendCachedDataInternal(this.cache);
                this.cache.clear();
            }
        }
        catch (ProcessingException processingException) {
            throw processingException;
        }
        catch (Exception exception) {
            throw this.createDataMessageException("Cannot add data from '" + managedMessage + "'", exception);
        }
    }

    private void sendCachedDataInternal(List<DataMessageComponent> list) throws ProcessingException {
        try {
            ActorUtils.setActorExecuting((Actor)this, true);
            this.sendCachedData(list);
        }
        finally {
            ActorUtils.setActorExecuting((Actor)this, false);
        }
    }

    protected abstract void sendCachedData(List<DataMessageComponent> var1) throws ProcessingException;

    protected boolean doPostFire() throws ProcessingException {
        boolean bl = this.isFinishRequested();
        boolean bl2 = this.isInputRoundComplete();
        if (bl2 && this.isFireEndLoop() || bl && this.isFireOnFinished()) {
            try {
                if (!this.cache.isEmpty()) {
                    this.sendCachedDataInternal(this.cache);
                }
            }
            catch (ProcessingException processingException) {
                throw processingException;
            }
            catch (Exception exception) {
                logger.error("Cannot process data", (Throwable)exception);
            }
        }
        return !bl;
    }

    protected void doWrapUp() throws TerminationException {
        super.doWrapUp();
        if (this.isFinishRequested()) {
            this.cache.clear();
        }
    }

    protected DataMessageException createDataMessageException(String string, Throwable throwable) throws DataMessageException {
        return new DataMessageException(string, (Object)this, this.cache, throwable);
    }
}

