/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.common;

import java.io.IOException;
import org.dawb.passerelle.common.remote.RemoteServiceProviderImpl;
import org.dawb.workbench.jmx.IRemoteServiceProvider;
import org.dawb.workbench.jmx.RemoteWorkbenchAgent;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkbenchServiceManager
implements IStartup {
    private static Logger logger = LoggerFactory.getLogger(WorkbenchServiceManager.class);
    private static boolean addedWorkbenchListener = false;
    private static RemoteWorkbenchAgent agent;

    public void earlyStartup() {
        WorkbenchServiceManager.startWorkbenchService();
    }

    public static void startWorkbenchService() {
        WorkbenchServiceManager.startWorkbenchService(true);
    }

    public static void startTestingWorkbenchService() {
        WorkbenchServiceManager.startWorkbenchService(false);
    }

    private static void startWorkbenchService(boolean bl) {
        if (agent != null) {
            return;
        }
        if (bl) {
            if (!PlatformUI.isWorkbenchRunning()) {
                return;
            }
            if (!WorkbenchServiceManager.isUserInterfaceApplication()) {
                return;
            }
        }
        logger.debug("Running workbench not workflow, starting workbench service.");
        if (System.getProperty("org.edna.workbench.application.no.service") == null) {
            RemoteServiceProviderImpl remoteServiceProviderImpl = new RemoteServiceProviderImpl();
            try {
                agent = new RemoteWorkbenchAgent((IRemoteServiceProvider)remoteServiceProviderImpl);
                agent.start();
            }
            catch (IOException iOException) {
                logger.debug("The service for the workbench is already running.");
            }
            catch (Exception exception) {
                logger.error("Cannot start workbench service!", (Throwable)exception);
            }
            if (!addedWorkbenchListener) {
                addedWorkbenchListener = true;
                if (PlatformUI.isWorkbenchRunning()) {
                    PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

                        public void postShutdown(IWorkbench iWorkbench) {
                            WorkbenchServiceManager.stopWorkbenchService();
                        }

                        public boolean preShutdown(IWorkbench iWorkbench, boolean bl) {
                            return true;
                        }
                    });
                }
            }
        }
    }

    private static boolean isUserInterfaceApplication() {
        if (PlatformUI.getWorkbench() == null) {
            return false;
        }
        if (PlatformUI.getWorkbench().getDisplay() == null) {
            return false;
        }
        final Boolean[] booleanArray = new Boolean[]{Boolean.FALSE};
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (PlatformUI.getWorkbench().getDisplay().getShells().length > 0) {
                    booleanArray[0] = Boolean.TRUE;
                }
            }
        });
        return booleanArray[0] != false;
    }

    public static void stopWorkbenchService() {
        try {
            if (agent != null) {
                agent.stop();
                agent = null;
            }
        }
        catch (Throwable throwable) {}
    }
}

