/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.wizards.project;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.python.pydev.core.callbacks.ICallback;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.PyStructureConfigHelpers;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.ui.wizards.gettingstarted.AbstractNewProjectWizard;
import org.python.pydev.ui.wizards.project.IWizardNewProjectNameAndLocationPage;
import org.python.pydev.ui.wizards.project.NewProjectNameAndLocationWizardPage;

public class PythonProjectWizard
extends AbstractNewProjectWizard
implements IExecutableExtension {
    protected IStructuredSelection selection;
    public static final String WIZARD_ID = "org.python.pydev.ui.wizards.project.PythonProjectWizard";
    protected IWizardNewProjectNameAndLocationPage projectPage;
    Shell shell;
    IProject generatedProject;
    Exception creationThreadException;
    private IProject createdProject;
    private IConfigurationElement fConfigElement;
    protected IWorkbench workbench;

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.selection = currentSelection;
        this.workbench = workbench;
        this.initializeDefaultPageImageDescriptor();
        this.projectPage = this.createProjectPage();
    }

    protected IWizardNewProjectNameAndLocationPage createProjectPage() {
        return new NewProjectNameAndLocationWizardPage("Setting project properties");
    }

    public void addPages() {
        this.addPage(this.projectPage);
        this.addProjectReferencePage();
    }

    protected IProject createNewProject(final Object ... additionalArgsToConfigProject) {
        IProject[] refProjects;
        IPath newPath;
        final IProject newProjectHandle = this.projectPage.getProjectHandle();
        IPath defaultPath = Platform.getLocation();
        if (defaultPath.equals((Object)(newPath = this.projectPage.getLocationPath()))) {
            newPath = null;
        } else {
            IPath withName = defaultPath.append(newProjectHandle.getName());
            if (newPath.toFile().equals(withName.toFile())) {
                newPath = null;
            }
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocation(newPath);
        if (this.referencePage != null && (refProjects = this.referencePage.getReferencedProjects()).length > 0) {
            description.setReferencedProjects(refProjects);
        }
        final String projectType = this.projectPage.getProjectType();
        final String projectInterpreter = this.projectPage.getProjectInterpreter();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                PythonProjectWizard.this.createAndConfigProject(newProjectHandle, description, projectType, projectInterpreter, monitor, additionalArgsToConfigProject);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                if (((CoreException)t).getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Unable to create project", (String)"Another project with the same name (and different case) already exists.");
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)"Unable to create project", null, (IStatus)((CoreException)t).getStatus());
                }
            } else {
                Log.log((int)4, (String)t.toString(), (Throwable)t);
                MessageDialog.openError((Shell)this.getShell(), (String)"Unable to create project", (String)t.getMessage());
            }
            return null;
        }
        return newProjectHandle;
    }

    protected void createAndConfigProject(IProject newProjectHandle, IProjectDescription description, String projectType, String projectInterpreter, IProgressMonitor monitor, Object ... additionalArgsToConfigProject) throws CoreException {
        ICallback<List<IContainer>, IProject> getSourceFolderHandlesCallback = new ICallback<List<IContainer>, IProject>(){

            public List<IContainer> call(IProject projectHandle) {
                int sourceFolderConfigurationStyle = PythonProjectWizard.this.projectPage.getSourceFolderConfigurationStyle();
                ArrayList<IContainer> ret = new ArrayList<IContainer>();
                switch (sourceFolderConfigurationStyle) {
                    case 1: {
                        ret = new ArrayList();
                        ret.add((IContainer)projectHandle);
                        return ret;
                    }
                    case 2: {
                        return new ArrayList<IContainer>();
                    }
                }
                IFolder folder = projectHandle.getFolder("src");
                ret = new ArrayList();
                ret.add((IContainer)folder);
                return ret;
            }
        };
        PyStructureConfigHelpers.createPydevProject(description, newProjectHandle, monitor, projectType, projectInterpreter, getSourceFolderHandlesCallback, null);
    }

    public boolean performFinish() {
        this.createdProject = this.createNewProject(new Object[0]);
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
        return true;
    }

    public IProject getCreatedProject() {
        return this.createdProject;
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = PydevPlugin.imageDescriptorFromPlugin((String)PydevPlugin.getPluginID(), (String)"icons/python_logo.png");
        this.setDefaultPageImageDescriptor(desc);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fConfigElement = config;
    }
}

