/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.pythonpathconf;

import at.jta.Key;
import at.jta.Regor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.ListDialog;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.ui.pythonpathconf.AbstractInterpreterEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonInterpreterEditor
extends AbstractInterpreterEditor {
    public PythonInterpreterEditor(String labelText, Composite parent, IInterpreterManager interpreterManager) {
        super("INTERPRETER_PATH_NEW", labelText, parent, interpreterManager);
    }

    @Override
    public String[] getInterpreterFilterExtensions() {
        if (REF.isWindowsPlatform()) {
            return new String[]{"*.exe", "*.*"};
        }
        return null;
    }

    @Override
    protected Tuple<String, String> getAutoNewInput() throws AbstractInterpreterEditor.CancelException {
        ArrayList<String> pathsToSearch = new ArrayList<String>();
        if (!REF.isWindowsPlatform()) {
            pathsToSearch.add("/usr/bin");
            pathsToSearch.add("/usr/local/bin");
            Tuple<String, String> ret = super.getAutoNewInputFromPaths(pathsToSearch, "python", "python");
            if (ret != null) {
                return ret;
            }
        } else {
            ArrayList<File> foundVersions = new ArrayList<File>();
            try {
                Regor regor = new Regor();
                Key[] keyArray = new Key[]{Regor.HKEY_LOCAL_MACHINE, Regor.HKEY_CURRENT_USER};
                int n = keyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Key root = keyArray[n2];
                    Key key = regor.openKey(root, "Software\\Python\\PythonCore");
                    if (key != null) {
                        try {
                            List l = regor.listKeys(key);
                            for (Object o : l) {
                                Key openKey = regor.openKey(key, String.valueOf((String)o) + "\\InstallPath");
                                if (openKey == null) continue;
                                try {
                                    String parseValue;
                                    File file;
                                    byte[] buf = regor.readValue(openKey, "");
                                    if (buf == null || !(file = new File(parseValue = Regor.parseValue((byte[])buf), "python.exe")).isFile()) continue;
                                    foundVersions.add(file);
                                }
                                finally {
                                    regor.closeKey(openKey);
                                }
                            }
                        }
                        finally {
                            regor.closeKey(key);
                        }
                    }
                    ++n2;
                }
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
            }
            if (foundVersions.size() == 1) {
                return new Tuple((Object)this.getUniqueInterpreterName("python"), (Object)((File)foundVersions.get(0)).toString());
            }
            if (foundVersions.size() > 1) {
                ListDialog listDialog = new ListDialog(PyAction.getShell());
                listDialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                listDialog.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public Image getImage(Object element) {
                        return PydevPlugin.getImageCache().get("icons/python_16x16.png");
                    }
                });
                listDialog.setInput((Object)foundVersions.toArray());
                listDialog.setMessage("Multiple interpreters were found installed.\nPlease select which one you want to configure.");
                int open = listDialog.open();
                if (open != 0) {
                    throw this.cancelException;
                }
                Object[] result = listDialog.getResult();
                if (result == null || result.length == 0) {
                    throw this.cancelException;
                }
                return new Tuple((Object)this.getUniqueInterpreterName("python"), (Object)result[0].toString());
            }
        }
        return new Tuple((Object)this.getUniqueInterpreterName("python"), (Object)"python");
    }

    @Override
    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns);
        this.autoConfigButton.setToolTipText("Will try to find Python on the PATH (will fail if not available)");
    }
}

