/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.editors;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.ui.dialogs.MapOfStringsInputDialog;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TreeWithAddRemove
extends Composite {
    protected Tree tree;
    public static final int EDITING_STYLE_ARRAY_OF_STRINGS = 0;
    public static final int EDITING_STYLE_MAP_OF_STRINGS = 1;
    private int editingStyle;
    private static String lastDirectoryDialogPath = null;
    private static String lastFileDialogPath = null;

    public TreeWithAddRemove(Composite parent, int style, Object initialItems) {
        this(parent, style, initialItems, false);
    }

    public TreeWithAddRemove(Composite parent, int style, Object initialItems, boolean createEditButton) {
        super(parent, style);
        if (initialItems == null) {
            initialItems = new String[]{};
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        this.tree = new Tree((Composite)this, 2050);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.tree.setLayoutData((Object)data);
        Composite buttonsSourceFolders = new Composite((Composite)this, 0);
        buttonsSourceFolders.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonsSourceFolders.setLayout((Layout)layout);
        int i = 0;
        while (i < this.getNumberOfAddButtons()) {
            this.createAddButton(buttonsSourceFolders, i);
            ++i;
        }
        this.createRemoveButton(buttonsSourceFolders);
        if (createEditButton) {
            this.createEditButton(buttonsSourceFolders);
        }
        if (initialItems instanceof String[]) {
            this.editingStyle = 0;
        } else if (initialItems instanceof Map) {
            this.editingStyle = 1;
            this.tree.setHeaderVisible(true);
            TreeColumn column1 = new TreeColumn(this.tree, 16384);
            column1.setText("Key");
            column1.setWidth(200);
            TreeColumn column2 = new TreeColumn(this.tree, 16384);
            column2.setText("Value");
            column2.setWidth(200);
        } else {
            throw new RuntimeException("Unexpected initial items: " + initialItems);
        }
        this.setTreeItems(initialItems);
    }

    public void setTreeItems(Object items) {
        this.tree.removeAll();
        switch (this.editingStyle) {
            case 0: {
                String[] its = (String[])items;
                int i = 0;
                while (i < its.length) {
                    this.addTreeItem(its[i]);
                    ++i;
                }
                break;
            }
            case 1: {
                Map map = (Map)items;
                for (Map.Entry entry : map.entrySet()) {
                    this.addTreeItem((String)entry.getKey(), (String)entry.getValue());
                }
                break;
            }
        }
    }

    private void configButtonLayout(Button button) {
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)data);
    }

    protected void createAddButton(Composite buttonsSourceFolders, int buttonNumber) {
        Button buttonAddSourceFolder = new Button(buttonsSourceFolders, 8);
        this.customizeAddSomethingButton(buttonAddSourceFolder, buttonNumber);
        buttonAddSourceFolder.setText(this.getButtonLabel(buttonNumber));
        this.configButtonLayout(buttonAddSourceFolder);
    }

    protected void createRemoveButton(Composite buttonsSourceFolders) {
        Button buttonRemSourceFolder = new Button(buttonsSourceFolders, 8);
        this.customizeRemSourceFolderButton(buttonRemSourceFolder);
        this.configButtonLayout(buttonRemSourceFolder);
    }

    protected void createEditButton(Composite buttonsSourceFolders) {
        Button buttonEdit = new Button(buttonsSourceFolders, 8);
        this.customizeEditButton(buttonEdit);
        this.configButtonLayout(buttonEdit);
    }

    protected void customizeRemSourceFolderButton(Button buttonRem) {
        buttonRem.setText(this.getButtonRemoveText());
        buttonRem.setToolTipText("Remove the selected item");
        buttonRem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeWithAddRemove.this.handleRemove();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void customizeEditButton(Button buttonEdit) {
        buttonEdit.setText(this.getButtonEditText());
        buttonEdit.setToolTipText("Edit the selected item");
        buttonEdit.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeWithAddRemove.this.handleEdit();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void customizeAddSomethingButton(Button addButton, final int nButton) {
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeWithAddRemove.this.handleAddButtonSelected(nButton);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void addItemWithDialog(MapOfStringsInputDialog dialog) {
        Tuple<String, String> keyAndValueEntered;
        if (dialog.open() == 0 && (keyAndValueEntered = dialog.getKeyAndValueEntered()) != null) {
            this.addTreeItem((String)keyAndValueEntered.o1, (String)keyAndValueEntered.o2);
        }
    }

    public void addItemWithDialog(InputDialog dialog) {
        dialog.open();
        String value = dialog.getValue();
        this.addTreeItem(value);
    }

    public void addItemWithDialog(FileDialog dialog) {
        dialog.setFilterPath(lastFileDialogPath);
        dialog.open();
        String[] fileNames = dialog.getFileNames();
        String parent = dialog.getFilterPath();
        if (fileNames != null && fileNames.length > 0) {
            String[] stringArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.addTreeItem(REF.getFileAbsolutePath((File)new File(parent, s)));
                ++n2;
            }
        }
    }

    public void addItemWithDialog(DirectoryDialog dialog) {
        dialog.setFilterPath(lastDirectoryDialogPath);
        String filePath = dialog.open();
        if (filePath != null) {
            lastDirectoryDialogPath = filePath;
        }
        this.addTreeItem(filePath);
    }

    public void addItemWithDialog(SelectionDialog dialog) {
        dialog.open();
        Object[] objects = dialog.getResult();
        if (objects != null) {
            int i = 0;
            while (i < objects.length) {
                String pathAsString;
                IPath p;
                Object object = objects[i];
                if (object instanceof IPath) {
                    p = (IPath)object;
                    pathAsString = this.getPathAsString(p);
                    this.addTreeItem(pathAsString);
                } else if (object instanceof IFile) {
                    p = (IFile)object;
                    pathAsString = this.getPathAsString(p.getProjectRelativePath());
                    pathAsString = "/" + p.getProject().getName() + pathAsString;
                    if (FileTypesPreferencesPage.isValidZipFile(pathAsString)) {
                        this.addTreeItem(pathAsString);
                    }
                }
                ++i;
            }
        }
    }

    private String getPathAsString(IPath p) {
        String ret = p.toString();
        if (!ret.startsWith("/")) {
            ret = "/" + ret;
        }
        return ret;
    }

    private void addTreeItem(String pathAsString) {
        if (pathAsString != null && pathAsString.trim().length() > 0) {
            TreeItem item = new TreeItem(this.tree, 0);
            item.setText(pathAsString);
            item.setImage(PydevPlugin.getImageCache().get(this.getImageConstant()));
        }
    }

    protected void addTreeItem(String key, String value) {
        if (key != null && key.trim().length() > 0 && value != null && value.trim().length() > 0) {
            TreeItem item = new TreeItem(this.tree, 0);
            item.setText(new String[]{key, value});
            item.setImage(PydevPlugin.getImageCache().get(this.getImageConstant()));
        }
    }

    public String getTreeItemsAsStr() {
        if (this.editingStyle != 0) {
            throw new AssertionError((Object)"Can only call it if we're dealing with array of strings.");
        }
        FastStringBuffer ret = new FastStringBuffer();
        TreeItem[] items = this.tree.getItems();
        int i = 0;
        while (i < items.length) {
            String text = items[i].getText();
            if (text != null && text.trim().length() > 0) {
                if (ret.length() > 0) {
                    ret.append("|");
                }
                ret.append(text);
            }
            ++i;
        }
        return ret.toString();
    }

    public Map<String, String> getTreeItemsAsMap() {
        if (this.editingStyle != 1) {
            throw new AssertionError((Object)"Can only call it if we're dealing with map of strings.");
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        TreeItem[] items = this.tree.getItems();
        int i = 0;
        while (i < items.length) {
            String text0 = items[i].getText(0);
            String text1 = items[i].getText(1);
            if (text0 != null && text0.trim().length() > 0 && text1 != null && text1.trim().length() > 0) {
                ret.put(text0.trim(), text1.trim());
            }
            ++i;
        }
        return ret;
    }

    protected String getButtonRemoveText() {
        return "Remove";
    }

    protected String getButtonEditText() {
        return "Edit";
    }

    protected void handleRemove() {
        TreeItem[] selection = this.tree.getSelection();
        int i = 0;
        while (i < selection.length) {
            selection[i].dispose();
            ++i;
        }
    }

    protected abstract String getButtonLabel(int var1);

    protected abstract String getImageConstant();

    protected abstract void handleAddButtonSelected(int var1);

    protected void handleEdit() {
        throw new RuntimeException("Not implemented");
    }

    protected int getNumberOfAddButtons() {
        return 3;
    }
}

