/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.python.pydev.ui.dialogs.ProjectFolderSelectionGroup;

public class ProjectFolderSelectionDialog
extends SelectionDialog {
    ProjectFolderSelectionGroup group;
    private IProject initialSelection;
    private boolean allowNewContainerName = true;
    Label statusMessage;
    ISelectionValidator validator;
    private boolean showClosedProjects = true;

    public ProjectFolderSelectionDialog(Shell parentShell, IProject initialRoot, boolean allowNewContainerName, String message) {
        super(parentShell);
        this.setTitle("Selection dialog");
        this.initialSelection = initialRoot;
        this.allowNewContainerName = allowNewContainerName;
        this.setMessage(message);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (ProjectFolderSelectionDialog.this.statusMessage != null && ProjectFolderSelectionDialog.this.validator != null) {
                    String errorMsg = ProjectFolderSelectionDialog.this.validator.isValid((Object)ProjectFolderSelectionDialog.this.group.getContainerFullPath());
                    if (errorMsg == null || errorMsg.equals("")) {
                        ProjectFolderSelectionDialog.this.statusMessage.setText("");
                        ProjectFolderSelectionDialog.this.getOkButton().setEnabled(true);
                    } else {
                        ProjectFolderSelectionDialog.this.statusMessage.setForeground(JFaceColors.getErrorText((Display)ProjectFolderSelectionDialog.this.statusMessage.getDisplay()));
                        ProjectFolderSelectionDialog.this.statusMessage.setText(errorMsg);
                        ProjectFolderSelectionDialog.this.getOkButton().setEnabled(false);
                    }
                }
            }
        };
        this.group = new ProjectFolderSelectionGroup(area, listener, this.allowNewContainerName, this.getMessage(), this.showClosedProjects, this.initialSelection);
        if (this.initialSelection != null) {
            this.group.setSelectedContainer((IContainer)this.initialSelection);
        }
        this.statusMessage = new Label(parent, 0);
        this.statusMessage.setLayoutData((Object)new GridData(768));
        this.statusMessage.setFont(parent.getFont());
        return this.dialogArea;
    }

    protected void okPressed() {
        ArrayList<IPath> chosenContainerPathList = new ArrayList<IPath>();
        IPath returnValue = this.group.getContainerFullPath();
        if (returnValue != null) {
            chosenContainerPathList.add(returnValue);
        }
        this.setResult(chosenContainerPathList);
        super.okPressed();
    }

    public void setValidator(ISelectionValidator validator) {
        this.validator = validator;
    }

    public void showClosedProjects(boolean show) {
        this.showClosedProjects = show;
    }
}

