/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.outline;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.ListResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.bundle.ImageCache;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.IPyEditListener;
import org.python.pydev.editor.IPyEditListener2;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.outline.AbstractOutlineFilterAction;
import org.python.pydev.outline.IOutlineModel;
import org.python.pydev.outline.ParsedItem;
import org.python.pydev.outline.PyOutlinePage;
import org.python.pydev.parser.visitors.scope.ASTEntryWithChildren;

public class OutlineLinkWithEditorAction
extends AbstractOutlineFilterAction
implements IPyEditListener,
IPyEditListener2 {
    private static final String PREF_LINK_WITH_EDITOR = "org.python.pydev.PREF_LINK_WITH_EDITOR";
    private WeakReference<PyEdit> pyEdit;

    public OutlineLinkWithEditorAction(PyOutlinePage page, ImageCache imageCache) {
        super("Link With Editor", page, imageCache, PREF_LINK_WITH_EDITOR, "icons/sync_ed.gif");
        this.pyEdit = new WeakReference<PyEdit>(page.editorView);
        this.relink();
    }

    public void unlink() {
        PyEdit edit = (PyEdit)this.pyEdit.get();
        if (edit != null) {
            edit.removePyeditListener(this);
        }
    }

    public void relink() {
        PyEdit edit = (PyEdit)this.pyEdit.get();
        if (edit != null) {
            edit.addPyeditListener(this);
        }
    }

    public void dispose() {
        this.unlink();
    }

    protected ViewerFilter createFilter() {
        throw new RuntimeException("Not implemented: as setActionEnabled is overriden, this action is not needed (as this is not a filter action).");
    }

    protected void setActionEnabled(boolean enableAction) {
        PyOutlinePage p = (PyOutlinePage)this.page.get();
        if (p != null) {
            PyEdit edit;
            p.getStore().setValue(PREF_LINK_WITH_EDITOR, enableAction);
            if (enableAction && this.pyEdit != null && (edit = (PyEdit)this.pyEdit.get()) != null) {
                this.handleCursorPositionChanged(edit, new PySelection((ITextEditor)edit));
            }
        }
    }

    public void onCreateActions(ListResourceBundle resources, PyEdit edit, IProgressMonitor monitor) {
    }

    public void onDispose(PyEdit edit, IProgressMonitor monitor) {
    }

    public void onSave(PyEdit edit, IProgressMonitor monitor) {
    }

    public void onSetDocument(IDocument document, PyEdit edit, IProgressMonitor monitor) {
    }

    public void handleCursorPositionChanged(PyEdit edit, PySelection ps) {
        PyOutlinePage p = (PyOutlinePage)this.page.get();
        if (p != null && edit != null && this.isChecked()) {
            this.doLinkOutlinePosition(edit, p, ps);
        }
    }

    protected void doLinkOutlinePosition(PyEdit edit, PyOutlinePage p, PySelection ps) {
        StructuredSelection sel;
        ITextSelection t = ps.getTextSelection();
        IOutlineModel outlineModel = p.model;
        if (outlineModel != null && (sel = this.getSelectionPosition(outlineModel.getRoot(), t)) != null) {
            p.unlinkAll();
            try {
                p.setSelection((ISelection)sel);
            }
            finally {
                p.relinkAll();
            }
        }
    }

    private StructuredSelection getSelectionPosition(ParsedItem r, ITextSelection t) {
        try {
            ArrayList<ParsedItem> sel = new ArrayList<ParsedItem>();
            if (r != null) {
                ParsedItem item;
                do {
                    if ((item = this.findSel(r, t.getStartLine() + 1)) == null) continue;
                    sel.add(item);
                } while ((r = item) != null);
            }
            TreePath treePath = null;
            if (sel != null && sel.size() > 0) {
                treePath = new TreePath(sel.toArray());
            }
            if (treePath != null) {
                return new TreeSelection(treePath);
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return null;
    }

    private ParsedItem findSel(ParsedItem r, int startLine) {
        ParsedItem prev = null;
        ParsedItem[] children = r.getChildren();
        if (children != null) {
            ParsedItem[] parsedItemArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ParsedItem i = parsedItemArray[n2];
                ASTEntryWithChildren astThis = i.getAstThis();
                if (astThis != null && astThis.node != null) {
                    if (astThis.node.beginLine == startLine) {
                        prev = i;
                        break;
                    }
                    if (astThis.node.beginLine > startLine) break;
                }
                prev = i;
                ++n2;
            }
        }
        return prev;
    }
}

