/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.correctionassist.docstrings;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.bundle.ImageCache;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.codecompletion.PyCompletionProposal;
import org.python.pydev.editor.correctionassist.docstrings.DocstringsPrefPage;
import org.python.pydev.editor.correctionassist.heuristics.IAssistProps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssistDocString
implements IAssistProps {
    @Override
    public List<ICompletionProposal> getProps(PySelection ps, ImageCache imageCache, File f, IPythonNature nature, PyEdit edit, int offset) throws BadLocationException {
        ArrayList<ICompletionProposal> l = new ArrayList<ICompletionProposal>();
        Tuple tuple = ps.getInsideParentesisToks(false);
        if (tuple == null) {
            return l;
        }
        List params = (List)tuple.o1;
        String initial = PySelection.getIndentationFromLine((String)ps.getCursorLineContents());
        String delimiter = PyAction.getDelimiter(ps.getDoc());
        String indentation = PyAction.getStaticIndentationString(edit);
        String inAndIndent = String.valueOf(delimiter) + initial + indentation;
        FastStringBuffer buf = new FastStringBuffer();
        String docStringMarker = DocstringsPrefPage.getDocstringMarker();
        buf.append(String.valueOf(inAndIndent) + docStringMarker);
        buf.append(inAndIndent);
        int newOffset = buf.length();
        if (ps.isInFunctionLine(true)) {
            for (String paramName : params) {
                if (!PySelection.isIdentifier((String)paramName)) continue;
                buf.append(String.valueOf(inAndIndent) + "@param " + paramName + ":");
                if (!DocstringsPrefPage.getTypeTagShouldBeGenerated(paramName)) continue;
                buf.append(String.valueOf(inAndIndent) + "@type " + paramName + ":");
            }
        }
        buf.append(String.valueOf(inAndIndent) + docStringMarker);
        int lineOfOffset = ps.getLineOfOffset(((Integer)tuple.o2).intValue());
        String comp = buf.toString();
        int offsetPosToAdd = ps.getEndLineOffset(lineOfOffset);
        Image image = null;
        if (imageCache != null) {
            image = imageCache.get("icons/template.gif");
        }
        l.add(new PyCompletionProposal(comp, offsetPosToAdd, 0, newOffset, image, "Make docstring", null, null, 10){

            public void apply(IDocument document) {
                PySelection ps = new PySelection(document, this.fReplacementOffset);
                int iNextLine = ps.getCursorLine() + 1;
                String nextLine = ps.getLine(iNextLine);
                if (nextLine.trim().equals("pass")) {
                    ps.deleteLine(iNextLine);
                }
                super.apply(document);
            }
        });
        return l;
    }

    @Override
    public boolean isValid(PySelection ps, String sel, PyEdit edit, int offset) {
        return ps.isInFunctionLine(true) || ps.isInClassLine();
    }
}

