/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyAction;

public class PyShiftLeft
extends PyAction {
    public void run(IAction action) {
        try {
            if (!this.canModifyEditor()) {
                return;
            }
            PyEdit pyEdit = (PyEdit)this.getTextEditor();
            IIndentPrefs indentPrefs = pyEdit.getIndentPrefs();
            PySelection ps = new PySelection((ITextEditor)pyEdit);
            this.perform(ps, indentPrefs);
        }
        catch (Exception e) {
            PyShiftLeft.beep(e);
        }
    }

    public void perform(PySelection ps, IIndentPrefs indentPrefs) throws BadLocationException {
        int tabWidth;
        int endLineIndex = ps.getEndLineIndex();
        int startLineIndex = ps.getStartLineIndex();
        ps.selectCompleteLine();
        String selectedText = ps.getSelectedText();
        List ret = StringUtils.splitInLines((String)selectedText);
        int tabWidthToUse = tabWidth = indentPrefs.getTabWidth();
        for (String line : ret) {
            String lineIndent = PySelection.getIndentationFromLine((String)line);
            if (lineIndent.length() <= 0 || lineIndent.startsWith("\t")) continue;
            int spaces = 0;
            int i = 0;
            while (i < lineIndent.length()) {
                char c = lineIndent.charAt(i);
                if (c != ' ') break;
                ++spaces;
                ++i;
            }
            if (spaces <= 0) continue;
            tabWidthToUse = Math.min(spaces, tabWidthToUse);
        }
        String defaultIndentStr = StringUtils.createSpaceString((int)tabWidthToUse);
        IDocument doc = ps.getDoc();
        int i = startLineIndex;
        while (i <= endLineIndex) {
            String line = ps.getLine(i);
            if (line.startsWith("\t")) {
                doc.replace(ps.getLineOffset(i), 1, "");
            } else if (line.startsWith(defaultIndentStr)) {
                doc.replace(ps.getLineOffset(i), defaultIndentStr.length(), "");
            }
            ++i;
        }
    }
}

