/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.PythonPairMatcher;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyAction;

public class PyGoToMatchingBracket
extends PyAction {
    public void run(IAction action) {
        PyEdit pyEdit = this.getPyEdit();
        PySelection ps = new PySelection((ITextEditor)pyEdit);
        if (ps.getSelLength() != 0) {
            return;
        }
        try {
            PythonPairMatcher matcher;
            IRegion match;
            IDocument doc = ps.getDoc();
            char c = doc.getChar(ps.getAbsoluteCursorOffset() - 1);
            boolean opening = StringUtils.isOpeningPeer((char)c);
            boolean closing = StringUtils.isClosingPeer((char)c);
            if ((opening || closing) && (match = (matcher = new PythonPairMatcher()).match(doc, ps.getAbsoluteCursorOffset())) != null) {
                if (closing) {
                    pyEdit.setSelection(match.getOffset() + 1, 0);
                } else {
                    pyEdit.setSelection(match.getOffset() + match.getLength(), 0);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            return;
        }
    }
}

