/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import java.util.Collection;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.bindingutils.KeyBindingHelper;
import org.python.pydev.editor.actions.PyAction;

public class FirstCharAction
extends PyAction {
    protected SourceViewer viewer;

    public void run(IAction action) {
        try {
            ITextEditor textEditor = this.getTextEditor();
            IDocument doc = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
            ITextSelection selection = (ITextSelection)textEditor.getSelectionProvider().getSelection();
            this.perform(doc, selection);
        }
        catch (Exception e) {
            FirstCharAction.beep(e);
        }
    }

    private void perform(IDocument doc, ITextSelection selection) {
        boolean isAtFirstChar = this.isAtFirstVisibleChar(doc, selection.getOffset());
        if (!isAtFirstChar) {
            this.gotoFirstVisibleChar(doc, selection.getOffset());
        } else {
            this.gotoFirstChar(doc, selection.getOffset());
        }
    }

    protected void setCaretPosition(int pos) throws BadLocationException {
        this.viewer.setSelectedRange(pos, 0);
    }

    public static VerifyKeyListener createVerifyKeyListener(final SourceViewer viewer, IWorkbenchPartSite site, boolean forceCreation) {
        boolean isDefined;
        if (site != null) {
            ICommandService commandService = (ICommandService)site.getService(ICommandService.class);
            Collection definedCommandIds = commandService.getDefinedCommandIds();
            isDefined = definedCommandIds.contains("org.eclipse.ui.edit.text.goto.lineStart");
        } else {
            isDefined = false;
        }
        if (forceCreation || !isDefined) {
            return new VerifyKeyListener(){

                public void verifyKey(VerifyEvent event) {
                    if (event.doit) {
                        ISelection selection;
                        boolean isHome;
                        if (isDefined) {
                            isHome = KeyBindingHelper.matchesKeybinding((int)event.keyCode, (int)event.stateMask, (String)"org.eclipse.ui.edit.text.goto.lineStart");
                        } else {
                            boolean bl = isHome = event.keyCode == 0x1000007 && event.stateMask == 0;
                        }
                        if (isHome && (selection = viewer.getSelection()) instanceof ITextSelection) {
                            FirstCharAction firstCharAction = new FirstCharAction();
                            firstCharAction.viewer = viewer;
                            firstCharAction.perform(viewer.getDocument(), (ITextSelection)selection);
                            event.doit = false;
                        }
                    }
                }
            };
        }
        return null;
    }
}

