/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.core.tooltips.presenter.AbstractInformationPresenter;
import org.python.pydev.editor.PyLineBreakReader;
import org.python.pydev.editor.actions.PyOpenAction;
import org.python.pydev.editor.model.ItemPointer;

public class PyInformationPresenter
extends AbstractInformationPresenter {
    private int fCounter;
    private boolean fEnforceUpperLineLimit;

    public PyInformationPresenter(boolean enforceUpperLineLimit) {
        this.fEnforceUpperLineLimit = enforceUpperLineLimit;
    }

    public PyInformationPresenter() {
        this(true);
    }

    protected Reader createReader(String hoverInfo, TextPresentation presentation) {
        String str = StringUtils.removeWhitespaceColumnsToLeft((String)hoverInfo);
        str = this.correctLineDelimiters(str);
        str = this.handlePydevTags(presentation, str);
        str = this.makeEpydocsBold(presentation, str);
        return new StringReader(str);
    }

    private String makeEpydocsBold(TextPresentation presentation, String str) {
        int start;
        int lastIndex = 0;
        while ((start = str.indexOf(64, lastIndex)) != -1) {
            int end = start + 1;
            while (end < str.length()) {
                if (str.charAt(end) == ':') break;
                ++end;
            }
            if (end == start) break;
            lastIndex = end;
            presentation.addStyleRange((StyleRange)new PyStyleRange(start, end - start, null, null, 1));
        }
        return str;
    }

    public String handlePydevTags(TextPresentation presentation, String str) {
        FastStringBuffer buf = new FastStringBuffer(str.length());
        String newString = this.handleLinks(presentation, str, buf.clear(), "pydev_hint_bold", false);
        newString = this.handleLinks(presentation, newString, buf.clear(), "pydev_link", true);
        return newString;
    }

    private String handleLinks(TextPresentation presentation, String str, FastStringBuffer buf, String tag, boolean addLinkUnderline) {
        int startTagLen;
        int end;
        int start;
        int lastIndex = 0;
        String startTag = "<" + tag;
        String endTag = "</" + tag + ">";
        int endTagLen = endTag.length();
        while ((start = str.indexOf(startTag, lastIndex)) != -1 && (end = str.indexOf(endTag, start + (startTagLen = str.indexOf(">", start) - start + 1))) != -1 && end != start) {
            int initialIndex = lastIndex;
            lastIndex = end + endTagLen;
            buf.append(str.substring(initialIndex, start));
            int startRange = buf.length();
            buf.append(str.substring(start + startTagLen, end));
            int endRange = buf.length();
            PyStyleRange styleRange = new PyStyleRange(startRange, endRange - startRange, null, null, 1);
            styleRange.tagReplaced = str.substring(start, start + startTagLen);
            if (addLinkUnderline) {
                styleRange.underline = true;
                try {
                    styleRange.underlineStyle = 4;
                }
                catch (Throwable throwable) {}
            }
            presentation.addStyleRange((StyleRange)styleRange);
        }
        buf.append(str.substring(lastIndex, str.length()));
        String newString = buf.toString();
        return newString;
    }

    protected void adaptTextPresentation(TextPresentation presentation, int offset, int insertLength) {
        int yoursStart = offset;
        int yoursEnd = offset + insertLength - 1;
        yoursEnd = Math.max(yoursStart, yoursEnd);
        Iterator e = presentation.getAllStyleRangeIterator();
        while (e.hasNext()) {
            StyleRange range = (StyleRange)e.next();
            int myStart = range.start;
            int myEnd = range.start + range.length - 1;
            if ((myEnd = Math.max(myStart, myEnd)) < yoursStart) continue;
            if (myStart < yoursStart) {
                range.length += insertLength;
                continue;
            }
            range.start += insertLength;
        }
    }

    private void append(FastStringBuffer buffer, String string, TextPresentation presentation) {
        int length = string.length();
        buffer.append(string);
        if (presentation != null) {
            this.adaptTextPresentation(presentation, this.fCounter, length);
        }
        this.fCounter += length;
    }

    private String getIndent(String line) {
        int length = line.length();
        int i = 0;
        while (i < length && Character.isWhitespace(line.charAt(i))) {
            ++i;
        }
        return String.valueOf(i == length ? line : line.substring(0, i)) + " ";
    }

    public String updatePresentation(Drawable drawable, String hoverInfo, TextPresentation presentation, int maxWidth, int maxHeight) {
        if (drawable instanceof StyledText) {
            final StyledText styledText = (StyledText)drawable;
            styledText.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    String tagReplaced;
                    int offset;
                    try {
                        offset = styledText.getOffsetAtLocation(new Point(e.x, e.y));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return;
                    }
                    StyleRange r = styledText.getStyleRangeAtOffset(offset);
                    if (r instanceof PyStyleRange && (tagReplaced = ((PyStyleRange)r).tagReplaced) != null) {
                        String start = "<pydev_link pointer=\"";
                        String end = "\">";
                        if (tagReplaced.startsWith(start) && tagReplaced.endsWith(end)) {
                            String pointer = tagReplaced.substring(start.length(), tagReplaced.length() - end.length());
                            new PyOpenAction().run(ItemPointer.fromPortableString(pointer));
                        }
                    }
                }
            });
        }
        if (hoverInfo == null) {
            return null;
        }
        GC gc = new GC(drawable);
        try {
            FastStringBuffer buffer = new FastStringBuffer();
            int maxNumberOfLines = Math.round((float)maxHeight / (float)gc.getFontMetrics().getHeight());
            this.fCounter = 0;
            PyLineBreakReader reader = new PyLineBreakReader(this.createReader(hoverInfo, presentation), gc, maxWidth);
            boolean lastLineFormatted = false;
            String lastLineIndent = null;
            String line = reader.readLine();
            boolean lineFormatted = reader.isFormattedLine();
            boolean firstLineProcessed = false;
            while (line != null) {
                if (this.fEnforceUpperLineLimit && maxNumberOfLines <= 0) break;
                if (firstLineProcessed) {
                    if (!lastLineFormatted) {
                        this.append(buffer, LINE_DELIM, null);
                    } else {
                        this.append(buffer, LINE_DELIM, presentation);
                        if (lastLineIndent != null) {
                            this.append(buffer, lastLineIndent, presentation);
                        }
                    }
                }
                this.append(buffer, line, null);
                firstLineProcessed = true;
                lastLineFormatted = lineFormatted;
                if (!lineFormatted) {
                    lastLineIndent = null;
                } else if (lastLineIndent == null) {
                    lastLineIndent = this.getIndent(line);
                }
                line = reader.readLine();
                lineFormatted = reader.isFormattedLine();
                --maxNumberOfLines;
            }
            if (line != null) {
                this.append(buffer, LINE_DELIM, (TextPresentation)(lineFormatted ? presentation : null));
            }
            String string = this.trim(buffer, presentation);
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
        finally {
            gc.dispose();
        }
    }

    private String trim(FastStringBuffer buffer, TextPresentation presentation) {
        int length = buffer.length();
        int end = length - 1;
        while (end >= 0 && Character.isWhitespace(buffer.charAt(end))) {
            --end;
        }
        if (end == -1) {
            return "";
        }
        if (end < length - 1) {
            buffer.delete(end + 1, length);
        } else {
            end = length;
        }
        int start = 0;
        while (start < end && Character.isWhitespace(buffer.charAt(start))) {
            ++start;
        }
        buffer.delete(0, start);
        presentation.setResultWindow((IRegion)new Region(start, buffer.length()));
        return buffer.toString();
    }

    public static class PyStyleRange
    extends StyleRange {
        public String tagReplaced;

        public PyStyleRange() {
        }

        public PyStyleRange(int start, int length, Color foreground, Color background) {
            super(start, length, foreground, background);
        }

        public PyStyleRange(int start, int length, Color foreground, Color background, int fontStyle) {
            super(start, length, foreground, background, fontStyle);
        }
    }
}

