/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.dltk.console.ui.internal.actions;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.dltk.console.ui.IScriptConsoleViewer;
import org.python.pydev.dltk.console.ui.ScriptConsolePartitioner;
import org.python.pydev.dltk.console.ui.ScriptStyleRange;

public class HandleLineStartAction {
    public boolean execute(IDocument doc, int caretOffset, int commandLineOffset, IScriptConsoleViewer viewer) {
        int lineOffset;
        block6: {
            int absoluteCursorOffset;
            int promptEndOffset;
            block5: {
                try {
                    PySelection ps = new PySelection(doc, caretOffset);
                    promptEndOffset = lineOffset = ps.getLineOffset();
                    ScriptConsolePartitioner partitioner = (ScriptConsolePartitioner)doc.getDocumentPartitioner();
                    int docLen = doc.getLength();
                    while (promptEndOffset < docLen) {
                        ScriptStyleRange[] range = partitioner.getStyleRanges(promptEndOffset, 1);
                        if (range.length >= 1 && range[0].scriptType != 1) break;
                        ++promptEndOffset;
                    }
                    absoluteCursorOffset = ps.getAbsoluteCursorOffset();
                    IRegion lineInformation = doc.getLineInformationOfOffset(absoluteCursorOffset);
                    String contentsFromPrompt = doc.get(promptEndOffset, lineInformation.getOffset() + lineInformation.getLength() - promptEndOffset);
                    int firstCharPosition = PySelection.getFirstCharPosition((String)contentsFromPrompt);
                    int firstCharOffset = promptEndOffset + firstCharPosition;
                    if (lineOffset != absoluteCursorOffset && firstCharOffset >= absoluteCursorOffset) break block5;
                    viewer.setCaretOffset(firstCharOffset, false);
                    return true;
                }
                catch (BadLocationException e) {
                    Log.log((Throwable)e);
                    return false;
                }
            }
            if (promptEndOffset >= absoluteCursorOffset) break block6;
            viewer.setCaretOffset(promptEndOffset, false);
            return true;
        }
        viewer.setCaretOffset(lineOffset, false);
        return true;
    }
}

