/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder.pycremover;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.builder.PyDevBuilderPrefPage;
import org.python.pydev.builder.PyDevBuilderVisitor;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editorinput.PySourceLocatorBase;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;

public class PycHandlerBuilderVisitor
extends PyDevBuilderVisitor {
    private static final PycDeleteJob pycDeleteJob = new PycDeleteJob();
    private static final PySourceLocatorBase locator = new PySourceLocatorBase();
    private int pycDeleteHandling;

    public void visitingWillStart(IProgressMonitor monitor, boolean isFullBuild, IPythonNature nature) {
        super.visitingWillStart(monitor, isFullBuild, nature);
        this.pycDeleteHandling = PyDevBuilderPrefPage.getPycDeleteHandling();
    }

    public void visitChangedResource(IResource resource, IDocument document, IProgressMonitor monitor) {
    }

    public void visitAddedResource(IResource resource, IDocument document, IProgressMonitor monitor) {
        switch (this.pycDeleteHandling) {
            case 2: {
                return;
            }
            case 1: {
                return;
            }
        }
        String loc = resource.getLocation().toOSString();
        if (loc != null && (loc.endsWith(".pyc") || loc.endsWith("$py.class"))) {
            String dotPyLoc = null;
            FastStringBuffer buf = new FastStringBuffer(StringUtils.stripExtension((String)loc), 8);
            String[] stringArray = FileTypesPreferencesPage.getDottedValidSourceFiles();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                buf.append(ext);
                String bufStr = buf.toString();
                File file = new File(bufStr);
                if (dotPyLoc == null) {
                    dotPyLoc = bufStr;
                }
                if (file.exists()) {
                    this.markAsDerived(resource);
                    return;
                }
                buf.deleteLastChars(ext.length());
                ++n2;
            }
            PythonNature nature = PythonNature.getPythonNature(resource);
            if (nature == null) {
                this.markAsDerived(resource);
                return;
            }
            try {
                if (!nature.isResourceInPythonpathProjectSources(dotPyLoc, false)) {
                    return;
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
                return;
            }
            this.deletePycFile(loc);
        }
    }

    private void markAsDerived(IResource resource) {
        try {
            resource.setDerived(true);
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
    }

    public void visitRemovedResource(IResource resource, IDocument document, IProgressMonitor monitor) {
        switch (this.pycDeleteHandling) {
            case 2: {
                return;
            }
        }
        String loc = resource.getLocation().toOSString();
        if (PythonPathHelper.isValidSourceFile(loc)) {
            String withoutExt = StringUtils.stripExtension((String)loc);
            this.deletePycFile(String.valueOf(withoutExt) + ".pyc");
            this.deletePycFile(String.valueOf(withoutExt) + "$py.class");
        }
    }

    private void deletePycFile(String loc) {
        if (loc.endsWith(".pyc") || loc.endsWith("$py.class")) {
            try {
                File file = new File(loc);
                IFile[] files = locator.getWorkspaceFiles(file);
                if (files == null || files.length == 0) {
                    return;
                }
                PycHandlerBuilderVisitor.pycDeleteJob.addFilesToDelete(files);
                pycDeleteJob.schedule(200L);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }

    private static final class PycDeleteJob
    extends WorkspaceJob {
        private final List<IFile> files = new ArrayList<IFile>();
        private final Object lock = new Object();

        public PycDeleteJob() {
            super("Delete .pyc/$py.class files");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addFilesToDelete(IFile[] files) {
            Object object = this.lock;
            synchronized (object) {
                IFile[] iFileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile f = iFileArray[n2];
                    this.files.add(f);
                    ++n2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            IFile[] currentFilesToDelete = null;
            Object object = this.lock;
            synchronized (object) {
                currentFilesToDelete = this.files.toArray(new IFile[this.files.size()]);
                this.files.clear();
            }
            monitor.beginTask("Delete .pyc/$py.class files", currentFilesToDelete.length);
            try {
                IFile[] iFileArray = currentFilesToDelete;
                int n = currentFilesToDelete.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile workspaceFile = iFileArray[n2];
                    if (workspaceFile != null && workspaceFile.exists()) {
                        try {
                            workspaceFile.delete(true, monitor);
                        }
                        catch (CoreException e) {
                            Log.log((Throwable)e);
                        }
                    }
                    monitor.worked(1);
                    ++n2;
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }
}

