/*
 * Decompiled with CFR 0.152.
 */
package jep;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import jep.Jep;
import jep.JepException;
import jep.python.PyModule;

public class Test
implements Runnable {
    private Jep jep = null;
    private boolean testEval = false;
    public String stringField = "a stringField";
    public boolean booleanField = true;
    public short shortField = (short)321;
    public int intField = 123;
    public long longField = Long.MAX_VALUE;
    public double doubleField = 123.123;
    public float floatField = Float.MAX_VALUE;
    public byte byteField = (byte)43;
    public char charField = (char)99;
    public Class classField = this.getClass();
    public static String staticString = "stringField";
    public static boolean staticBoolean = true;
    public static short staticShort = (short)321;
    public static int staticInt = 123;
    public static long staticLong = Long.MAX_VALUE;
    public static double staticDouble = 123.123;
    public static float staticFloat = Float.MAX_VALUE;
    public static byte staticByte = (byte)125;
    public static char staticChar = (char)106;
    public static Class staticClass = Thread.currentThread().getClass();

    public Test() {
    }

    public Test(boolean bl) {
        this.testEval = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        for (int i = 0; i < 1; ++i) {
            System.out.println("running i: " + i);
            try {
                Object object;
                File file = new File(".");
                this.jep = new Jep(this.testEval, file.getAbsolutePath());
                this.jep.set("testo", this);
                this.jep.set("test", "value from java.");
                this.jep.set("testi", i);
                this.jep.set("testb", true);
                this.jep.set("testl", 123123122112L);
                this.jep.set("testd", 123.123);
                this.jep.set("testf", 12312.123f);
                this.jep.set("testy", 127);
                this.jep.set("testc", 't');
                this.jep.set("testn", (String)null);
                this.jep.set("testn", (Object)null);
                this.jep.set("testz", this.getClass());
                int[] nArray = new int[]{3};
                double[] dArray = new double[]{2.0};
                String[] stringArray = new String[]{"0"};
                this.jep.eval("def manip(li, val):\n\tli[0]=val\n\tli.commit()");
                this.jep.invoke("manip", nArray, 1);
                this.jep.invoke("manip", dArray, 1.0);
                this.jep.invoke("manip", stringArray, "1");
                System.out.println(nArray[0]);
                System.out.println(dArray[0]);
                System.out.println(stringArray[0]);
                this.jep.set("x", dArray);
                assert (((double[])this.jep.getValue("x"))[0] == 1.0);
                boolean[] blArray = new boolean[10];
                blArray[1] = true;
                this.jep.set("testab", blArray);
                double[] dArray2 = new double[10];
                dArray2[1] = Double.MAX_VALUE;
                this.jep.set("testad", dArray2);
                PyModule pyModule = this.jep.createModule("amod");
                pyModule.set("testab", blArray);
                pyModule.set("testad", dArray2);
                if (!this.testEval) {
                    this.jep.runScript("test.py");
                } else {
                    object = new BufferedReader(new FileReader("test.py"));
                    String string = null;
                    while ((string = ((BufferedReader)object).readLine()) != null) {
                        if (string.trim().startsWith("#")) continue;
                        System.out.println("Running line: " + string);
                        this.jep.eval(string);
                    }
                    ((BufferedReader)object).close();
                }
                this.jep.invoke("testMethod", true);
                this.jep.invoke("testMethod", 123);
                this.jep.invoke("testMethod", 112L);
                this.jep.invoke("testMethod", 112.23);
                this.jep.invoke("testMethod", Float.valueOf(112.23123f));
                this.jep.invoke("testMethod", (byte)-45);
                this.jep.invoke("testMethod", Character.valueOf('t'));
                object = this.jep.invoke("testMethod", "method called from Java");
                System.out.println("testMethod ret:   " + object);
                System.out.println("Test get object: " + this.jep.getValue("testo"));
                System.out.println("Test get string: " + this.jep.getValue("test"));
                System.out.println("Test get int: " + (Integer)this.jep.getValue("testi"));
                System.out.println("Test get boolean: " + (Boolean)this.jep.getValue("testb"));
                System.out.println("Test get long: " + (Long)this.jep.getValue("testl"));
                System.out.println("Test get double: " + (Float)this.jep.getValue("testd"));
                System.out.println("Test get float: " + (Float)this.jep.getValue("testf"));
                System.out.println("Test get short: " + (Integer)this.jep.getValue("testy"));
                System.out.println("Test get null: " + this.jep.getValue("testn"));
                System.out.println("Test get class: " + (Class)this.jep.getValue("testz"));
                this.jep.eval("testmap = {'blah': 'har'}");
                System.out.println("Test get Python object: " + this.jep.getValue("testmap"));
                System.out.print("get unknown val:  ");
                try {
                    System.out.println(this.jep.getValue("_asdf"));
                    System.out.println("whoops");
                }
                catch (JepException jepException) {
                    System.out.println(jepException.getMessage());
                }
                continue;
            }
            catch (Throwable throwable) {
                System.out.println("Java caught error:");
                throwable.printStackTrace();
                break;
            }
            finally {
                System.out.println("**** close me");
                if (this.jep != null) {
                    this.jep.close();
                }
            }
        }
    }

    protected void finalize() {
        System.out.println("test instance finalized, you should see this if the reference counting worked...");
    }

    public Jep getJep() {
        return this.jep;
    }

    public String toString() {
        return "toString(). Thanks for calling Java(tm).";
    }

    public TestEnum getEnum() {
        return TestEnum.One;
    }

    public int getInt() {
        return Integer.MAX_VALUE;
    }

    public byte getByte() {
        return 123;
    }

    public char getChar() {
        return 'c';
    }

    public short getShort() {
        return 321;
    }

    public long getLong() {
        return Long.MAX_VALUE;
    }

    public double getDouble() {
        return Double.MAX_VALUE;
    }

    public float getFloat() {
        return Float.MAX_VALUE;
    }

    public Integer getInteger() {
        return new Integer(Integer.MIN_VALUE);
    }

    public Long getClassLong() {
        return new Long(Long.MAX_VALUE);
    }

    public Double getClassDouble() {
        return new Double(Double.MIN_VALUE);
    }

    public Float getClassFloat() {
        return new Float(Float.MAX_VALUE);
    }

    public ArrayList getObject() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("list 0");
        return arrayList;
    }

    public String[] getStringArray() {
        return new String[]{"one", "two"};
    }

    public String[][] getStringStringArray() {
        return new String[][]{{"one", "two"}, {"one", "two"}};
    }

    public int[] getIntArray() {
        return new int[]{1, 2};
    }

    public boolean[] getBooleanArray() {
        return new boolean[]{false, true};
    }

    public short[] getShortArray() {
        return new short[]{123, 123};
    }

    public float[] getFloatArray() {
        return new float[]{123.123f, 123.123f};
    }

    public Test[] getObjectArray() {
        return new Test[]{new Test(), new Test()};
    }

    public void sendObjectArray(Object[] objectArray) {
        if (objectArray == null) {
            throw new NullPointerException("p is null?");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            System.out.println("                  array[" + i + "] = " + objectArray[i]);
        }
    }

    public void sendIntArray(int[] nArray) {
        if (nArray == null) {
            throw new NullPointerException("p is null?");
        }
        for (int i = 0; i < nArray.length; ++i) {
            System.out.println("                  array[" + i + "] = " + nArray[i]);
        }
    }

    public void sendMeSomeStuff(String string, ArrayList arrayList) {
        System.out.println("got some stuff:   v = " + string + " and a = " + arrayList);
    }

    public String callback() {
        return "Hey, you called a Java(tm) method!";
    }

    public static String getStaticString() {
        return "a static string.";
    }

    public static boolean getStaticBoolean() {
        return false;
    }

    public static int getStaticInt() {
        return 123;
    }

    public static short getStaticShort() {
        return 321;
    }

    public static long getStaticLong() {
        return Long.MAX_VALUE;
    }

    public static double getStaticDouble() {
        return 1.23123213123E8;
    }

    public static float getStaticFloat() {
        return 12312.123f;
    }

    public static Object getStaticObject() {
        return new Object();
    }

    public static void callStaticVoid() {
    }

    public static byte getStaticByte() {
        return 23;
    }

    public static char getStaticChar() {
        return 'b';
    }

    public static Class getStaticClass() {
        return Thread.currentThread().getClass();
    }

    public static void main(String[] stringArray) throws Throwable {
        if (stringArray.length < 1) {
            new Thread(new Test()).start();
            new Thread(new Test()).start();
        } else {
            int n = Integer.parseInt(stringArray[0]);
            for (int i = 0; i < n; ++i) {
                new Thread(new Test()).start();
            }
        }
        new Test().run();
        System.gc();
    }

    public static enum TestEnum {
        One,
        Two;

    }
}

