/*
 * Decompiled with CFR 0.152.
 */
package jep;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import jep.ClassFilenameFilter;
import jep.JepException;

public class ClassList {
    private static ClassList inst;
    private static HashMap<String, ArrayList<String>> packages;

    private ClassList() throws JepException {
        this.loadClassPath();
        this.loadPackages();
        this.loadJREClasses();
    }

    private void loadClassPath() throws JepException {
        StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty("java.class.path"), System.getProperty("path.separator"));
        while (stringTokenizer.hasMoreTokens()) {
            File file;
            String string = stringTokenizer.nextToken();
            if (!string.toLowerCase().endsWith(".jar") || !(file = new File(string)).exists() || !file.canRead()) continue;
            try {
                JarFile jarFile = new JarFile(string, false);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    if (!jarEntry.getName().toLowerCase().endsWith(".class")) continue;
                    int n = jarEntry.getName().lastIndexOf(47);
                    String string2 = "default";
                    if (n > 0) {
                        string2 = jarEntry.getName().substring(0, n).replace('/', '.');
                    }
                    String string3 = this.stripClassExt(jarEntry.getName().substring(n + 1));
                    this.addClass(string2, string3);
                }
                jarFile.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void loadPackages() throws JepException {
        Package[] packageArray;
        ClassLoader classLoader = this.getClass().getClassLoader();
        for (Package package_ : packageArray = Package.getPackages()) {
            String string = package_.getName().replace('.', '/');
            URL uRL = classLoader.getResource(string);
            if (uRL == null || !uRL.getProtocol().equals("file")) continue;
            File file = null;
            try {
                file = new File(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new JepException(uRISyntaxException);
            }
            for (File file2 : file.listFiles(new ClassFilenameFilter())) {
                this.addClass(package_.getName(), this.stripClassExt(file2.getName()));
            }
        }
    }

    private String stripClassExt(String string) {
        return string.substring(0, string.length() - 6);
    }

    private void loadJREClasses() throws JepException {
        String string = System.getProperty("java.home");
        String string2 = System.getProperty("file.separator");
        File file = new File(string + string2 + "lib" + string2 + "classlist");
        if (!file.exists()) {
            return;
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String string3 = "";
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.indexOf(36) > -1) continue;
                String[] stringArray = string3.split("\\/");
                StringBuffer stringBuffer = new StringBuffer();
                String string4 = stringArray[stringArray.length - 1];
                for (int i = 0; i < stringArray.length - 1; ++i) {
                    stringBuffer.append(stringArray[i]);
                    if (i >= stringArray.length - 2) continue;
                    stringBuffer.append(".");
                }
                this.addClass(stringBuffer.toString(), string4);
            }
        }
        catch (IOException iOException) {
            throw new JepException(iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void addClass(String string, String string2) {
        ArrayList<String> arrayList = packages.get(string.toString());
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        if (!string.equals("default")) {
            string2 = string + "." + string2;
        }
        if (arrayList.indexOf(string2) > -1) {
            return;
        }
        arrayList.add(string2);
        packages.put(string.toString(), arrayList);
    }

    private String[] _get(String string) throws JepException {
        ArrayList<String> arrayList = packages.get(string);
        if (arrayList == null) {
            Set<String> set = packages.keySet();
            for (String string2 : set) {
                if (!string2.startsWith(string)) continue;
                return new String[0];
            }
            throw new JepException("Package not found: " + string);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static String[] get(String string) throws JepException {
        return ClassList.getInstance()._get(string);
    }

    public static synchronized ClassList getInstance() throws JepException {
        if (inst == null) {
            inst = new ClassList();
        }
        return inst;
    }

    public static void main(String[] stringArray) throws Throwable {
        if (stringArray.length > 0) {
            for (String string : stringArray) {
                for (String string2 : ClassList.get(string)) {
                    System.out.println(string2);
                }
            }
        } else {
            for (String string : ClassList.get("java.lang")) {
                System.out.println(string);
            }
            for (String string : ClassList.get("jep")) {
                System.out.println(string);
            }
        }
    }

    static {
        packages = new HashMap();
    }
}

