/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.gda.extensions.util;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;
import org.dawb.common.services.IFileIconService;
import org.dawb.common.services.IImageService;
import org.dawb.common.services.ILoaderService;
import org.dawb.common.services.IThumbnailService;
import org.dawb.common.services.ServiceManager;
import org.dawb.common.ui.image.PaletteFactory;
import org.dawb.common.ui.plot.AbstractPlottingSystem;
import org.dawb.common.ui.plot.PlotType;
import org.dawb.common.ui.plot.PlottingFactory;
import org.dawb.common.util.io.FileUtils;
import org.dawb.gda.extensions.Activator;
import org.dawb.gda.extensions.loaders.H5Loader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.services.AbstractServiceFactory;
import org.eclipse.ui.services.IServiceLocator;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.RGBDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Stats;
import uk.ac.diamond.scisoft.analysis.dataset.function.Downsample;
import uk.ac.diamond.scisoft.analysis.dataset.function.DownsampleMode;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.AbstractMapFunction;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.utils.GlobalColourMaps;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.utils.SWTImageUtils;
import uk.ac.gda.util.OSUtils;

public class ImageThumbnailCreator
extends AbstractServiceFactory
implements IThumbnailService {
    private static float minimumThreshold;
    private static int colourMapChoice;
    private static ImageRegistry imageRegistry;
    private static org.eclipse.swt.graphics.Image folderImage;

    static {
        LoaderFactory.setLoaderSearching((boolean)false);
        minimumThreshold = 0.98f;
        colourMapChoice = 1;
    }

    public org.eclipse.swt.graphics.Image createImage(File file, int n) {
        if (file.isDirectory()) {
            org.eclipse.swt.graphics.Image image = Activator.getImageDescriptor("icons/folder.gif").createImage();
            org.eclipse.swt.graphics.Image image2 = new org.eclipse.swt.graphics.Image((Device)Display.getDefault(), n, n);
            GC gC = new GC((Drawable)image2);
            gC.drawImage(image, n / 2 - image.getImageData().width / 2, n / 2 - image.getImageData().height / 2);
            gC.dispose();
            return image2;
        }
        try {
            AbstractDataset abstractDataset = this.getThumbnail(file, n);
            return this.createImageSWT(abstractDataset);
        }
        catch (Throwable throwable) {
            ImageData imageData;
            String string;
            org.eclipse.swt.graphics.Image image;
            if (imageRegistry == null) {
                imageRegistry = new ImageRegistry(Display.getDefault());
            }
            if ((image = imageRegistry.get(string = FileUtils.getFileExtension((File)file))) != null) {
                return image;
            }
            Program program = Program.findProgram((String)string);
            ImageData imageData2 = imageData = program == null ? null : program.getImageData();
            if (imageData != null) {
                image = new org.eclipse.swt.graphics.Image((Device)Display.getDefault(), imageData);
                imageRegistry.put(string, image);
                return image;
            }
            string = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(file.getAbsolutePath()).createImage();
            image = new org.eclipse.swt.graphics.Image((Device)Display.getDefault(), n, n);
            program = new GC((Drawable)image);
            program.drawImage((org.eclipse.swt.graphics.Image)string, n / 2 - string.getImageData().width / 2, n / 2 - string.getImageData().height / 2);
            program.dispose();
            return image;
        }
    }

    private AbstractDataset getThumbnail(File file, int n) throws Throwable {
        if (H5Loader.isH5(file.getAbsolutePath())) {
            return null;
        }
        ILoaderService iLoaderService = (ILoaderService)ServiceManager.getService(ILoaderService.class);
        AbstractDataset abstractDataset = iLoaderService.getDataset(file);
        AbstractDataset abstractDataset2 = this.getThumbnail(abstractDataset, n);
        return abstractDataset2;
    }

    public AbstractDataset getThumbnail(AbstractDataset abstractDataset, int n) {
        if (abstractDataset != null && abstractDataset.getRank() == 2) {
            int n2 = abstractDataset.getShape()[1];
            int n3 = abstractDataset.getShape()[0];
            int[] nArray = new int[2];
            nArray[1] = Math.max(1, n2 / n);
            nArray[0] = Math.max(1, n3 / n);
            Downsample downsample = new Downsample(DownsampleMode.POINT, nArray);
            AbstractDataset abstractDataset2 = (AbstractDataset)downsample.value(new IDataset[]{abstractDataset}).get(0);
            abstractDataset2.setName(abstractDataset.getName());
            return abstractDataset2;
        }
        return null;
    }

    public org.eclipse.swt.graphics.Image createImageSWT(AbstractDataset abstractDataset) throws Exception {
        ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.dawb.workbench.plotting");
        IImageService.ImageServiceBean imageServiceBean = new IImageService.ImageServiceBean();
        imageServiceBean.setPalette(PaletteFactory.getPalette((int)scopedPreferenceStore.getInt("org.dawb.plotting.system.paletteChoice")));
        imageServiceBean.setOrigin(IImageService.ImageOrigin.forLabel((String)scopedPreferenceStore.getString("org.dawb.plotting.system.originChoice")));
        imageServiceBean.setImage(abstractDataset);
        IImageService iImageService = (IImageService)PlatformUI.getWorkbench().getService(IImageService.class);
        return iImageService.getImage(imageServiceBean);
    }

    public org.eclipse.swt.graphics.Image createImageDiamond(AbstractDataset abstractDataset) {
        GlobalColourMaps.InitializeColourMaps();
        int[] nArray = abstractDataset.getShape();
        if (nArray.length == 2) {
            double d;
            if (abstractDataset instanceof RGBDataset) {
                double d2;
                d = Stats.quantile((AbstractDataset)((RGBDataset)abstractDataset).createRedDataset(2), (double)minimumThreshold);
                if (d < (d2 = Stats.quantile((AbstractDataset)((RGBDataset)abstractDataset).createGreenDataset(2), (double)minimumThreshold))) {
                    d = d2;
                }
                if (d < (d2 = Stats.quantile((AbstractDataset)((RGBDataset)abstractDataset).createBlueDataset(2), (double)minimumThreshold))) {
                    d = d2;
                }
            } else {
                d = Stats.quantile((AbstractDataset)abstractDataset, (double)minimumThreshold);
            }
            int n = (Integer)GlobalColourMaps.colourSelectList.get(colourMapChoice * 4);
            int n2 = (Integer)GlobalColourMaps.colourSelectList.get(colourMapChoice * 4 + 1);
            int n3 = (Integer)GlobalColourMaps.colourSelectList.get(colourMapChoice * 4 + 2);
            AbstractMapFunction abstractMapFunction = (AbstractMapFunction)GlobalColourMaps.mappingFunctions.get(Math.abs(n));
            AbstractMapFunction abstractMapFunction2 = (AbstractMapFunction)GlobalColourMaps.mappingFunctions.get(Math.abs(n2));
            AbstractMapFunction abstractMapFunction3 = (AbstractMapFunction)GlobalColourMaps.mappingFunctions.get(Math.abs(n3));
            ImageData imageData = SWTImageUtils.createImageData((AbstractDataset)abstractDataset, (Number)d, (AbstractMapFunction)abstractMapFunction, (AbstractMapFunction)abstractMapFunction2, (AbstractMapFunction)abstractMapFunction3, (n < 0 ? 1 : 0) != 0, (n2 < 0 ? 1 : 0) != 0, (n3 < 0 ? 1 : 0) != 0);
            return new org.eclipse.swt.graphics.Image((Device)Display.getDefault(), imageData);
        }
        return null;
    }

    public Object create(Class clazz, IServiceLocator iServiceLocator, IServiceLocator iServiceLocator2) {
        if (clazz == IThumbnailService.class) {
            return new ImageThumbnailCreator();
        }
        if (clazz == IFileIconService.class) {
            return new ImageThumbnailCreator();
        }
        return null;
    }

    public org.eclipse.swt.graphics.Image createImage(AbstractDataset abstractDataset) throws Exception {
        return this.createImageSWT(abstractDataset);
    }

    public org.eclipse.swt.graphics.Image getThumbnailImage(final AbstractDataset abstractDataset, final int n) throws Exception {
        if (abstractDataset.getShape().length == 2) {
            AbstractDataset abstractDataset2 = this.getThumbnail(abstractDataset, n);
            if (abstractDataset2 == null) {
                return null;
            }
            return this.createImage(abstractDataset2);
        }
        if (abstractDataset.getShape().length == 1) {
            final AbstractPlottingSystem abstractPlottingSystem = PlottingFactory.getLightWeightPlottingSystem();
            final org.eclipse.swt.graphics.Image[] imageArray = new org.eclipse.swt.graphics.Image[1];
            final Display display = Display.getDefault();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = new Shell(display);
                    shell.setSize(600, 600);
                    Composite composite = new Composite((Composite)shell, 0);
                    abstractPlottingSystem.createPlotPart(composite, "Thumbnail", null, PlotType.PT1D, null);
                    abstractPlottingSystem.createPlot1D(abstractDataset, null, (IProgressMonitor)new NullProgressMonitor());
                    org.eclipse.swt.graphics.Image image = abstractPlottingSystem.getImage(new Rectangle(0, 0, 300, 300));
                    imageArray[0] = new org.eclipse.swt.graphics.Image((Device)display, image.getImageData().scaledTo(n, n));
                }
            });
            return imageArray[0];
        }
        return null;
    }

    public org.eclipse.swt.graphics.Image getIconForFile(File file) {
        ImageDescriptor imageDescriptor;
        Program program;
        org.eclipse.swt.graphics.Image image;
        if (file.isDirectory()) {
            return this.getFolderImage(file);
        }
        String string = FileUtils.getFileExtension((File)file);
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        if ((image = imageRegistry.get(string)) != null) {
            return image;
        }
        if (image == null && (program = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getAbsolutePath())) != null && (imageDescriptor = program.getImageDescriptor()) != null) {
            image = imageDescriptor.createImage();
        }
        if (image == null && (program = Program.findProgram((String)string)) != null) {
            imageDescriptor = Program.findProgram((String)string).getImageData();
            image = new org.eclipse.swt.graphics.Image((Device)Display.getCurrent(), (ImageData)imageDescriptor);
        }
        if (image == null) {
            image = ImageThumbnailCreator.getImageSWT(file);
        }
        imageRegistry.put(string, image);
        return image;
    }

    static ImageData convertToSWT(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel directColorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData paletteData = new PaletteData(directColorModel.getRedMask(), directColorModel.getGreenMask(), directColorModel.getBlueMask());
            ImageData imageData = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), directColorModel.getPixelSize(), paletteData);
            int n = 0;
            while (n < imageData.height) {
                int n2 = 0;
                while (n2 < imageData.width) {
                    int n3 = bufferedImage.getRGB(n2, n);
                    int n4 = paletteData.getPixel(new RGB(n3 >> 16 & 0xFF, n3 >> 8 & 0xFF, n3 & 0xFF));
                    imageData.setPixel(n2, n, n4);
                    if (directColorModel.hasAlpha()) {
                        imageData.setAlpha(n2, n, n3 >> 24 & 0xFF);
                    }
                    ++n2;
                }
                ++n;
            }
            return imageData;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
            int n = indexColorModel.getMapSize();
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[n];
            byte[] byArray3 = new byte[n];
            indexColorModel.getReds(byArray);
            indexColorModel.getGreens(byArray2);
            indexColorModel.getBlues(byArray3);
            RGB[] rGBArray = new RGB[n];
            int n5 = 0;
            while (n5 < rGBArray.length) {
                rGBArray[n5] = new RGB(byArray[n5] & 0xFF, byArray2[n5] & 0xFF, byArray3[n5] & 0xFF);
                ++n5;
            }
            PaletteData paletteData = new PaletteData(rGBArray);
            ImageData imageData = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), indexColorModel.getPixelSize(), paletteData);
            imageData.transparentPixel = indexColorModel.getTransparentPixel();
            WritableRaster writableRaster = bufferedImage.getRaster();
            int[] nArray = new int[1];
            int n6 = 0;
            while (n6 < imageData.height) {
                int n7 = 0;
                while (n7 < imageData.width) {
                    writableRaster.getPixel(n7, n6, nArray);
                    imageData.setPixel(n7, n6, nArray[0]);
                    ++n7;
                }
                ++n6;
            }
            return imageData;
        }
        return null;
    }

    static org.eclipse.swt.graphics.Image getImageSWT(File file) {
        ImageIcon imageIcon = (ImageIcon)FileSystemView.getFileSystemView().getSystemIcon(file);
        Image image = imageIcon.getImage();
        if (image instanceof BufferedImage) {
            return new org.eclipse.swt.graphics.Image((Device)Display.getDefault(), ImageThumbnailCreator.convertToSWT((BufferedImage)image));
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return new org.eclipse.swt.graphics.Image((Device)Display.getDefault(), ImageThumbnailCreator.convertToSWT(bufferedImage));
    }

    private org.eclipse.swt.graphics.Image getFolderImage(File file) {
        if (folderImage == null) {
            if (file == null) {
                file = OSUtils.isWindowsOS() ? new File("C:/Windows/") : new File("/");
            }
            folderImage = OSUtils.isWindowsOS() ? ImageThumbnailCreator.getImageSWT(file) : Activator.getImageDescriptor("icons/folder.gif").createImage();
        }
        return folderImage;
    }
}

