/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.gda.extensions.util;

import org.dawb.common.services.IImageService;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.services.AbstractServiceFactory;
import org.eclipse.ui.services.IServiceLocator;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;

public class ImageService
extends AbstractServiceFactory
implements IImageService {
    static {
        LoaderFactory.setLoaderSearching((boolean)false);
    }

    public Image getImage(IImageService.ImageServiceBean imageServiceBean) {
        ImageData imageData = this.getImageData(imageServiceBean);
        return new Image((Device)Display.getCurrent(), imageData);
    }

    public ImageData getImageData(IImageService.ImageServiceBean imageServiceBean) {
        float f;
        float f2;
        int n;
        float f3;
        AbstractDataset abstractDataset = imageServiceBean.getImage();
        IImageService.ImageOrigin imageOrigin = imageServiceBean.getOrigin();
        PaletteData paletteData = imageServiceBean.getPalette();
        int[] nArray = abstractDataset.getShape();
        if (imageServiceBean.isCancelled()) {
            return null;
        }
        float[] fArray = ImageService.getStatistics(imageServiceBean);
        if (imageServiceBean.isCancelled()) {
            return null;
        }
        float f4 = imageServiceBean.getMin() != null ? imageServiceBean.getMin().floatValue() : fArray[0];
        float f5 = f3 = imageServiceBean.getMax() != null ? imageServiceBean.getMax().floatValue() : 3.0f * fArray[2];
        if (f3 > fArray[1]) {
            f3 = fArray[1];
        }
        if ((n = abstractDataset.getSize()) == 0) {
            return null;
        }
        if (f3 > f4) {
            f2 = 255.0f / (f3 - f4);
            f = f3 - f4;
        } else {
            f2 = 1.0f;
            f = 255.0f;
        }
        if (imageServiceBean.isCancelled()) {
            return null;
        }
        byte[] byArray = new byte[n];
        ImageData imageData = null;
        if (imageOrigin == IImageService.ImageOrigin.TOP_LEFT) {
            int n2 = 0;
            while (n2 < n) {
                if (imageServiceBean.isCancelled()) {
                    return null;
                }
                float f6 = (float)abstractDataset.getElementDoubleAbs(n2);
                this.addByte(f6, f4, f3, f2, f, byArray, n2);
                ++n2;
            }
            imageData = new ImageData(nArray[1], nArray[0], 8, paletteData, 1, byArray);
        } else if (imageOrigin == IImageService.ImageOrigin.BOTTOM_LEFT) {
            int n3 = 0;
            int n4 = nArray[1] - 1;
            while (n4 >= 0) {
                int n5 = 0;
                while (n5 < nArray[0]) {
                    if (imageServiceBean.isCancelled()) {
                        return null;
                    }
                    float f7 = abstractDataset.getFloat(new int[]{n5++, n4});
                    this.addByte(f7, f4, f3, f2, f, byArray, n3);
                    ++n3;
                }
                --n4;
            }
            imageData = new ImageData(nArray[0], nArray[1], 8, paletteData, 1, byArray);
        } else if (imageOrigin == IImageService.ImageOrigin.BOTTOM_RIGHT) {
            int n6 = 0;
            int n7 = nArray[0] - 1;
            while (n7 >= 0) {
                int n8 = nArray[1] - 1;
                while (n8 >= 0) {
                    if (imageServiceBean.isCancelled()) {
                        return null;
                    }
                    float f8 = abstractDataset.getFloat(new int[]{n7, n8--});
                    this.addByte(f8, f4, f3, f2, f, byArray, n6);
                    ++n6;
                }
                --n7;
            }
            imageData = new ImageData(nArray[1], nArray[0], 8, paletteData, 1, byArray);
        } else if (imageOrigin == IImageService.ImageOrigin.TOP_RIGHT) {
            int n9 = 0;
            int n10 = 0;
            while (n10 < nArray[1]) {
                int n11 = nArray[0] - 1;
                while (n11 >= 0) {
                    if (imageServiceBean.isCancelled()) {
                        return null;
                    }
                    float f9 = abstractDataset.getFloat(new int[]{n11--, n10});
                    this.addByte(f9, f4, f3, f2, f, byArray, n9);
                    ++n9;
                }
                ++n10;
            }
            imageData = new ImageData(nArray[0], nArray[1], 8, paletteData, 1, byArray);
        }
        if (imageServiceBean.isCancelled()) {
            return null;
        }
        return imageData;
    }

    private final void addByte(float f, float f2, float f3, float f4, float f5, byte[] byArray, int n) {
        byte by;
        float f6 = f < f2 ? 0.0f : (f >= f3 ? f5 : f - f2);
        byArray[n] = by = (byte)(0xFF & (int)(f6 *= f4));
    }

    private static float[] getStatistics(IImageService.ImageServiceBean imageServiceBean) {
        AbstractDataset abstractDataset = imageServiceBean.getImage();
        float f = Float.MAX_VALUE;
        float f2 = -3.4028235E38f;
        float f3 = 0.0f;
        int n = abstractDataset.getSize();
        int n2 = 0;
        while (n2 < n) {
            if (imageServiceBean.isCancelled()) {
                return null;
            }
            float f4 = (float)abstractDataset.getElementDoubleAbs(n2);
            f3 += f4;
            if (f4 < f) {
                f = f4;
            }
            if (f4 > f2) {
                f2 = f4;
            }
            ++n2;
        }
        float f5 = f3 / (float)(abstractDataset.getShape()[0] * abstractDataset.getShape()[1]);
        return new float[]{f, f2, f5};
    }

    public Object create(Class clazz, IServiceLocator iServiceLocator, IServiceLocator iServiceLocator2) {
        if (clazz == IImageService.class) {
            return new ImageService();
        }
        return null;
    }
}

