/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.gda.extensions.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;

public class DatasetTitleUtils {
    private static final Pattern ROOT_PATTERN = Pattern.compile("(\\/[a-zA-Z0-9]+\\/).+");

    public static String getTitle(AbstractDataset abstractDataset, List<AbstractDataset> list, boolean bl) {
        return DatasetTitleUtils.getTitle(abstractDataset, list, bl, null);
    }

    public static String getTitle(AbstractDataset abstractDataset, List<AbstractDataset> list, boolean bl, String string) {
        AbstractDataset abstractDataset2;
        List<AbstractDataset> list2;
        if (list == null) {
            list2 = new ArrayList<AbstractDataset>(1);
            list2.add(abstractDataset);
            abstractDataset2 = DoubleDataset.arange((double)list2.get(0).getSize());
            abstractDataset2.setName("Index of " + abstractDataset.getName());
        } else {
            abstractDataset2 = abstractDataset;
            list2 = list;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Plot of");
        HashSet<String> hashSet = new HashSet<String>(7);
        for (IDataset iDataset : list2) {
            Matcher matcher;
            String string2 = DatasetTitleUtils.getName(iDataset, string);
            if (bl && string2 != null && (matcher = Pattern.compile("(.*) \\(.*\\)").matcher(string2)).matches()) {
                string2 = matcher.group(1);
            }
            if (hashSet.contains(string2)) continue;
            hashSet.add(string2);
            stringBuilder.append(" ");
            stringBuilder.append(string2);
            stringBuilder.append(",");
        }
        int n = stringBuilder.length() - 1;
        stringBuilder.delete(n, n + 1);
        stringBuilder.append(" against ");
        stringBuilder.append(DatasetTitleUtils.getName((IDataset)abstractDataset2, string));
        return stringBuilder.toString();
    }

    public static String getName(IDataset iDataset, String string) {
        if (iDataset == null) {
            return null;
        }
        try {
            return string != null ? iDataset.getName().substring(string.length()) : iDataset.getName();
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return iDataset.getName();
        }
    }

    public static String getRootName(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        String string = null;
        for (String string2 : collection) {
            Matcher matcher = ROOT_PATTERN.matcher(string2);
            if (matcher.matches()) {
                String string3 = matcher.group(1);
                if (string != null && !string.equals(string)) {
                    string = null;
                    break;
                }
                string = string3;
                continue;
            }
            string = null;
            break;
        }
        return string;
    }

    public static Map<String, String> getChoppedNames(Collection<String> collection) {
        String string = DatasetTitleUtils.getRootName(collection);
        if (string == null) {
            return null;
        }
        if (string.length() < 1) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(collection.size());
        for (String string2 : collection) {
            hashMap.put(string2, string2.substring(string.length()));
        }
        return hashMap;
    }
}

