/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.gda.extensions.spec;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SpecSyntax {
    public static final Pattern COMMENT = Pattern.compile("\\#.*");
    public static final Pattern CMD;
    public static final Pattern PRINT;
    public static final Pattern SCAN_LINE;
    public static final Pattern HEADER_LINE;
    private static final String TXT = "([a-zA-Z][_a-zA-Z\\d]*)";
    private static final String NUM = "([-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?)";
    private static final String TXTWS = "([ \t]+[a-zA-Z][_a-zA-Z\\d]*)";
    private static final String TXTWS2_NOSPC = "([ \t]*[_a-zA-Z\\d]*[ ]?[a-zA-Z]?[\\d]*)";
    private static final String TXTWS2 = "([ \t]+[_a-zA-Z\\d]*[ ]?[a-zA-Z]?[\\d]*)";
    private static final String NUMWS = "([ \t]+[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?)";

    static {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(TXT);
        stringBuilder.append(TXTWS);
        stringBuilder.append(NUMWS);
        int n = 0;
        while (n < 3) {
            stringBuilder.append(NUMWS);
            stringBuilder.append("?");
            ++n;
        }
        CMD = Pattern.compile(stringBuilder.toString());
        stringBuilder = new StringBuilder();
        stringBuilder.append(NUM);
        stringBuilder.append(NUMWS);
        n = 0;
        while (n < 50) {
            stringBuilder.append(NUMWS);
            stringBuilder.append("?");
            ++n;
        }
        SCAN_LINE = Pattern.compile(stringBuilder.toString());
        stringBuilder = new StringBuilder();
        stringBuilder.append("#");
        stringBuilder.append(TXTWS2_NOSPC);
        n = 0;
        while (n < 50) {
            stringBuilder.append(TXTWS2);
            stringBuilder.append("?");
            ++n;
        }
        HEADER_LINE = Pattern.compile(stringBuilder.toString());
        PRINT = Pattern.compile("print ([a-zA-Z0-9\\'\"]+)");
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println(CMD.pattern());
        System.out.println("1.0".matches(NUM));
        Matcher matcher = CMD.matcher("ascan phi 0.1 10 10 .1");
        System.out.println(matcher.matches());
        System.out.println(CMD.matcher("ascan phi 0 10 10 1").matches());
        System.out.println(CMD.matcher("ascan kap1 0 10 10 1").matches());
        matcher = SCAN_LINE.matcher("1.0 0.0 1.0 1.0 0.107 1.0");
        System.out.println(matcher.matches());
        System.out.println(matcher.groupCount());
        matcher = SCAN_LINE.matcher("0  0.0000  0 0   0.107  0");
        System.out.println(matcher.matches());
        System.out.println(matcher.groupCount());
        matcher = SCAN_LINE.matcher("0    0.0000        0        0      0.107        0");
        System.out.println(matcher.matches());
        System.out.println(matcher.groupCount());
        matcher = HEADER_LINE.matcher("#       Phi Detector  Monitor    Seconds  Flux I0");
        System.out.println(matcher.matches());
        System.out.println(matcher.groupCount());
        System.out.println("FINISHED!");
    }
}

