/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.gda.extensions.spec;

import gda.analysis.io.ScanFileHolderException;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.dawb.gda.extensions.spec.MultiScanDataParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.io.AbstractFileLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.ExtendedMetadataAdapter;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.IMetaLoader;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.gda.monitor.IMonitor;

public class SpecLoader
extends AbstractFileLoader
implements IMetaLoader {
    private static Logger logger = LoggerFactory.getLogger(SpecLoader.class);
    private String filePath;
    private Collection<String> dataNames;
    private Map<String, Integer> dataSizes;
    private Map<String, int[]> dataShapes;

    public static void setLoaderInFactory() {
        try {
            LoaderFactory.registerLoader((String)"dat", SpecLoader.class, (int)1);
        }
        catch (Exception exception) {
            logger.error("Cannot register " + SpecLoader.class.getName() + " in " + LoaderFactory.class.getName(), (Throwable)exception);
        }
    }

    public SpecLoader() {
    }

    public SpecLoader(String string) {
        this.filePath = string;
    }

    public DataHolder loadFile() throws ScanFileHolderException {
        return this.loadFile(null);
    }

    public DataHolder loadFile(IMonitor iMonitor) throws ScanFileHolderException {
        try {
            DataHolder dataHolder = new DataHolder();
            MultiScanDataParser multiScanDataParser = new MultiScanDataParser(new FileInputStream(new File(this.filePath)));
            Collection<String> collection = multiScanDataParser.getScanNames();
            for (String string : collection) {
                Collection<AbstractDataset> collection2 = multiScanDataParser.getSets(string);
                for (AbstractDataset abstractDataset : collection2) {
                    dataHolder.addDataset(String.valueOf(string) + "/" + abstractDataset.getName(), (ILazyDataset)abstractDataset);
                }
            }
            return dataHolder;
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("Cannot parse " + this.filePath, (Throwable)exception);
        }
    }

    public void loadMetaData(IMonitor iMonitor) throws Exception {
        try {
            this.dataNames = new ArrayList<String>(31);
            this.dataSizes = new HashMap<String, Integer>(31);
            this.dataShapes = new HashMap<String, int[]>(31);
            MultiScanDataParser multiScanDataParser = new MultiScanDataParser(new FileInputStream(new File(this.filePath)));
            Collection<String> collection = multiScanDataParser.getScanNames();
            for (String string : collection) {
                Collection<AbstractDataset> collection2 = multiScanDataParser.getSets(string);
                for (AbstractDataset abstractDataset : collection2) {
                    String string2 = String.valueOf(string) + "/" + abstractDataset.getName();
                    this.dataNames.add(string2);
                    this.dataSizes.put(string2, abstractDataset.getSize());
                    this.dataShapes.put(string2, abstractDataset.getShape());
                }
            }
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("Cannot parse " + this.filePath, (Throwable)exception);
        }
    }

    public IMetaData getMetaData() {
        return new ExtendedMetadataAdapter(){

            public Collection<String> getDataNames() {
                return Collections.unmodifiableCollection(SpecLoader.this.dataNames);
            }

            public Map<String, Integer> getDataSizes() {
                return Collections.unmodifiableMap(SpecLoader.this.dataSizes);
            }

            public Map<String, int[]> getDataShapes() {
                return Collections.unmodifiableMap(SpecLoader.this.dataShapes);
            }
        };
    }
}

