/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.gda.extensions.spec;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.dawb.gda.extensions.spec.MultiScanDataEvent;
import org.dawb.gda.extensions.spec.MultiScanDataListener;
import org.dawb.gda.extensions.spec.SpecSyntax;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.FloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;

public class MultiScanDataParser {
    private static final Logger logger = LoggerFactory.getLogger(MultiScanDataParser.class);
    private int scanNumber = 0;
    private Map<String, Collection<AbstractDataset>> data;
    private MultiScanDataListener listener;
    private boolean parseComplete = false;
    private InputStream inputStream;
    private DefaultMutableTreeNode root;
    private String previousLine = null;
    private List<NumberObject> currentScans;
    private List<String> currentNames;

    public MultiScanDataParser(InputStream inputStream) throws Exception {
        this.data = new LinkedHashMap<String, Collection<AbstractDataset>>(27);
        this.createData(inputStream);
        this.finishScan(this.getScanName());
        this.parseComplete = true;
    }

    public MultiScanDataParser(InputStream inputStream, MultiScanDataListener multiScanDataListener) {
        this.listener = multiScanDataListener;
        this.data = new LinkedHashMap<String, Collection<AbstractDataset>>(1);
        this.inputStream = inputStream;
    }

    public void start() throws Exception {
        if (this.inputStream == null || this.listener == null) {
            throw new Exception("Not allowed to start, already parsing or parsed!");
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    MultiScanDataParser.this.createData(MultiScanDataParser.this.inputStream);
                    boolean bl = MultiScanDataParser.this.finishScan(MultiScanDataParser.this.getScanName());
                    if (!bl) {
                        return;
                    }
                }
                catch (Exception exception) {
                    logger.error("Cannot parse spec file!", (Throwable)exception);
                }
                finally {
                    MultiScanDataParser.this.parseComplete = true;
                }
            }
        }, "Spec File Parsing Thread");
        thread.setDaemon(true);
        thread.start();
    }

    public Collection<AbstractDataset> getSets(String string) {
        return this.data.get(string);
    }

    public Collection<AbstractDataset> removeScan(String string) {
        return this.data.remove(string);
    }

    public Collection<String> getScanNames() {
        return this.data.keySet();
    }

    public void clear() {
        this.data.clear();
    }

    public TreeNode getNode() {
        if (this.data == null) {
            return null;
        }
        if (this.root == null) {
            this.root = new DefaultMutableTreeNode("Spec");
        }
        this.updateNode(null);
        return this.root;
    }

    public TreeNode updateNode(String string) {
        if (string != null) {
            Object object;
            int n = 0;
            while (n < this.root.getChildCount()) {
                object = (DefaultMutableTreeNode)this.root.getChildAt(n);
                if (((DefaultMutableTreeNode)object).getUserObject().equals(string)) {
                    ((DefaultMutableTreeNode)object).removeAllChildren();
                    Collection<AbstractDataset> collection = this.data.get(string);
                    if (collection == null) {
                        return null;
                    }
                    for (AbstractDataset abstractDataset : collection) {
                        ((DefaultMutableTreeNode)object).add(new DefaultMutableTreeNode(abstractDataset));
                    }
                    return object;
                }
                ++n;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
            this.root.add(defaultMutableTreeNode);
            object = this.data.get(string);
            if (object == null) {
                return null;
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                AbstractDataset abstractDataset = (AbstractDataset)iterator.next();
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(abstractDataset));
            }
            return defaultMutableTreeNode;
        }
        for (String string2 : this.data.keySet()) {
            this.updateNode(string2);
        }
        return null;
    }

    private void createData(InputStream inputStream) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        try {
            String string = null;
            boolean bl = true;
            while ((string = bufferedReader.readLine()) != null) {
                if (bl) {
                    bl = false;
                    if (string.trim().startsWith("&")) {
                        throw new Exception("Cannot load SRS files with SpecLoader!");
                    }
                }
                this.processLine(string);
            }
        }
        finally {
            bufferedReader.close();
        }
    }

    public synchronized String processLine(String string) {
        Matcher matcher;
        if (string == null) {
            return null;
        }
        if ("".equals(string = string.trim())) {
            return null;
        }
        Matcher matcher2 = SpecSyntax.COMMENT.matcher(string);
        if (matcher2 != null && matcher2.matches()) {
            this.previousLine = string;
            return null;
        }
        Matcher matcher3 = SpecSyntax.SCAN_LINE.matcher(string);
        if (matcher3 == null || !matcher3.matches()) {
            return null;
        }
        boolean bl = false;
        if (this.previousLine != null && (matcher = SpecSyntax.HEADER_LINE.matcher(this.previousLine)) != null && matcher.matches()) {
            bl = true;
            this.finishScan(this.getScanName());
            this.startScan(matcher);
        }
        this.addData(bl, matcher3);
        return this.getScanName();
    }

    private boolean finishScan(String string) {
        this.update(true);
        if (this.listener != null) {
            Collection<AbstractDataset> collection = this.removeScan(string);
            if (collection == null) {
                return true;
            }
            return this.listener.specDataPerformed(new MultiScanDataEvent(this, string, collection));
        }
        return true;
    }

    public void update(boolean bl) {
        if (this.currentScans == null) {
            return;
        }
        Collection<AbstractDataset> collection = this.data.get(this.getScanName());
        if (collection != null) {
            collection.clear();
            for (NumberObject numberObject : this.currentScans) {
                collection.add(numberObject.toDataset());
            }
        }
        if (bl) {
            this.currentScans.clear();
        }
    }

    private void startScan(Matcher matcher) {
        this.previousLine = null;
        ++this.scanNumber;
        if (this.currentNames == null) {
            this.currentNames = new ArrayList<String>(27);
        }
        if (this.currentScans == null) {
            this.currentScans = new ArrayList<NumberObject>(27);
        }
        this.currentNames.clear();
        this.currentScans.clear();
        int n = 1;
        while (n <= matcher.groupCount()) {
            String string = matcher.group(n);
            if (string != null) {
                this.currentNames.add(string.trim());
            }
            ++n;
        }
        ArrayList arrayList = new ArrayList(this.currentScans.size());
        this.data.put(this.getScanName(), arrayList);
    }

    private String getScanName() {
        return "Scan " + this.scanNumber;
    }

    private void addData(boolean bl, Matcher matcher) {
        int n = 0;
        int n2 = 1;
        while (n2 <= matcher.groupCount()) {
            String string = matcher.group(n2);
            if (string != null && !"".equals(string.trim()) && !string.toLowerCase().startsWith("e")) {
                NumberObject numberObject;
                if (bl) {
                    String string2;
                    numberObject = new NumberObject();
                    try {
                        string2 = this.currentNames.get(n);
                    }
                    catch (Throwable throwable) {
                        string2 = "Column " + n2;
                    }
                    numberObject.setName(string2);
                    this.currentScans.add(numberObject);
                }
                numberObject = this.currentScans.get(n);
                numberObject.add(Float.valueOf(Float.parseFloat(string.trim())));
                ++n;
            }
            ++n2;
        }
        this.previousLine = null;
    }

    public boolean isParseComplete() {
        return this.parseComplete;
    }

    private static class NumberObject<T extends Number> {
        private String name;
        private List<T> numbers;

        NumberObject() {
            this.setNumbers(new ArrayList(31));
        }

        public AbstractDataset toDataset() {
            if (this.numbers.isEmpty()) {
                return null;
            }
            IntegerDataset integerDataset = null;
            if (this.numbers.get(0) instanceof Integer) {
                Integer[] integerArray = this.numbers.toArray(new Integer[this.numbers.size()]);
                int[] nArray = new int[integerArray.length];
                int n = 0;
                while (n < nArray.length) {
                    nArray[n] = integerArray[n];
                    ++n;
                }
                integerDataset = new IntegerDataset(nArray, new int[]{nArray.length});
                integerDataset.setName(this.getName());
            } else if (this.numbers.get(0) instanceof Float) {
                try {
                    Float[] floatArray = this.numbers.toArray(new Float[this.numbers.size()]);
                    float[] fArray = new float[floatArray.length];
                    int n = 0;
                    while (n < fArray.length) {
                        fArray[n] = floatArray[n].floatValue();
                        ++n;
                    }
                    integerDataset = new FloatDataset(fArray, new int[]{fArray.length});
                    integerDataset.setName(this.getName());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return integerDataset;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public List<? extends Number> getNumbers() {
            return this.numbers;
        }

        public void setNumbers(List<T> list) {
            this.numbers = list;
        }

        public void add(T t) {
            this.numbers.add(t);
        }
    }
}

