/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.gda.extensions.plot;

import java.util.Arrays;
import java.util.List;
import org.dawb.common.ui.plot.AbstractPlottingSystem;
import org.dawb.common.ui.plot.PlotType;
import org.dawb.common.ui.plot.trace.ITrace;
import org.dawb.common.ui.util.GridUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IGuiInfoManager;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IUpdateNotificationListener;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DUIAdapter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotWindow;
import uk.ac.diamond.scisoft.analysis.rcp.util.PlotMode;
import uk.ac.diamond.scisoft.analysis.rcp.util.PlotUtils;
import uk.ac.diamond.scisoft.analysis.rcp.views.PlotServerConnection;

public class DiamondPlottingSystem
extends AbstractPlottingSystem {
    private Logger logger = LoggerFactory.getLogger(DiamondPlottingSystem.class);
    private PlotServerConnection plotServerConnection;
    private PlotWindow plotWindow;

    public void createPlotPart(Composite composite, String string, IActionBars iActionBars, PlotType plotType, IWorkbenchPart iWorkbenchPart) {
        this.plotServerConnection = new PlotServerConnection(string);
        GuiBean guiBean = this.plotServerConnection.getGUIInfo();
        GuiPlotMode guiPlotMode = (GuiPlotMode)guiBean.get((Object)GuiParameters.PLOTMODE);
        this.plotWindow = new PlotWindow(composite, guiPlotMode, (IGuiInfoManager)this.plotServerConnection, (IUpdateNotificationListener)this.plotServerConnection, iActionBars, iWorkbenchPart.getSite().getPage(), string);
        this.plotServerConnection.setPlotWindow(this.plotWindow);
        Plot1DUIAdapter plot1DUIAdapter = (Plot1DUIAdapter)this.plotWindow.getPlotUI();
        plot1DUIAdapter.addPositionSwitchListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                GridUtils.setVisible((Control)DiamondPlottingSystem.this.pointControls, (boolean)((Boolean)propertyChangeEvent.getNewValue()));
                DiamondPlottingSystem.this.pointControls.getParent().layout(new Control[]{DiamondPlottingSystem.this.pointControls});
            }
        });
    }

    public Composite getPlotComposite() {
        return this.plotWindow.getMainPlotter().getComposite();
    }

    protected List<ITrace> createPlot(AbstractDataset abstractDataset, List<AbstractDataset> list, PlotType plotType, IProgressMonitor iProgressMonitor) {
        if (plotType.is1D()) {
            PlotUtils.create1DPlot((AbstractDataset)abstractDataset, list, (PlotMode)this.getPlotMode(plotType), (PlotWindow)this.plotWindow, (IProgressMonitor)iProgressMonitor);
        } else {
            PlotUtils.createPlot((AbstractDataset)abstractDataset, list, (GuiPlotMode)this.getGuiPlotMode(plotType), (PlotWindow)this.plotWindow, (IProgressMonitor)iProgressMonitor);
        }
        return null;
    }

    private GuiPlotMode getGuiPlotMode(PlotType plotType) {
        if (plotType == PlotType.IMAGE) {
            return GuiPlotMode.TWOD;
        }
        if (plotType == PlotType.SURFACE) {
            return GuiPlotMode.SURF2D;
        }
        return null;
    }

    private PlotMode getPlotMode(PlotType plotType) {
        if (plotType == PlotType.PT1D) {
            return PlotMode.PM1D;
        }
        if (plotType == PlotType.PT1D_STACKED) {
            return PlotMode.PMSTACKED;
        }
        if (plotType == PlotType.PT1D_3D) {
            return PlotMode.PM3D;
        }
        return null;
    }

    public void reset() {
        try {
            IntegerDataset integerDataset = new IntegerDataset(new int[2], new int[]{2});
            integerDataset.setName("-");
            this.plotWindow.getMainPlotter().replaceAllPlots(Arrays.asList(integerDataset));
            this.plotWindow.getMainPlotter().getColourTable().clearLegend();
            this.plotWindow.getMainPlotter().refresh(true);
        }
        catch (Throwable throwable) {
            this.logger.error("Cannot remove plots!", throwable);
        }
    }

    public void dispose() {
        if (this.plotServerConnection != null) {
            this.plotServerConnection.dispose();
        }
        if (this.plotWindow != null) {
            this.plotWindow.dispose();
        }
    }

    public void clear() {
        try {
            IntegerDataset integerDataset = new IntegerDataset(new int[2], new int[]{2});
            integerDataset.setName("-");
            this.plotWindow.getMainPlotter().replaceAllPlots(Arrays.asList(integerDataset));
            this.plotWindow.getMainPlotter().refresh(true);
        }
        catch (Throwable throwable) {
            this.logger.error("Cannot remove plots!", throwable);
        }
    }

    public AbstractDataset getData(String string) {
        List list = this.plotWindow.getMainPlotter().getCurrentDataSets();
        for (IDataset iDataset : list) {
            if (!string.equals(iDataset.getName())) continue;
            return (AbstractDataset)iDataset;
        }
        return null;
    }
}

