/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.gda.extensions.loaders;

import java.io.File;
import java.util.Collection;
import org.dawb.common.services.ILoaderService;
import org.dawb.common.util.eclipse.BundleUtils;
import org.dawb.fabio.FabioFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.services.AbstractServiceFactory;
import org.eclipse.ui.services.IServiceLocator;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.FloatDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.io.MetaDataAdapter;
import uk.ac.gda.monitor.IMonitor;
import uk.ac.gda.monitor.ProgressMonitorWrapper;

public class LoaderService
extends AbstractServiceFactory
implements ILoaderService {
    public AbstractDataset getDataset(String string) throws Throwable {
        return this.getDataset(string, (IProgressMonitor)new NullProgressMonitor());
    }

    public AbstractDataset getDataset(String string, IProgressMonitor iProgressMonitor) throws Throwable {
        return this.getDataset(new File(string), (IProgressMonitor)new NullProgressMonitor());
    }

    public AbstractDataset getDataset(File file) throws Throwable {
        return this.getDataset(file, (IProgressMonitor)new NullProgressMonitor());
    }

    public IMetaData getMetaData(String string, IProgressMonitor iProgressMonitor) throws Exception {
        boolean bl = LoaderService.getUsingFabio(new File(string).getName());
        Object object = null;
        if (!bl) {
            try {
                object = LoaderFactory.getMetaData((String)string, (IMonitor)new ProgressMonitorWrapper(iProgressMonitor));
                if (object == null) {
                    throw new Exception("No meta data found!");
                }
            }
            catch (Throwable throwable) {
                bl = true;
            }
        }
        if (bl && this.isFabioAvailable()) {
            final FabioFile fabioFile = new FabioFile(string);
            object = new MetaDataAdapter(){

                public String getMetaValue(String string) throws Exception {
                    return fabioFile.getValue(string);
                }

                public Collection<String> getMetaNames() throws Exception {
                    try {
                        return fabioFile.getKeysAsListedInHeader();
                    }
                    catch (Exception exception) {
                        throw exception;
                    }
                    catch (Throwable throwable) {
                        throw new Exception(throwable);
                    }
                }
            };
        }
        return object;
    }

    private boolean isFabioAvailable() {
        String string = BundleUtils.getEclipseHome();
        return new File(String.valueOf(string) + "/fabio").exists();
    }

    private AbstractDataset getDataset(File file, IProgressMonitor iProgressMonitor) throws Throwable {
        AbstractDataset abstractDataset = null;
        boolean bl = LoaderService.getUsingFabio(file.getName());
        if (!bl) {
            try {
                DataHolder dataHolder = LoaderFactory.getData((String)file.getAbsolutePath(), (boolean)false, (IMonitor)new ProgressMonitorWrapper(iProgressMonitor));
                abstractDataset = dataHolder.getDataset(0);
                abstractDataset.setName(file.getName());
                return abstractDataset;
            }
            catch (Throwable throwable) {
                bl = true;
            }
        }
        if (bl && this.isFabioAvailable()) {
            FabioFile fabioFile = new FabioFile(file.getAbsolutePath());
            float[] fArray = fabioFile.getImageAsFloat();
            abstractDataset = new FloatDataset(fArray, new int[]{fabioFile.getHeight(), fabioFile.getWidth()});
            abstractDataset.setName(file.getName());
        }
        return abstractDataset;
    }

    private static boolean getUsingFabio(String string) {
        ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.dawb.fable.framework.navigator");
        boolean bl = scopedPreferenceStore.getBoolean("fable.framework.navigator.preferences.useFabio");
        if (bl) {
            String string2 = scopedPreferenceStore.getString("pref_sampleNavigator_type");
            String[] stringArray = string2.split("\\|");
            int n = 0;
            while (n < stringArray.length) {
                if (string.endsWith("." + stringArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        return System.getProperty("org.dawb.fabio.always.use") != null;
    }

    public Object create(Class clazz, IServiceLocator iServiceLocator, IServiceLocator iServiceLocator2) {
        if (clazz == ILoaderService.class) {
            return new LoaderService();
        }
        return null;
    }
}

