/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.gda.extensions.loaders;

import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.h5.H5Datatype;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ByteDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.FloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.LongDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ShortDataset;

public class H5Utils {
    public static int getDataType(Datatype datatype) throws Exception {
        int n = datatype.getDatatypeClass();
        if (n == 10) {
            throw new Exception("Cannot read array type data sets!");
        }
        int n2 = datatype.getDatatypeSize() * 4;
        switch (n2) {
            case 8: {
                return 1;
            }
            case 16: {
                return 2;
            }
            case 32: {
                if (n == 0) {
                    return 3;
                }
                if (n == 1) {
                    return 5;
                }
            }
            case 64: {
                if (n == 0) {
                    return 4;
                }
                if (n != 1) break;
                return 6;
            }
        }
        return 6;
    }

    public static AbstractDataset getSet(Object object, Dataset dataset) throws Exception {
        return H5Utils.getSet(object, dataset.getDims(), dataset);
    }

    public static AbstractDataset getSet(Object object, long[] lArray, Dataset dataset) throws Exception {
        int[] nArray = H5Utils.getInt(lArray);
        if (object instanceof byte[]) {
            return new ByteDataset((byte[])object, nArray);
        }
        if (object instanceof short[]) {
            return new ShortDataset((short[])object, nArray);
        }
        if (object instanceof int[]) {
            return new IntegerDataset((int[])object, nArray);
        }
        if (object instanceof long[]) {
            return new LongDataset((long[])object, nArray);
        }
        if (object instanceof float[]) {
            return new FloatDataset((float[])object, nArray);
        }
        if (object instanceof double[]) {
            return new DoubleDataset((double[])object, nArray);
        }
        throw new Exception("Cannot deal with data type " + dataset.getDatatype().getDatatypeDescription());
    }

    public static int[] getInt(long[] lArray) {
        int[] nArray = new int[lArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = (int)lArray[n];
            ++n;
        }
        return nArray;
    }

    public static Datatype getDatatype(AbstractDataset abstractDataset) throws Exception {
        if (abstractDataset instanceof ByteDataset) {
            return new H5Datatype(0, 1, -1, 0);
        }
        if (abstractDataset instanceof ShortDataset) {
            return new H5Datatype(0, 2, -1, -1);
        }
        if (abstractDataset instanceof IntegerDataset) {
            return new H5Datatype(0, 4, -1, -1);
        }
        if (abstractDataset instanceof LongDataset) {
            return new H5Datatype(0, 8, -1, -1);
        }
        if (abstractDataset instanceof FloatDataset) {
            return new H5Datatype(1, 4, -1, -1);
        }
        if (abstractDataset instanceof DoubleDataset) {
            return new H5Datatype(1, 8, -1, -1);
        }
        throw new Exception("Cannot deal with data type " + abstractDataset.getClass().getName());
    }
}

