/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.gda.extensions.loaders;

import gda.analysis.io.ScanFileHolderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ncsa.hdf.object.Dataset;
import org.dawb.common.util.io.FileUtils;
import org.dawb.gda.extensions.loaders.H5LazyDataset;
import org.dawb.gda.extensions.loaders.H5Utils;
import org.dawb.hdf5.HierarchicalDataFactory;
import org.dawb.hdf5.HierarchicalInfo;
import org.dawb.hdf5.IHierarchicalDataFile;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.io.AbstractFileLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.IDataSetLoader;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.IMetaLoader;
import uk.ac.diamond.scisoft.analysis.io.ISliceLoader;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.io.MetaDataAdapter;
import uk.ac.diamond.scisoft.analysis.io.SliceObject;
import uk.ac.gda.monitor.IMonitor;

public class H5Loader
extends AbstractFileLoader
implements IMetaLoader,
IDataSetLoader,
ISliceLoader {
    private static final List<String> EXT = new ArrayList<String>(7);
    private String filePath;
    private List<String> allDataSetNames;
    private Map<String, Integer> allDataSetSizes;
    private Map<String, int[]> allDataSetShapes;

    static {
        EXT.add("h5");
        EXT.add("nxs");
        EXT.add("hd5");
        EXT.add("hdf5");
        EXT.add("hdf");
        EXT.add("nexus");
    }

    public static void setLoaderInFactory() throws Exception {
        LoaderFactory.getSupportedExtensions();
        for (String string : EXT) {
            LoaderFactory.clearLoader((String)string);
            LoaderFactory.registerLoader((String)string, H5Loader.class);
        }
    }

    public static boolean isH5(String string) {
        String string2 = FileUtils.getFileExtension((String)string);
        return EXT.contains(string2);
    }

    public H5Loader() {
    }

    public H5Loader(String string) {
        this.filePath = string;
    }

    public DataHolder loadFile() throws ScanFileHolderException {
        return this.loadFile(null);
    }

    public DataHolder loadFile(IMonitor iMonitor) throws ScanFileHolderException {
        DataHolder dataHolder = new DataHolder();
        IHierarchicalDataFile iHierarchicalDataFile = null;
        try {
            iHierarchicalDataFile = HierarchicalDataFactory.getReader((String)this.filePath);
            if (iMonitor != null) {
                iMonitor.worked(1);
            }
            List list = iHierarchicalDataFile.getDatasetNames(17061);
            if (iMonitor != null) {
                iMonitor.worked(1);
            }
            Map<String, ILazyDataset> map = this.getSets(iHierarchicalDataFile, list, iMonitor);
            for (String string : list) {
                dataHolder.addDataset(string, map.get(string));
                if (iMonitor == null) continue;
                iMonitor.worked(1);
            }
            DataHolder dataHolder2 = dataHolder;
            return dataHolder2;
        }
        catch (Exception exception) {
            throw new ScanFileHolderException(exception.getMessage());
        }
        finally {
            try {
                if (iHierarchicalDataFile != null) {
                    iHierarchicalDataFile.close();
                }
            }
            catch (Exception exception) {
                throw new ScanFileHolderException(exception.getMessage());
            }
        }
    }

    public synchronized AbstractDataset slice(SliceObject sliceObject, IMonitor iMonitor) throws Exception {
        IHierarchicalDataFile iHierarchicalDataFile = null;
        try {
            iHierarchicalDataFile = HierarchicalDataFactory.getReader((String)sliceObject.getPath());
            Dataset dataset = (Dataset)iHierarchicalDataFile.getData(sliceObject.getName());
            if (dataset.getStartDims() == null) {
                dataset.getMetadata();
            }
            long[] lArray = dataset.getStartDims();
            long[] lArray2 = dataset.getStride();
            long[] lArray3 = dataset.getSelectedDims();
            if (iMonitor != null) {
                iMonitor.worked(1);
            }
            int n = 0;
            while (n < lArray3.length) {
                lArray[n] = sliceObject.getSliceStart()[n];
                ++n;
            }
            n = 0;
            while (n < lArray2.length) {
                lArray2[n] = sliceObject.getSliceStep()[n];
                ++n;
            }
            n = 0;
            while (n < lArray3.length) {
                lArray3[n] = sliceObject.getSliceStop()[n] - sliceObject.getSliceStart()[n];
                ++n;
            }
            if (iMonitor != null) {
                iMonitor.worked(1);
            }
            Object object = dataset.read();
            if (iMonitor != null) {
                iMonitor.worked(1);
            }
            AbstractDataset abstractDataset = H5Utils.getSet(object, lArray3, dataset);
            this.resetDims(dataset);
            if (iMonitor != null) {
                iMonitor.worked(1);
            }
            AbstractDataset abstractDataset2 = abstractDataset;
            return abstractDataset2;
        }
        finally {
            if (iHierarchicalDataFile != null) {
                iHierarchicalDataFile.close();
            }
        }
    }

    protected void resetDims(Dataset dataset) {
        long[] lArray = dataset.getSelectedDims();
        long[] lArray2 = dataset.getDims();
        if (lArray2 == null || lArray == null) {
            return;
        }
        int n = 0;
        while (n < lArray.length) {
            lArray[n] = lArray2[n];
            ++n;
        }
    }

    public AbstractDataset loadSet(String string, String string2, IMonitor iMonitor) throws Exception {
        IHierarchicalDataFile iHierarchicalDataFile = null;
        try {
            iHierarchicalDataFile = HierarchicalDataFactory.getReader((String)string);
            if (iMonitor != null) {
                iMonitor.worked(1);
            }
            Dataset dataset = (Dataset)iHierarchicalDataFile.getData(string2);
            if (iMonitor != null) {
                iMonitor.worked(1);
            }
            Object object = dataset.read();
            if (iMonitor != null) {
                iMonitor.worked(1);
            }
            AbstractDataset abstractDataset = H5Utils.getSet(object, dataset);
            return abstractDataset;
        }
        finally {
            if (iHierarchicalDataFile != null) {
                iHierarchicalDataFile.close();
            }
        }
    }

    public Map<String, ILazyDataset> loadSets(String string, List<String> list, IMonitor iMonitor) throws Exception {
        IHierarchicalDataFile iHierarchicalDataFile = null;
        try {
            if (iMonitor != null) {
                iMonitor.worked(1);
            }
            iHierarchicalDataFile = HierarchicalDataFactory.getReader((String)string);
            Map<String, ILazyDataset> map = this.getSets(iHierarchicalDataFile, list, iMonitor);
            return map;
        }
        finally {
            if (iHierarchicalDataFile != null) {
                iHierarchicalDataFile.close();
            }
        }
    }

    private Map<String, ILazyDataset> getSets(IHierarchicalDataFile iHierarchicalDataFile, List<String> list, IMonitor iMonitor) throws Exception {
        HashMap<String, ILazyDataset> hashMap = new HashMap<String, ILazyDataset>(list.size());
        for (String string : list) {
            if (iMonitor != null) {
                iMonitor.worked(1);
            }
            Dataset dataset = (Dataset)iHierarchicalDataFile.getData(string);
            dataset.getMetadata();
            H5LazyDataset h5LazyDataset = new H5LazyDataset(dataset, iHierarchicalDataFile.getPath());
            hashMap.put(string, (ILazyDataset)h5LazyDataset);
        }
        return hashMap;
    }

    public void loadMetaData(IMonitor iMonitor) throws Exception {
        IHierarchicalDataFile iHierarchicalDataFile = null;
        try {
            iHierarchicalDataFile = HierarchicalDataFactory.getReader((String)this.filePath);
            if (iMonitor != null) {
                iMonitor.worked(1);
            }
            HierarchicalInfo hierarchicalInfo = iHierarchicalDataFile.getDatasetInformation(17061);
            if (iMonitor != null) {
                iMonitor.worked(1);
            }
            this.allDataSetNames = hierarchicalInfo.getDataSetNames();
            if (iMonitor != null) {
                iMonitor.worked(1);
            }
            this.allDataSetSizes = hierarchicalInfo.getDataSetSizes();
            if (iMonitor != null) {
                iMonitor.worked(1);
            }
            this.allDataSetShapes = hierarchicalInfo.getDataSetShapes();
        }
        finally {
            if (iHierarchicalDataFile != null) {
                iHierarchicalDataFile.close();
            }
        }
    }

    public IMetaData getMetaData() {
        return new MetaDataAdapter(){

            public String getMetaValue(String string) {
                return null;
            }

            public Collection<String> getDataNames() {
                return Collections.unmodifiableCollection(H5Loader.this.allDataSetNames);
            }

            public Map<String, Integer> getDataSizes() {
                return H5Loader.this.allDataSetSizes;
            }

            public Map<String, int[]> getDataShapes() {
                return H5Loader.this.allDataSetShapes;
            }
        };
    }
}

