/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.gda.extensions.loaders;

import gda.analysis.io.ScanFileHolderException;
import java.io.File;
import ncsa.hdf.object.Dataset;
import org.dawb.gda.extensions.loaders.H5Loader;
import org.dawb.gda.extensions.loaders.H5Utils;
import org.dawb.hdf5.HierarchicalDataFactory;
import org.dawb.hdf5.IHierarchicalDataFile;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.io.ILazyLoader;
import uk.ac.diamond.scisoft.analysis.io.SliceObject;
import uk.ac.gda.monitor.IMonitor;

public class H5LazyLoader
implements ILazyLoader {
    private static final long serialVersionUID = 8487401618753205118L;
    private String path;
    private String fullPath;
    private H5Loader loader = new H5Loader();

    public H5LazyLoader(String string, String string2) {
        this.path = string;
        this.fullPath = string2;
    }

    public boolean isFileReadable() {
        return new File(this.path).canRead();
    }

    public AbstractDataset getDataset(IMonitor iMonitor, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) throws ScanFileHolderException {
        if (nArray == null || nArray2 == null || nArray3 == null || nArray4 == null) {
            try {
                return this.getCompleteData(iMonitor);
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("Cannot read " + this.path + ", " + this.fullPath, (Throwable)exception);
            }
        }
        SliceObject sliceObject = new SliceObject();
        sliceObject.setPath(this.path);
        sliceObject.setName(this.fullPath);
        sliceObject.setSlicedShape(nArray);
        sliceObject.setSliceStart(nArray2);
        sliceObject.setSliceStop(nArray3);
        sliceObject.setSliceStep(nArray4);
        try {
            return this.loader.slice(sliceObject, iMonitor);
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("Cannot slice " + this.path + ", " + this.fullPath, (Throwable)exception);
        }
    }

    protected AbstractDataset getCompleteData(IMonitor iMonitor) throws Exception {
        IHierarchicalDataFile iHierarchicalDataFile = null;
        try {
            Dataset dataset;
            if (iMonitor != null) {
                iMonitor.worked(1);
            }
            if ((dataset = (Dataset)(iHierarchicalDataFile = HierarchicalDataFactory.getReader((String)this.path)).getData(this.fullPath)).getStartDims() == null) {
                dataset.getMetadata();
            }
            this.loader.resetDims(dataset);
            Object object = dataset.read();
            AbstractDataset abstractDataset = H5Utils.getSet(object, dataset);
            return abstractDataset;
        }
        finally {
            if (iHierarchicalDataFile != null) {
                iHierarchicalDataFile.close();
            }
        }
    }
}

