/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.gda.extensions.jython;

import com.thoughtworks.xstream.core.util.CompositeClassLoader;
import java.io.File;
import java.util.Iterator;
import org.dawb.common.util.eclipse.BundleUtils;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.ui.interpreters.JythonInterpreterManager;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;
import org.python.util.PythonInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.PlotServer;
import uk.ac.diamond.scisoft.python.PythonUtils;
import uk.ac.gda.util.OSUtils;

public class JythonInterpreterUtils {
    private static Logger logger = LoggerFactory.getLogger(JythonInterpreterUtils.class);

    static {
        PySystemState.initialize();
    }

    public static PythonInterpreter getInterpreter() throws Exception {
        Object object;
        Object object2;
        File file;
        File file2;
        long l = System.currentTimeMillis();
        logger.debug("Starting new Jython Interpreter.");
        PySystemState.add_package((String)"uk.ac.diamond.scisoft.analysis.plotserver");
        PySystemState.add_package((String)"uk.ac.diamond.scisoft.python");
        PySystemState pySystemState = new PySystemState();
        CompositeClassLoader compositeClassLoader = new CompositeClassLoader();
        compositeClassLoader.add(PlotServer.class.getClassLoader());
        compositeClassLoader.add(PythonUtils.class.getClassLoader());
        pySystemState.setClassLoader((ClassLoader)compositeClassLoader);
        try {
            file2 = BundleUtils.getBundleLocation((String)"uk.ac.gda.libs");
        }
        catch (Exception exception) {
            file2 = null;
        }
        if (file2 == null) {
            if (System.getProperty("test.libs.location") == null) {
                throw new Exception("Please set the property 'test.libs.location' for this test to work!");
            }
            file2 = new File(System.getProperty("test.libs.location"));
        }
        String string = String.valueOf(file2.getAbsolutePath()) + "/jython2.5.1/Lib/";
        pySystemState.path.append((PyObject)new PyString(string));
        pySystemState.path.append((PyObject)new PyString(String.valueOf(string) + "dist-utils"));
        pySystemState.path.append((PyObject)new PyString(String.valueOf(string) + "site-packages"));
        pySystemState.path.append((PyObject)new PyString(String.valueOf(string) + "site-packages/decorator-3.2.0-py2.5.egg"));
        pySystemState.path.append((PyObject)new PyString(String.valueOf(string) + "nose-0.11.1-py2.5.egg/nose/ext"));
        try {
            file = BundleUtils.getBundleLocation((String)"uk.ac.diamond.scisoft.python");
            pySystemState.path.append((PyObject)new PyString(file.getAbsolutePath()));
            pySystemState.path.append((PyObject)new PyString(new File(file, "src").getAbsolutePath()));
            pySystemState.path.append((PyObject)new PyString(new File(file, "bin").getAbsolutePath()));
        }
        catch (Exception exception) {
            logger.error("Could not find Scisoft Python plugin", (Throwable)exception);
        }
        file = (JythonInterpreterManager)PydevPlugin.getJythonInterpreterManager();
        InterpreterInfo interpreterInfo = null;
        try {
            interpreterInfo = file.getInterpreterInfo("Jython2.5.1", null);
        }
        catch (Throwable throwable) {
            interpreterInfo = null;
        }
        try {
            if (interpreterInfo == null) {
                interpreterInfo = file.getInterpreterInfo("jython2.5.1", null);
            }
        }
        catch (Throwable throwable) {
            interpreterInfo = null;
        }
        if (interpreterInfo != null) {
            object2 = interpreterInfo.getPythonPath();
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                pySystemState.path.append((PyObject)new PyString((String)object));
            }
        }
        if (((String)(object2 = System.getProperty("eclipse.home.location"))).startsWith("file:")) {
            object2 = ((String)object2).substring("file:".length());
        }
        if (((String)object2).startsWith("/") && OSUtils.isWindowsOS()) {
            object2 = ((String)object2).substring(1);
        }
        pySystemState.path.append((PyObject)new PyString(String.valueOf(object2) + "/plugins"));
        try {
            object = BundleUtils.getBundleLocation((String)"uk.ac.diamond.scisoft.analysis");
            pySystemState.path.append((PyObject)new PyString(((File)object).getAbsolutePath()));
            pySystemState.path.append((PyObject)new PyString(new File((File)object, "bin").getAbsolutePath()));
        }
        catch (Exception exception) {
            logger.error("Could not find Scisoft Python plugin", (Throwable)exception);
        }
        object = new PythonInterpreter((PyObject)new PyStringMap(), pySystemState);
        object.exec("import scisoftpy as dnp");
        object.exec("import scisoftpy.jython.jycore as jycore");
        object.exec("import scisoftpy.maths as maths");
        long l2 = System.currentTimeMillis();
        logger.debug("Created new Jython Interpreter in " + (l2 - l) + "ms.");
        return object;
    }
}

