/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.gda.extensions.h5;

import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.h5.H5Group;
import ncsa.hdf.object.h5.H5ScalarDS;
import org.dawb.hdf5.editor.IH5DoubleClickSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Dataset;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5File;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Group;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5NodeLink;
import uk.ac.diamond.scisoft.analysis.io.ExternalFiles;
import uk.ac.diamond.scisoft.analysis.io.HDF5Loader;
import uk.ac.diamond.scisoft.analysis.rcp.hdf5.HDF5Utils;

public class HDF5SelectionProvider
implements IH5DoubleClickSelectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(HDF5SelectionProvider.class);

    public ISelection getSelection(ISelection iSelection, String string) throws Exception {
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            Object[] objectArray = iStructuredSelection.toArray();
            if (objectArray == null) {
                return null;
            }
            HDF5File hDF5File = null;
            HDF5Dataset hDF5Dataset = null;
            HDF5Group hDF5Group = null;
            String string2 = null;
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof TreeNode) {
                    TreeNode treeNode = (TreeNode)objectArray[n];
                    TreeNode treeNode2 = treeNode.getParent();
                    HObject hObject = (HObject)((DefaultMutableTreeNode)((DefaultMutableTreeNode)treeNode).getRoot()).getUserObject();
                    HObject hObject2 = null;
                    if (treeNode2 != null) {
                        hObject2 = (HObject)((DefaultMutableTreeNode)treeNode2).getUserObject();
                        hDF5File = new HDF5File(hObject.getOID()[0], string);
                        hDF5Group = this.createGroup(hObject2, hDF5File);
                    }
                    if ((hObject2 = (HObject)((DefaultMutableTreeNode)treeNode).getUserObject()) instanceof Dataset) {
                        Dataset dataset = (Dataset)hObject2;
                        hDF5Dataset = this.createDataset(dataset, string, new HDF5File(hObject.getOID()[0], string));
                        string2 = dataset.getFullName();
                    }
                }
                ++n;
            }
            HDF5NodeLink hDF5NodeLink = new HDF5NodeLink(hDF5File, string, string2, hDF5Group, hDF5Dataset);
            return HDF5Utils.createDatasetSelection((HDF5NodeLink)hDF5NodeLink, (boolean)false);
        }
        return null;
    }

    private HDF5Dataset createDataset(Dataset dataset, String string, HDF5File hDF5File) throws Exception {
        long l = dataset.getOID()[0];
        HDF5Dataset hDF5Dataset = new HDF5Dataset(l);
        Datatype datatype = dataset.getDatatype();
        int n = datatype.getDatatypeClass();
        if (n == 6) {
            return hDF5Dataset;
        }
        hDF5Dataset.setTypeName(HDF5Loader.getTypeName((Datatype)datatype));
        if (!(dataset instanceof H5ScalarDS)) {
            throw new IllegalArgumentException("Dataset unsupported");
        }
        H5ScalarDS h5ScalarDS = (H5ScalarDS)dataset;
        if (n == 3) {
            h5ScalarDS.setConvertByteToString(true);
            if (hDF5Dataset.containsAttribute("data_filename")) {
                ExternalFiles externalFiles = HDF5Loader.extractExternalFileNames((H5ScalarDS)h5ScalarDS);
                try {
                    ILazyDataset iLazyDataset = HDF5Loader.createStackedDatasetFromStrings((ExternalFiles)externalFiles);
                    hDF5Dataset.setDataset(iLazyDataset);
                }
                catch (Throwable throwable) {
                    logger.error("Unable to create lazydataset for" + h5ScalarDS, throwable);
                    hDF5Dataset.setString(externalFiles.getAsText());
                }
            } else {
                hDF5Dataset.setDataset(HDF5Loader.createLazyDataset((String)hDF5File.getHostname(), (H5ScalarDS)h5ScalarDS, (boolean)false));
                hDF5Dataset.setMaxShape(h5ScalarDS.getMaxDims());
            }
        } else {
            hDF5Dataset.setDataset(HDF5Loader.createLazyDataset((String)hDF5File.getHostname(), (H5ScalarDS)h5ScalarDS, (boolean)false));
            hDF5Dataset.setMaxShape(h5ScalarDS.getMaxDims());
        }
        return hDF5Dataset;
    }

    private HDF5Group createGroup(HObject hObject, HDF5File hDF5File) throws Exception {
        long l = hObject.getOID()[0];
        H5Group h5Group = (H5Group)hObject;
        HDF5Group hDF5Group = new HDF5Group(l);
        List list = h5Group.getMemberList();
        for (HObject hObject2 : list) {
            String string = hObject2.getPath();
            String string2 = hObject2.getName();
            hDF5Group.addNode(hDF5File, string, string2, HDF5Loader.copyNode((HDF5File)hDF5File, null, (HObject)hObject2, (boolean)false));
        }
        return hDF5Group;
    }
}

