/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.hardware.motor;

import org.dawb.passerelle.actors.hardware.motor.MotorContainer;
import org.dawb.passerelle.actors.hardware.motor.MotorDialog;
import org.dawb.passerelle.common.parameter.CellEditorParameter;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class MotorParameter
extends CellEditorParameter {
    private static final long serialVersionUID = 8999174318856900808L;
    private static final Logger logger = LoggerFactory.getLogger(MotorParameter.class);

    public MotorParameter(NamedObj namedObj, String string) throws IllegalActionException, NameDuplicationException {
        super(namedObj, string);
    }

    public CellEditor createCellEditor(Control control) {
        DialogCellEditor dialogCellEditor = new DialogCellEditor((Composite)control){

            protected Object openDialogBox(Control control) {
                MotorDialog motorDialog = new MotorDialog(control.getShell(), MotorParameter.this.getContainer());
                motorDialog.create();
                motorDialog.getShell().setSize(450, 600);
                motorDialog.getShell().setText("Read and Write Motor Values");
                motorDialog.setBean(MotorParameter.this.getBeanFromValue(MotorContainer.class));
                int n = motorDialog.open();
                if (n == 0) {
                    return MotorParameter.this.getValueFromBean((MotorContainer)motorDialog.getBean());
                }
                return null;
            }

            protected void updateContents(Object object) {
                if (this.getDefaultLabel() == null) {
                    return;
                }
                this.getDefaultLabel().setText(MotorParameter.this.getRendererText());
            }
        };
        return dialogCellEditor;
    }

    public String getRendererText() {
        return this.getBeanFromValue(MotorContainer.class).toString();
    }
}

