/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.hardware.motor;

import java.util.HashMap;
import java.util.List;
import org.dawb.common.ui.util.GridUtils;
import org.dawb.passerelle.actors.hardware.motor.MotorBean;
import org.dawb.passerelle.actors.hardware.motor.MotorComposite;
import org.dawb.passerelle.common.actors.AbstractDataMessageTransformer;
import org.dawb.passerelle.common.message.IVariable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import ptolemy.kernel.util.NamedObj;
import uk.ac.gda.richbeans.components.selector.BeanSelectionEvent;
import uk.ac.gda.richbeans.components.selector.BeanSelectionListener;
import uk.ac.gda.richbeans.components.selector.VerticalListEditor;
import uk.ac.gda.richbeans.dialog.BeanDialog;

public class MotorDialog
extends BeanDialog {
    private VerticalListEditor expressions;
    private AbstractDataMessageTransformer parent;

    protected MotorDialog(Shell shell, NamedObj namedObj) {
        super(shell);
        this.parent = (AbstractDataMessageTransformer)namedObj;
    }

    public Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(composite2, 64);
        label.setText("Set and read motor values here. The expression is used to set value, the motor value is read into a variable of the same name as the motor. For instance if the motor path is 'motors/phi', the motor name is 'phi'. Motors written are always read afterwards and their value passed on.");
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        this.expressions = new VerticalListEditor(composite2, 0);
        this.expressions.setRequireSelectionPack(false);
        this.expressions.setLayoutData((Object)new GridData(4, 4, true, true));
        this.expressions.setMinItems(0);
        this.expressions.setMaxItems(25);
        this.expressions.setDefaultName("motor");
        this.expressions.setEditorClass(MotorBean.class);
        final MotorComposite motorComposite = this.createMotorComposite();
        this.expressions.setEditorUI((Object)motorComposite);
        this.expressions.setNameField("motorName");
        this.expressions.setAdditionalFields(new String[]{"expression"});
        this.expressions.setColumnWidths(new int[]{100, 300});
        this.expressions.setListHeight(150);
        this.expressions.addBeanSelectionListener(new BeanSelectionListener(){

            public void selectionChanged(BeanSelectionEvent beanSelectionEvent) {
                motorComposite.updateVisibility();
            }
        });
        GridUtils.setVisibleAndLayout((Control)this.expressions, (boolean)true);
        return composite2;
    }

    private MotorComposite createMotorComposite() {
        MotorComposite motorComposite = new MotorComposite((Composite)this.expressions, 0);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(7);
        List list = this.parent.getInputVariables();
        for (IVariable iVariable : list) {
            Object object = iVariable.getExampleValue();
            if (object instanceof String) {
                try {
                    object = Double.parseDouble((String)object);
                }
                catch (Exception exception) {}
            }
            hashMap.put(iVariable.getVariableName(), object);
        }
        motorComposite.setExpressionVariables(hashMap);
        return motorComposite;
    }

    public VerticalListEditor getExpressions() {
        return this.expressions;
    }

    public int open() {
        this.expressions.setShowAdditionalFields(true);
        int n = super.open();
        this.expressions = null;
        return n;
    }
}

