/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.hardware.motor;

import java.util.ArrayList;
import java.util.List;
import org.dawb.passerelle.actors.hardware.motor.MotorBean;

public class MotorContainer {
    private List<MotorBean> expressions = new ArrayList<MotorBean>();

    public void clear() {
        if (this.expressions != null) {
            this.expressions.clear();
        }
    }

    public List<MotorBean> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<MotorBean> list) {
        this.expressions = list;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.expressions == null ? 0 : this.expressions.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MotorContainer motorContainer = (MotorContainer)object;
        return !(this.expressions == null ? motorContainer.expressions != null : !this.expressions.equals(motorContainer.expressions));
    }

    public MotorBean getBean(String string) {
        if (string == null) {
            return null;
        }
        if (this.expressions == null) {
            return null;
        }
        for (MotorBean motorBean : this.expressions) {
            if (!string.equals(motorBean.getMotorName())) continue;
            return motorBean;
        }
        return null;
    }

    public String toString() {
        if (this.expressions == null || this.expressions.isEmpty()) {
            return "No motors set or read, click to edit...";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (MotorBean motorBean : this.expressions) {
            if (motorBean.isReadOnly()) {
                stringBuilder.append("read '");
                stringBuilder.append(motorBean.getMotorName());
                stringBuilder.append("'");
            } else {
                stringBuilder.append("set '");
                stringBuilder.append(motorBean.getMotorName());
                stringBuilder.append("' to ");
                stringBuilder.append(motorBean.getExpression());
            }
            stringBuilder.append(";  ");
        }
        return stringBuilder.toString();
    }

    public int size() {
        return this.expressions.size();
    }

    public boolean isEmpty() {
        return this.expressions == null || this.size() < 1;
    }
}

