/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.hardware.motor;

import com.swtdesigner.ResourceManager;
import java.util.Map;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import uk.ac.gda.common.rcp.util.GridUtils;
import uk.ac.gda.richbeans.components.wrappers.BooleanWrapper;
import uk.ac.gda.richbeans.components.wrappers.TextWrapper;
import uk.ac.gda.richbeans.event.ValueAdapter;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.richbeans.event.ValueListener;

public class MotorComposite
extends Composite {
    private TextWrapper motorName;
    private TextWrapper expression;
    private TextWrapper attributeName;
    private BooleanWrapper readOnly;
    private Label expressionLabel;
    private ControlDecoration controlDecoration;

    public MotorComposite(Composite composite, int n) {
        super(composite, n);
        this.setLayoutData(new GridData(4, 4, true, false));
        this.setLayout((Layout)new GridLayout(1, false));
        Composite composite2 = new Composite((Composite)this, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, true, false));
        composite2.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite2, 0);
        label.setText("Motor Name");
        this.controlDecoration = new ControlDecoration((Control)label, 16512);
        this.controlDecoration.setImage(ResourceManager.getPluginImage((Object)"org.dawb.passerelle.actors", (String)"icons/hardware.gif"));
        this.controlDecoration.setDescriptionText("The motor path after the beamline part of the path, for instance 'motors/phi'");
        this.motorName = new TextWrapper(composite2, 0);
        this.motorName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.motorName.setTextLimit(64);
        Label label2 = new Label(composite2, 0);
        label2.setText("Read only");
        this.readOnly = new BooleanWrapper(composite2, 524288);
        this.readOnly.addValueListener((ValueListener)new ValueAdapter(){

            public void valueChangePerformed(ValueEvent valueEvent) {
                MotorComposite.this.updateVisibility();
            }
        });
        this.expressionLabel = new Label(composite2, 0);
        this.expressionLabel.setText("Value");
        this.expression = new TextWrapper(composite2, 0);
        this.expression.setTextType(TextWrapper.TEXT_TYPE.EXPRESSION);
        this.expression.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final ExpandableComposite expandableComposite = new ExpandableComposite((Composite)this, 0);
        expandableComposite.setExpanded(false);
        expandableComposite.setText("Advanced");
        expandableComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final Composite composite3 = new Composite((Composite)this, 0);
        composite3.setLayout((Layout)new GridLayout(2, false));
        composite3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label3 = new Label(composite3, 0);
        label3.setText("Attribute Name");
        this.attributeName = new TextWrapper(composite3, 0);
        this.attributeName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.attributeName.setToolTipText("The attribute name or 'Position' if left blank.");
        GridUtils.setVisible((Control)composite3, (boolean)false);
        ExpansionAdapter expansionAdapter = new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent expansionEvent) {
                GridUtils.setVisible((Control)composite3, (!composite3.isVisible() ? 1 : 0) != 0);
                MotorComposite.this.layout(new Control[]{composite3, expandableComposite});
                MotorComposite.this.getParent().layout();
                MotorComposite.this.getParent().getParent().layout();
            }
        };
        expandableComposite.addExpansionListener((IExpansionListener)expansionAdapter);
    }

    public TextWrapper getMotorName() {
        return this.motorName;
    }

    public TextWrapper getExpression() {
        return this.expression;
    }

    public TextWrapper getAttributeName() {
        return this.attributeName;
    }

    public BooleanWrapper getReadOnly() {
        return this.readOnly;
    }

    protected void setExpressionVariables(Map<String, Object> map) {
        this.expression.setExpressionVariables(map);
    }

    public void updateVisibility() {
        GridUtils.setVisible((Control)this.expressionLabel, (this.readOnly.getValue() == false ? 1 : 0) != 0);
        GridUtils.setVisible((Control)this.expression, (this.readOnly.getValue() == false ? 1 : 0) != 0);
        this.layout(new Control[]{this.expressionLabel, this.expression});
    }
}

