/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.hardware;

import com.isencia.passerelle.actor.ProcessingException;
import fr.esrf.TangoApi.DeviceAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dawb.common.util.ExpressionUtils;
import org.dawb.common.util.SubstituteUtils;
import org.dawb.passerelle.actors.hardware.motor.MotorBean;
import org.dawb.passerelle.actors.hardware.motor.MotorContainer;
import org.dawb.passerelle.actors.hardware.motor.MotorParameter;
import org.dawb.passerelle.common.actors.AbstractDataMessageTransformer;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.DataMessageException;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.MessageUtils;
import org.dawb.passerelle.common.message.Variable;
import org.dawb.tango.extensions.TangoUtils;
import org.dawb.tango.extensions.factory.TangoConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;

public class TangoMotorTransformer
extends AbstractDataMessageTransformer {
    private static final Logger logger = LoggerFactory.getLogger(TangoMotorTransformer.class);
    private static final long serialVersionUID = -5335673681296652024L;
    private MotorParameter motorsParam = new MotorParameter((NamedObj)this, "Motors");

    public TangoMotorTransformer(CompositeEntity compositeEntity, String string) throws Exception {
        super(compositeEntity, string);
        this.registerConfigurableParameter((Parameter)this.motorsParam);
        this.memoryManagementParam.setVisibility(Settable.NONE);
        this.dataSetNaming.setVisibility(Settable.NONE);
    }

    protected int getMinimumCacheSize() {
        return 0;
    }

    protected DataMessageComponent getTransformedMessage(List<DataMessageComponent> list) throws ProcessingException {
        try {
            MotorContainer motorContainer = (MotorContainer)this.motorsParam.getBeanFromValue(MotorContainer.class);
            DataMessageComponent dataMessageComponent = MessageUtils.mergeAll(list);
            if (motorContainer == null) {
                dataMessageComponent.putScalar("error_messsage", "No motors configured, '" + this.getName() + "' did nothing.");
                return dataMessageComponent;
            }
            Map<String, String> map = this.setMotors(motorContainer, dataMessageComponent);
            if (map != null) {
                dataMessageComponent.addScalar(map);
            }
            return dataMessageComponent;
        }
        catch (Exception exception) {
            throw this.createDataMessageException("Cannot set motor values!", exception);
        }
    }

    private Map<String, String> setMotors(MotorContainer motorContainer, DataMessageComponent dataMessageComponent) throws DataMessageException {
        HashMap<String, String> hashMap = new HashMap<String, String>(motorContainer.size());
        for (MotorBean motorBean : motorContainer.getExpressions()) {
            Object object;
            String string = SubstituteUtils.substitute((String)motorBean.getMotorName(), (Map)dataMessageComponent.getScalar());
            String string2 = TangoUtils.getHardwareAddress((String)string);
            String string3 = motorBean.getAttributeName();
            if (string3 == null || "".equals(string3.trim())) {
                string3 = "Position";
            }
            DeviceAttribute deviceAttribute = null;
            if (!motorBean.isReadOnly()) {
                try {
                    double d = ExpressionUtils.evaluateExpression((String)motorBean.getExpression(), (Map)dataMessageComponent.getScalar());
                    if (Double.isNaN(d) || Double.isInfinite(d)) {
                        throw new Exception();
                    }
                    deviceAttribute = new DeviceAttribute(string3, d);
                }
                catch (Exception exception) {
                    object = SubstituteUtils.substitute((String)motorBean.getExpression(), (Map)dataMessageComponent.getScalar());
                    deviceAttribute = new DeviceAttribute(string3, (String)object);
                }
            }
            try {
                object = TangoConnectionFactory.openConnection((String)string2, (String)string3);
                if (deviceAttribute != null) {
                    object.setValue(deviceAttribute);
                }
                try {
                    deviceAttribute = object.getValue();
                }
                catch (Exception exception) {
                    logger.debug("Error in TangoMotorTransformer " + this.getName());
                    logger.debug("Error message: " + exception.getMessage());
                    logger.debug(exception.getStackTrace().toString());
                    deviceAttribute = new DeviceAttribute(string3, 0.0);
                }
                try {
                    String string4 = String.valueOf(deviceAttribute.extractDouble());
                    hashMap.put(object.getName(), string4);
                }
                catch (Exception exception) {
                    hashMap.put(object.getName(), String.valueOf(deviceAttribute.extractString()));
                }
            }
            catch (Exception exception) {
                throw this.createDataMessageException("Cannot connect to " + string2, exception);
            }
        }
        return hashMap;
    }

    protected String getOperationName() {
        return "Get/Set Motor";
    }

    protected String getExtendedInfo() {
        return "Actor to set and get motor";
    }

    public List<IVariable> getOutputVariables() {
        try {
            List list = super.getOutputVariables();
            MotorContainer motorContainer = (MotorContainer)this.motorsParam.getBeanFromValue(MotorContainer.class);
            if (motorContainer == null || motorContainer.isEmpty()) {
                return list;
            }
            for (MotorBean motorBean : motorContainer.getExpressions()) {
                list.add(new Variable(motorBean.getMotorName().substring(motorBean.getMotorName().lastIndexOf(47) + 1), IVariable.VARIABLE_TYPE.SCALAR, (Object)motorBean.getExpression(), String.class));
            }
            return list;
        }
        catch (Exception exception) {
            logger.error("Cannot read variables", (Throwable)exception);
            return null;
        }
    }
}

