/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.hardware;

import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.util.ptolemy.StringChoiceParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dawb.passerelle.common.actors.AbstractDataMessageTransformer;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.MessageUtils;
import org.dawb.tango.extensions.factory.TangoConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NamedObj;

public class TangoMockModeTransformer
extends AbstractDataMessageTransformer {
    private static final long serialVersionUID = -2405810900325470900L;
    private static final Logger logger = LoggerFactory.getLogger(TangoMockModeTransformer.class);
    protected static final List<String> ACTOR_MODE = new ArrayList<String>(4);
    private final Parameter actorModeParameter;
    private final StringParameter tangoMockModeVariableNameParam;
    private final Parameter passInputsParameter;
    private String actorMode = ACTOR_MODE.get(0);
    private String tangoMockModeVariableName = "tango_mock_mode";
    private boolean isPassInputs = true;

    static {
        ACTOR_MODE.add("TANGO Mock Mode variable read-only");
        ACTOR_MODE.add("TANGO Mock Mode set by variable");
        ACTOR_MODE.add("TANGO Mock Mode forced to true");
        ACTOR_MODE.add("TANGO Mock Mode forced to false");
    }

    public TangoMockModeTransformer(CompositeEntity compositeEntity, String string) throws Exception {
        super(compositeEntity, string);
        this.actorModeParameter = new StringChoiceParameter((NamedObj)this, "Actor Mode", ACTOR_MODE, 4);
        this.registerConfigurableParameter(this.actorModeParameter);
        this.actorModeParameter.setExpression(ACTOR_MODE.get(0));
        this.tangoMockModeVariableNameParam = new StringParameter((NamedObj)this, "TANGO Mock Mode Variable Name");
        this.registerConfigurableParameter((Parameter)this.tangoMockModeVariableNameParam);
        this.tangoMockModeVariableNameParam.setExpression(this.tangoMockModeVariableName);
        this.passInputsParameter = new Parameter((NamedObj)this, "Pass Inputs On", (Token)new BooleanToken(true));
        this.registerConfigurableParameter(this.passInputsParameter);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.actorModeParameter) {
            this.actorMode = this.actorModeParameter.getExpression();
        } else if (attribute == this.tangoMockModeVariableNameParam) {
            this.tangoMockModeVariableName = this.tangoMockModeVariableNameParam.getExpression();
        } else if (attribute == this.passInputsParameter) {
            BooleanToken booleanToken = (BooleanToken)this.passInputsParameter.getToken();
            this.isPassInputs = booleanToken.booleanValue();
        }
        super.attributeChanged(attribute);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DataMessageComponent getTransformedMessage(List<DataMessageComponent> list) throws ProcessingException {
        try {
            DataMessageComponent dataMessageComponent2;
            String string = null;
            boolean bl = TangoConnectionFactory.isMockMode();
            logger.info("Actor \"" + this.getName() + "\": initial TANGO mock mode set to " + bl);
            boolean bl2 = bl;
            for (DataMessageComponent dataMessageComponent2 : list) {
                if (dataMessageComponent2.getScalar() == null) continue;
                for (String string2 : dataMessageComponent2.getScalar().keySet()) {
                    if (!string2.equals(this.tangoMockModeVariableName)) continue;
                    string = (String)dataMessageComponent2.getScalar().get(string2);
                    logger.info("Actor \"" + this.getName() + "\": TANGO mock mode variable " + this.tangoMockModeVariableName + " set to " + string);
                }
            }
            if (!this.actorModeParameter.getExpression().equals(ACTOR_MODE.get(0))) {
                if (this.actorModeParameter.getExpression().equals(ACTOR_MODE.get(1))) {
                    if (string == null) {
                        throw this.createDataMessageException("Cannot set tango mock mode because " + this.tangoMockModeVariableName + " is not present in the incoming port!", null);
                    }
                    if (string.equals("true")) {
                        bl2 = true;
                        logger.info("Actor \"" + this.getName() + "\": TANGO mock mode set to be true according to " + this.tangoMockModeVariableName);
                    } else {
                        if (!string.equals("false")) throw this.createDataMessageException("Cannot set tango mock mode because " + this.tangoMockModeVariableName + " is set to " + string + ", it should be set to either true or false!", null);
                        bl2 = false;
                        logger.info("Actor \"" + this.getName() + "\": TANGO mock mode set to be false according to " + this.tangoMockModeVariableName);
                    }
                } else if (this.actorModeParameter.getExpression().equals(ACTOR_MODE.get(2))) {
                    bl2 = true;
                    logger.info("Actor \"" + this.getName() + "\": TANGO mock mode forced to be true");
                } else if (this.actorModeParameter.getExpression().equals(ACTOR_MODE.get(3))) {
                    bl2 = false;
                    logger.info("Actor \"" + this.getName() + "\": TANGO mock mode forced to be false");
                }
            }
            if (bl != bl2) {
                logger.info("Actor \"" + this.getName() + "\": TANGO mock mode changed to be " + bl2);
                TangoConnectionFactory.setMockMode((boolean)bl2);
            }
            dataMessageComponent2 = new DataMessageComponent();
            dataMessageComponent2.setMeta(MessageUtils.getMeta(list));
            if (this.isPassInputs) {
                Map map = MessageUtils.getScalar(list);
                dataMessageComponent2.addScalar(map);
            }
            dataMessageComponent2.putScalar(this.tangoMockModeVariableName, "" + bl2);
            return dataMessageComponent2;
        }
        catch (Exception exception) {
            throw this.createDataMessageException("Cannot set tango mock mode!", exception);
        }
    }

    protected String getOperationName() {
        return "Get/Set TANGO mock mode";
    }

    protected String getExtendedInfo() {
        return "Actor to set and get the TANGO mock mode";
    }

    public List<IVariable> getInputVariables() {
        ArrayList<IVariable> arrayList = new ArrayList<IVariable>(7);
        ArrayList<String> arrayList2 = new ArrayList<String>(7);
        List list = super.getInputVariables();
        for (IVariable iVariable : list) {
            if (arrayList2.contains(iVariable.getVariableName())) continue;
            arrayList.add(iVariable);
            arrayList2.add(iVariable.getVariableName());
        }
        return arrayList;
    }

    public List<IVariable> getOutputVariables() {
        List<IVariable> list = this.isPassInputs ? this.getInputVariables() : new ArrayList<IVariable>(2);
        return list;
    }
}

