/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.hardware;

import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.util.ptolemy.ResourceParameter;
import com.isencia.passerelle.workbench.model.actor.IPartListenerActor;
import com.isencia.passerelle.workbench.model.actor.IResourceActor;
import com.isencia.passerelle.workbench.model.actor.ResourceObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dawb.common.util.SubstituteUtils;
import org.dawb.common.util.io.IFileUtils;
import org.dawb.passerelle.actors.hardware.command.CommandBean;
import org.dawb.passerelle.actors.hardware.command.CommandContainer;
import org.dawb.passerelle.actors.hardware.command.CommandParameter;
import org.dawb.passerelle.common.actors.AbstractDataMessageTransformer;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.DataMessageException;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.MessageUtils;
import org.dawb.passerelle.common.parameter.ParameterUtils;
import org.dawb.passerelle.editors.SubstitutionEditor;
import org.dawb.passerelle.editors.SubstitutionParticipant;
import org.dawb.tango.extensions.TangoUtils;
import org.dawb.tango.extensions.factory.TangoConnection;
import org.dawb.tango.extensions.factory.TangoConnectionEvent;
import org.dawb.tango.extensions.factory.TangoConnectionFactory;
import org.dawb.tango.extensions.factory.TangoConnectionListener;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gmf.runtime.common.core.util.StringUtil;
import org.eclipse.ui.IWorkbenchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;

public class TangoCommandTransformer
extends AbstractDataMessageTransformer
implements IResourceActor,
SubstitutionParticipant,
IPartListenerActor {
    private static final Logger logger = LoggerFactory.getLogger(TangoCommandTransformer.class);
    private static final long serialVersionUID = -5335673681296652024L;
    private CommandParameter cmdParam = new CommandParameter((NamedObj)this, "Commands");
    private ResourceParameter specFileParam;

    public TangoCommandTransformer(CompositeEntity compositeEntity, String string) throws Exception {
        super(compositeEntity, string);
        this.registerConfigurableParameter((Parameter)this.cmdParam);
        this.specFileParam = new ResourceParameter((NamedObj)this, "Spec Macro", "Spec Macro", new String[]{"*.mac", "*.txt"});
        this.registerConfigurableParameter((Parameter)this.specFileParam);
        this.memoryManagementParam.setVisibility(Settable.NONE);
        this.dataSetNaming.setVisibility(Settable.NONE);
    }

    protected int getMinimumCacheSize() {
        return 0;
    }

    protected DataMessageComponent getTransformedMessage(List<DataMessageComponent> list) throws ProcessingException {
        try {
            CommandContainer commandContainer = (CommandContainer)this.cmdParam.getBeanFromValue(CommandContainer.class);
            DataMessageComponent dataMessageComponent = MessageUtils.mergeAll(list);
            if (commandContainer == null) {
                dataMessageComponent.putScalar("error_messsage", "No motors configured, '" + this.getName() + "' did nothing.");
                return dataMessageComponent;
            }
            this.runMacro(this.getResource(false), dataMessageComponent);
            Map<String, String> map = this.runCommands(commandContainer, dataMessageComponent);
            if (map != null) {
                dataMessageComponent.addScalar(map);
            }
            return dataMessageComponent;
        }
        catch (Exception exception) {
            throw this.createDataMessageException("Cannot run command!", exception);
        }
    }

    private boolean runMacro(IResource iResource, DataMessageComponent dataMessageComponent) throws CoreException, Exception {
        String string;
        if (!iResource.exists()) {
            return false;
        }
        if (!(iResource instanceof IFile)) {
            return false;
        }
        IFile iFile = (IFile)iResource;
        String string2 = SubstituteUtils.substitute((InputStream)iFile.getContents(), (Map)dataMessageComponent.getScalar());
        if (string2 == null || "".equals(string2.trim())) {
            return false;
        }
        String[] stringArray = string2.split("\n");
        if (stringArray == null || stringArray.length < 1) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            string = stringArray[n].trim();
            if (!string.startsWith("#")) {
                arrayList.add(string);
            }
            ++n;
        }
        if (arrayList.isEmpty()) {
            return false;
        }
        logger.info("Running macro '" + iResource.getLocation().toOSString() + "'");
        String string3 = TangoUtils.getSpecCommandAddress();
        string = null;
        try {
            string = TangoConnectionFactory.openCommandConnection((String)string3);
            String string4 = System.getProperty("org.dawb.passerelle.actors.hardware.command.sleep.interval");
            for (String string5 : arrayList) {
                logger.info(string5);
                string.executeCommand("ExecuteCmd", string5, false);
                if (string4 == null) continue;
                Thread.sleep(Long.parseLong(string4));
            }
            return true;
        }
        catch (Exception exception) {
            throw this.createDataMessageException("Cannot connect to " + string3, exception);
        }
        finally {
            if (string != null) {
                try {
                    string.dispose();
                }
                catch (Exception exception) {
                    throw this.createDataMessageException("Cannot dispose tango connection " + string.getUri(), exception);
                }
            }
        }
    }

    private Map<String, String> runCommands(CommandContainer commandContainer, DataMessageComponent dataMessageComponent) throws DataMessageException {
        HashMap<String, StringBuilder> hashMap = new HashMap<String, StringBuilder>(commandContainer.size());
        for (CommandBean object2 : commandContainer.getBeans()) {
            String string = SubstituteUtils.substitute((String)object2.getCommand(), (Map)dataMessageComponent.getScalar());
            String string2 = object2.getAttributeName() != null && !"".equals(object2.getAttributeName()) ? object2.getAttributeName() : "Output";
            String string3 = TangoUtils.getSpecCommandAddress();
            TangoConnection tangoConnection = null;
            TangoConnectionListener tangoConnectionListener = null;
            try {
                try {
                    tangoConnection = TangoConnectionFactory.openMonitoredCommandConnection((String)string3, (String)string2);
                    String exception = "ExecuteCmd";
                    if (object2.getCommandAttributeName() != null && !"".equals(object2.getCommandAttributeName())) {
                        exception = object2.getCommandAttributeName();
                    }
                    tangoConnectionListener = this.createTangoConnectionListener(string, object2, hashMap);
                    tangoConnection.addTangoConnectionListener(tangoConnectionListener);
                    tangoConnection.executeCommand(exception, string, false);
                }
                catch (Exception exception) {
                    if (this.isMockMode()) {
                        throw this.createDataMessageException(exception.getMessage(), exception);
                    }
                    throw this.createDataMessageException("Cannot connect to " + string3, exception);
                }
            }
            catch (Throwable throwable) {
                if (tangoConnection != null) {
                    tangoConnection.removeTangoConnectionListener(tangoConnectionListener);
                    try {
                        tangoConnection.dispose();
                    }
                    catch (Exception exception) {
                        throw this.createDataMessageException("Cannot dispose tango connection " + tangoConnection.getUri(), exception);
                    }
                }
                throw throwable;
            }
            if (tangoConnection == null) continue;
            tangoConnection.removeTangoConnectionListener(tangoConnectionListener);
            try {
                tangoConnection.dispose();
            }
            catch (Exception exception) {
                throw this.createDataMessageException("Cannot dispose tango connection " + tangoConnection.getUri(), exception);
            }
        }
        HashMap<String, String> hashMap2 = new HashMap<String, String>(commandContainer.size());
        for (Object object3 : hashMap.keySet()) {
            hashMap2.put((String)object3, ((StringBuilder)hashMap.get(object3)).toString());
        }
        return hashMap2;
    }

    private TangoConnectionListener createTangoConnectionListener(final String string, final CommandBean commandBean, final Map<String, StringBuilder> map) {
        return new TangoConnectionListener(){

            public void tangoEventPerformed(TangoConnectionEvent tangoConnectionEvent) {
                StringBuilder stringBuilder = (StringBuilder)map.get(commandBean.getVariableName());
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                    map.put(commandBean.getVariableName(), stringBuilder);
                }
                if (tangoConnectionEvent.getErrorMessage() != null) {
                    stringBuilder.append("\n" + tangoConnectionEvent.getErrorMessage());
                }
                try {
                    String string2 = tangoConnectionEvent.getValue().extractString().trim();
                    logger.debug(string2);
                    stringBuilder.append("\n" + string2);
                }
                catch (Exception exception) {
                    stringBuilder.append("\n" + TangoUtils.getMessageFromException((String)string, (Exception)exception));
                }
            }
        };
    }

    protected String getOperationName() {
        return "Get/Set Motor";
    }

    protected String getExtendedInfo() {
        return "Actor to set and get motor";
    }

    public List<IVariable> getOutputVariables() {
        try {
            List list = super.getOutputVariables();
            return list;
        }
        catch (Exception exception) {
            logger.error("Cannot read variables", (Throwable)exception);
            return null;
        }
    }

    public String getDefaultSubstitution() {
        return "# Please insert spec macro contents here, and use the view on the left to insert variables.\n";
    }

    public void setMomlResource(IResource iResource) {
    }

    public int getResourceCount() {
        return 1;
    }

    protected IResource getResource(boolean bl) throws Exception {
        Object object;
        IProject iProject;
        String string = this.specFileParam.getExpression();
        IFile iFile = null;
        if (string == null || "".equals(string)) {
            iProject = this.getProject();
            object = iProject.getFolder("src");
            iFile = IFileUtils.getUniqueIFile((IContainer)object, (String)"macro", (String)"mac");
            string = iFile.getFullPath().toOSString();
            string = StringUtil.replace((String)string, (String)("/" + iFile.getProject().getName() + "/"), (String)"/${project_name}/", (boolean)true);
            if (bl) {
                this.specFileParam.setExpression(string);
            }
        }
        if (ResourcesPlugin.getWorkspace().getRoot().findMember(string) != null && ResourcesPlugin.getWorkspace().getRoot().findMember(string).exists()) {
            iFile = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(string);
        }
        if (iFile == null) {
            Object object2;
            string = ParameterUtils.substitute((String)string, (NamedObj)this);
            iProject = this.getProject();
            IContainer iContainer = (IContainer)iProject.findMember((String)(object = IFileUtils.getPathWithoutProject((String)string.substring(0, string.lastIndexOf(47)))));
            if (iContainer == null) {
                try {
                    object2 = iProject.getFolder((String)object);
                    iContainer = object2;
                }
                catch (Exception exception) {
                    logger.error("Cannot create folder " + (String)object, (Throwable)exception);
                }
            }
            if ((iFile = (IFile)iContainer.findMember((String)(object2 = string.substring(string.lastIndexOf(47))))) == null && iContainer instanceof IProject) {
                iFile = ((IProject)iContainer).getFile((String)object2);
            }
            if (iFile == null && iContainer instanceof IFolder) {
                iFile = ((IFolder)iContainer).getFile((String)object2);
            }
        }
        return iFile;
    }

    public ResourceObject getResource(int n) throws Exception {
        if (n == 0) {
            ResourceObject resourceObject = new ResourceObject();
            resourceObject.setResource((Object)this.getResource(false));
            resourceObject.setResourceTypeName("Spec Macro");
            resourceObject.setEditorId("org.dawb.passerelle.editors.substitutionEditor");
            return resourceObject;
        }
        return null;
    }

    public void partPreopen(ResourceObject resourceObject) {
        try {
            IFile iFile = (IFile)this.getResource(true);
            if (!iFile.exists()) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getDefaultSubstitution().getBytes("UTF-8"));
                if (!iFile.getParent().exists() && iFile.getParent() instanceof IFolder) {
                    IFolder iFolder = (IFolder)iFile.getParent();
                    iFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                iFile.create((InputStream)byteArrayInputStream, true, (IProgressMonitor)new NullProgressMonitor());
                iFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception exception) {
            logger.error("Cannot create file " + resourceObject.getResourceTypeName(), (Throwable)exception);
        }
    }

    public void partOpened(IWorkbenchPart iWorkbenchPart, ResourceObject resourceObject) {
        SubstitutionEditor substitutionEditor = (SubstitutionEditor)iWorkbenchPart;
        substitutionEditor.setSubstitutionParticipant((SubstitutionParticipant)this);
        iWorkbenchPart.setFocus();
    }
}

