/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.passerelle.actors.hardware;

import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.TerminationException;
import com.isencia.passerelle.message.ManagedMessage;
import fr.esrf.TangoApi.ConnectionFailed;
import fr.esrf.TangoApi.DeviceData;
import java.util.List;
import org.dawb.common.ui.plot.PlotType;
import org.dawb.passerelle.common.actors.AbstractDataMessageSource;
import org.dawb.passerelle.common.message.DataMessageComponent;
import org.dawb.passerelle.common.message.IVariable;
import org.dawb.passerelle.common.message.MessageUtils;
import org.dawb.passerelle.common.message.Variable;
import org.dawb.tango.extensions.TangoUtils;
import org.dawb.tango.extensions.editors.SharedMemoryUtils;
import org.dawb.tango.extensions.factory.TangoConnection;
import org.dawb.tango.extensions.factory.TangoConnectionFactory;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.NamedObj;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;

public class SharedMemorySource
extends AbstractDataMessageSource {
    private static final Logger logger = LoggerFactory.getLogger(SharedMemorySource.class);
    private static final String[] DATA_CHOICES = new String[]{"1D List", "2D"};
    private static final long serialVersionUID = -5335673681296652024L;
    private StringParameter specTangoUri;
    private StringParameter variable;
    private StringParameter dataType;
    private StringParameter outputName;
    private StringParameter specName;
    private Parameter sourceFreq;
    private Parameter inactiveFreq;
    private Parameter chunkSize;
    private TangoConnection connection = null;
    private ManagedMessage triggerMsg;

    public SharedMemorySource(CompositeEntity compositeEntity, String string) throws Exception {
        super(compositeEntity, string);
        ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.dawb.tango.extensions");
        this.specTangoUri = new StringParameter((NamedObj)this, "Spec Tango URI");
        this.registerExpertParameter((Parameter)this.specTangoUri);
        this.specTangoUri.setExpression(scopedPreferenceStore.getString("org.dawb.tango.extensions.shared.mem.uri"));
        this.variable = new StringParameter((NamedObj)this, "Spec Variable"){
            private static final long serialVersionUID = -1902977727142062610L;

            public String[] getChoices() {
                try {
                    return SharedMemorySource.this.getMemoryChoices();
                }
                catch (Exception exception) {
                    logger.error("Cannot get memory names", (Throwable)exception);
                    return new String[]{"Error - shared memory choices invalid!"};
                }
            }
        };
        this.registerConfigurableParameter((Parameter)this.variable);
        this.outputName = new StringParameter((NamedObj)this, "Output Name");
        this.registerConfigurableParameter((Parameter)this.outputName);
        this.outputName.setExpression("x");
        this.sourceFreq = new Parameter((NamedObj)this, "Source Frequency", (Token)new IntToken(scopedPreferenceStore.getInt("org.dawb.tango.extensions.shared.mem.monitoring.frequency")));
        this.registerConfigurableParameter(this.sourceFreq);
        this.inactiveFreq = new Parameter((NamedObj)this, "Inactive After", (Token)new IntToken(-1));
        this.registerExpertParameter(this.inactiveFreq);
        this.chunkSize = new Parameter((NamedObj)this, "Chunk Size", (Token)new IntToken(scopedPreferenceStore.getInt("org.dawb.tango.extensions.shared.mem.chunk.size")));
        this.registerExpertParameter(this.chunkSize);
        this.specName = new StringParameter((NamedObj)this, "Spec Name");
        this.registerConfigurableParameter((Parameter)this.specName);
        ScopedPreferenceStore scopedPreferenceStore2 = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.dawb.common.ui");
        this.specName.setExpression(scopedPreferenceStore2.getString("org.dawb.spec.session.name"));
        this.dataType = new StringParameter((NamedObj)this, "Data Type"){
            private static final long serialVersionUID = -751428263040559946L;

            public String[] getChoices() {
                return DATA_CHOICES;
            }
        };
        this.dataType.setExpression(DATA_CHOICES[0]);
        this.registerConfigurableParameter((Parameter)this.dataType);
    }

    protected void acceptTriggerMessage(ManagedMessage managedMessage) {
        this.triggerMsg = managedMessage;
    }

    protected ManagedMessage getDataMessage() throws ProcessingException {
        String string;
        block10: {
            boolean bl;
            if (this.connection == null) {
                this.connection = this.createConnection();
            }
            if (bl = this.isData(string = this.variable.getExpression())) break block10;
            return null;
        }
        try {
            AbstractDataset abstractDataset;
            PlotType plotType = DATA_CHOICES[0].equals(this.dataType.getExpression()) ? PlotType.PT1D : PlotType.IMAGE;
            int n = ((IntToken)this.chunkSize.getToken()).intValue();
            List list = SharedMemoryUtils.getSharedMemoryValue((TangoConnection)this.connection, (String)string, (int)n, (PlotType)plotType);
            DataMessageComponent dataMessageComponent = new DataMessageComponent();
            String string2 = this.outputName.getExpression();
            if (plotType == PlotType.IMAGE) {
                abstractDataset = (AbstractDataset)list.get(0);
                abstractDataset.setName(string2);
                dataMessageComponent.addList(string2, (AbstractDataset)list.get(0));
            } else {
                int n2 = 1;
                for (AbstractDataset abstractDataset2 : list) {
                    abstractDataset2.setName(String.valueOf(string2) + n2);
                    dataMessageComponent.addList(String.valueOf(string2) + n2, abstractDataset2);
                    ++n2;
                }
            }
            if (this.triggerMsg != null) {
                try {
                    abstractDataset = MessageUtils.coerceMessage((ManagedMessage)this.triggerMsg);
                    dataMessageComponent.addScalar(abstractDataset.getScalar());
                }
                catch (Exception exception) {
                    logger.info("Trigger for " + this.getName() + " is not DataMessageComponent, no data added.");
                }
            }
            return MessageUtils.getDataMessage((DataMessageComponent)dataMessageComponent);
        }
        catch (Exception exception) {
            throw this.createDataMessageException("Cannot extract shared memory", exception);
        }
    }

    private boolean isData(String string) throws Exception {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(new String[]{this.specName.getExpression(), string});
        DeviceData deviceData2 = this.connection.executeCommand("IsUpdated", deviceData, false);
        int n = ((IntToken)this.inactiveFreq.getToken()).intValue();
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        int n2 = 0;
        while (deviceData2.extractLong() != 1 && n2 < n && !this.isFinishRequested()) {
            try {
                Thread.sleep(100L);
                deviceData2 = this.connection.executeCommand("IsUpdated", deviceData, false);
            }
            finally {
                if (n != Integer.MAX_VALUE) {
                    n2 += 100;
                }
            }
        }
        if (deviceData2.extractLong() == 1) {
            return true;
        }
        logger.warn("The actor '" + this.getDisplayName() + "' has timed out after " + n + " ms.");
        return false;
    }

    protected boolean doPostFire() throws ProcessingException {
        try {
            int n = ((IntToken)this.sourceFreq.getToken()).intValue();
            if (!this.isFinishRequested()) {
                Thread.sleep(n);
            }
        }
        catch (Exception exception) {
            throw new ProcessingException("Cannot wait for source frequency time after last data!", (Object)this, (Throwable)exception);
        }
        return super.doPostFire();
    }

    protected void doWrapUp() throws TerminationException {
        try {
            try {
                if (this.connection != null) {
                    this.connection.dispose();
                }
            }
            catch (Exception exception) {
                throw new TerminationException("Cannot close tango connection", (Object)this, (Throwable)exception);
            }
        }
        finally {
            super.doWrapUp();
        }
    }

    protected String getExtendedInfo() {
        return "Actor to monitor shared memory.";
    }

    private String[] getMemoryChoices() throws Exception {
        TangoConnection tangoConnection = null;
        try {
            tangoConnection = this.createConnection();
            List list = SharedMemoryUtils.getSharedNames((TangoConnection)tangoConnection);
            String[] stringArray = list.toArray(new String[list.size()]);
            return stringArray;
        }
        catch (Exception exception) {
            logger.error("Cannot read shared memory variables!", (Throwable)exception);
            String[] stringArray = new String[]{exception.getMessage()};
            return stringArray;
        }
        finally {
            if (tangoConnection != null) {
                tangoConnection.dispose();
            }
        }
    }

    private TangoConnection createConnection() throws Exception {
        String string = TangoUtils.getHardwareAddress((String)this.specTangoUri.getExpression());
        try {
            return TangoConnectionFactory.openCommandConnection((String)string);
        }
        catch (ConnectionFailed connectionFailed) {
            logger.error("Cannot run '" + this.getDisplayName() + "' because the tango connection cannot be made!\n" + connectionFailed.errors[0].desc);
            throw connectionFailed;
        }
    }

    public List<IVariable> getOutputVariables() {
        try {
            PlotType plotType;
            List list = super.getOutputVariables();
            PlotType plotType2 = plotType = DATA_CHOICES[0].equals(this.dataType.getExpression()) ? PlotType.PT1D : PlotType.IMAGE;
            if (plotType == PlotType.IMAGE) {
                list.add(new Variable(this.outputName.getExpression(), IVariable.VARIABLE_TYPE.ARRAY, null, AbstractDataset.class));
            } else {
                int n = ((IntToken)this.chunkSize.getToken()).intValue();
                int n2 = 1;
                while (n2 <= n) {
                    list.add(new Variable(String.valueOf(this.outputName.getExpression()) + n2, IVariable.VARIABLE_TYPE.ARRAY, null, AbstractDataset.class));
                    ++n2;
                }
            }
            return list;
        }
        catch (Exception exception) {
            logger.error("Cannot read variables", (Throwable)exception);
            return null;
        }
    }

    protected boolean mustWaitForTrigger() {
        if (this.triggerMsg != null) {
            return false;
        }
        return this.trigger.getWidth() > 0;
    }
}

