/*
 * Decompiled with CFR 0.152.
 */
package gda.data.nexus.tree;

import gda.data.nexus.extractor.NexusGroupData;
import gda.data.nexus.tree.INexusTree;
import org.nexusformat.NexusException;
import org.nexusformat.NexusFile;

public class NexusTreeWriter {
    public static void writeHere(NexusFile file, INexusTree tree) throws NexusException {
        String name = tree.getName();
        String nxClass = tree.getNxClass();
        if (nxClass.equals("Attr")) {
            NexusGroupData data = tree.getData();
            if (data != null && data.getBuffer() != null) {
                file.putattr(name, (Object)data.getBuffer(), data.type);
            }
            return;
        }
        if (!name.isEmpty() && !nxClass.isEmpty()) {
            if (!file.groupdir().containsKey(name) || !file.groupdir().get(name).equals(nxClass)) {
                file.makegroup(name, nxClass);
            }
            file.opengroup(name, nxClass);
        }
        try {
            for (INexusTree branch : tree) {
                NexusTreeWriter.writeHere(file, branch);
            }
        }
        finally {
            if (!name.isEmpty() && !nxClass.isEmpty()) {
                file.closegroup();
            }
        }
    }
}

