/*
 * Decompiled with CFR 0.152.
 */
package gda.data.nexus.tree;

import java.io.StringReader;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import org.xml.sax.InputSource;
import uk.ac.gda.util.beans.xml.XMLHelpers;

public final class NexusTreeNodeSelection {
    static int NAME_ONLY = 0;
    static int NAME_AND_DIMS = 1;
    static int NAME_DIMS_AND_DATA = 2;
    static int SKIP_THIS_ITEM = 0;
    static int GET_THIS_ITEM = 1;
    static int GET_THIS_AND_BELOW = 2;
    public static final NexusTreeNodeSelection SKIP = new NexusTreeNodeSelection();
    public static final NexusTreeNodeSelection GET_ALL;
    private static final URL mappingURL;
    private static final URL schemaUrl;
    private List<NexusTreeNodeSelection> childNodes = new Vector<NexusTreeNodeSelection>();
    private int dataType = NAME_ONLY;
    private String nxName_UseSetNxName = "";
    private String nxClass_UseSetNxClass = "";
    private int wanted = GET_THIS_ITEM;
    private Pattern nxNamePattern = Pattern.compile(this.nxName_UseSetNxName);
    private Pattern nxClassPattern = Pattern.compile(this.nxClass_UseSetNxClass);

    static {
        NexusTreeNodeSelection.SKIP.wanted = SKIP_THIS_ITEM;
        NexusTreeNodeSelection.SKIP.dataType = NAME_ONLY;
        GET_ALL = new NexusTreeNodeSelection();
        NexusTreeNodeSelection.GET_ALL.wanted = GET_THIS_AND_BELOW;
        NexusTreeNodeSelection.GET_ALL.dataType = NAME_DIMS_AND_DATA;
        mappingURL = NexusTreeNodeSelection.class.getResource("NexusTreeMapping.xml");
        schemaUrl = NexusTreeNodeSelection.class.getResource("NexusTree.xsd");
    }

    public static NexusTreeNodeSelection createFromXML(String filename) throws Exception {
        NexusTreeNodeSelection tree = (NexusTreeNodeSelection)XMLHelpers.createFromXML((URL)mappingURL, NexusTreeNodeSelection.class, (URL)schemaUrl, (String)filename);
        tree.setName("");
        tree.setNxClass("");
        return tree;
    }

    public static NexusTreeNodeSelection createFromXML(InputSource inputSource) throws Exception {
        NexusTreeNodeSelection tree = (NexusTreeNodeSelection)XMLHelpers.createFromXML((URL)mappingURL, NexusTreeNodeSelection.class, (URL)schemaUrl, (InputSource)inputSource);
        tree.setName("");
        tree.setNxClass("");
        return tree;
    }

    public static NexusTreeNodeSelection createTreeForAllNXEntries() {
        NexusTreeNodeSelection top = new NexusTreeNodeSelection();
        top.setName("");
        top.setNxClass("");
        top.wanted = GET_THIS_ITEM;
        NexusTreeNodeSelection nxEntries = new NexusTreeNodeSelection();
        nxEntries.setName("");
        nxEntries.setNxClass("NXentry");
        nxEntries.wanted = GET_THIS_AND_BELOW;
        nxEntries.dataType = NAME_DIMS_AND_DATA;
        top.addChildNode(nxEntries);
        return top;
    }

    public static NexusTreeNodeSelection createTreeForAllNXData() {
        return NexusTreeNodeSelection.createTreeForDataSetNames(null, true);
    }

    public static NexusTreeNodeSelection createTreeForDataSetNames(List<String> dataSetNames, boolean withData) {
        NexusTreeNodeSelection top = new NexusTreeNodeSelection();
        top.setName("");
        top.setNxClass("");
        top.wanted = GET_THIS_ITEM;
        NexusTreeNodeSelection nxEntry = new NexusTreeNodeSelection();
        nxEntry.setName("");
        nxEntry.setNxClass("NXentry");
        int n = nxEntry.dataType = withData ? NAME_DIMS_AND_DATA : NAME_AND_DIMS;
        if (dataSetNames != null) {
            nxEntry.wanted = GET_THIS_ITEM;
            for (String s : dataSetNames) {
                String[] parts = s.split("[.]", 2);
                String nxDataNodeName = parts.length == 1 ? "" : parts[0];
                String nxChildNodeName = parts.length == 1 ? parts[0] : parts[1];
                NexusTreeNodeSelection nxDataNode = null;
                for (NexusTreeNodeSelection sel : nxEntry.getChildNodes()) {
                    if (!sel.MatchesName(nxDataNodeName)) continue;
                    nxDataNode = sel;
                    break;
                }
                if (nxDataNode == null) {
                    nxDataNode = new NexusTreeNodeSelection();
                    nxDataNode.setName(nxDataNodeName);
                    nxDataNode.setNxClass("NXdata");
                    nxDataNode.dataType = withData ? NAME_DIMS_AND_DATA : NAME_AND_DIMS;
                    nxDataNode.wanted = GET_THIS_ITEM;
                    nxEntry.addChildNode(nxDataNode);
                }
                NexusTreeNodeSelection childNode = new NexusTreeNodeSelection();
                childNode.setName(nxChildNodeName);
                childNode.setNxClass("SDS");
                childNode.dataType = withData ? NAME_DIMS_AND_DATA : NAME_AND_DIMS;
                childNode.wanted = GET_THIS_AND_BELOW;
                nxDataNode.addChildNode(childNode);
            }
        } else {
            nxEntry.wanted = GET_THIS_AND_BELOW;
        }
        top.addChildNode(nxEntry);
        return top;
    }

    public static NexusTreeNodeSelection createTreeForAllData() {
        NexusTreeNodeSelection top = new NexusTreeNodeSelection();
        top.setName("");
        top.setNxClass("");
        top.wanted = GET_THIS_AND_BELOW;
        NexusTreeNodeSelection entries = new NexusTreeNodeSelection();
        entries.setName("");
        entries.setNxClass("");
        entries.wanted = GET_THIS_AND_BELOW;
        entries.dataType = NAME_DIMS_AND_DATA;
        top.addChildNode(entries);
        return top;
    }

    public static NexusTreeNodeSelection createTreeForAllMetaData() throws Exception {
        String xml = "<?xml version='1.0' encoding='UTF-8'?><nexusTreeNodeSelection><nexusTreeNodeSelection><nxClass>NXentry</nxClass><wanted>2</wanted><dataType>2</dataType><nexusTreeNodeSelection><nxClass>NXdata</nxClass><wanted>0</wanted><dataType>2</dataType></nexusTreeNodeSelection><nexusTreeNodeSelection><nxClass>NXinstrument</nxClass><wanted>2</wanted><dataType>2</dataType><nexusTreeNodeSelection><nxClass>NXdetector</nxClass><wanted>2</wanted><dataType>2</dataType><nexusTreeNodeSelection><nxClass>SDS</nxClass><name>data</name><wanted>2</wanted><dataType>1</dataType></nexusTreeNodeSelection></nexusTreeNodeSelection></nexusTreeNodeSelection></nexusTreeNodeSelection></nexusTreeNodeSelection>";
        return NexusTreeNodeSelection.createFromXML(new InputSource(new StringReader(xml)));
    }

    public NexusTreeNodeSelection() {
    }

    public NexusTreeNodeSelection(String name, String nxClass, int wanted, int dataType) {
        this.wanted = wanted;
        this.dataType = dataType;
        this.setName(name);
        this.setNxClass(nxClass);
        this.nxNamePattern = Pattern.compile(name);
        this.nxClassPattern = Pattern.compile(nxClass);
    }

    public void addChildNode(NexusTreeNodeSelection childNode) {
        this.childNodes.add(childNode);
    }

    public List<NexusTreeNodeSelection> getChildNodes() {
        return this.childNodes;
    }

    public int getDataType() {
        return this.dataType;
    }

    public String getName() {
        return this.nxName_UseSetNxName;
    }

    public String getNxClass() {
        return this.nxClass_UseSetNxClass;
    }

    public int getWanted() {
        return this.wanted;
    }

    boolean isGetData() {
        return this.dataType == NAME_DIMS_AND_DATA;
    }

    boolean isGetThisAndBelow() {
        return this.wanted == GET_THIS_AND_BELOW;
    }

    boolean isSkip() {
        return this.wanted == SKIP_THIS_ITEM;
    }

    boolean MatchesName(String name) {
        return this.nxName_UseSetNxName.isEmpty() || this.nxNamePattern.matcher(name).matches();
    }

    boolean MatchesNXClass(String NXclass) {
        return this.nxClass_UseSetNxClass.isEmpty() || this.nxClassPattern.matcher(NXclass).matches();
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public void setName(String name) {
        this.nxName_UseSetNxName = name;
        this.nxNamePattern = Pattern.compile(this.nxName_UseSetNxName);
    }

    public void setNxClass(String nxClassName) {
        this.nxClass_UseSetNxClass = nxClassName;
        this.nxClassPattern = Pattern.compile(this.nxClass_UseSetNxClass);
    }

    public void setWanted(int wanted) {
        this.wanted = wanted;
    }
}

