/*
 * Decompiled with CFR 0.152.
 */
package gda.data.nexus.tree;

import gda.data.nexus.extractor.NexusGroupData;
import gda.data.nexus.tree.INexusTree;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NexusTreeNode
implements INexusTree,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient Logger logger = LoggerFactory.getLogger(NexusTreeNode.class);
    public final NexusGroupData groupData;
    private List<INexusTree> childNodes = new Vector<INexusTree>();
    private static Comparator<INexusTree> nameComparator = new Comparator<INexusTree>(){

        @Override
        public int compare(INexusTree o1, INexusTree o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    public final String name;
    public final String nxClass;
    private INexusTree parentNode;
    boolean isPointDependent = false;

    public static Comparator<INexusTree> getNameComparator() {
        return nameComparator;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNxClass() {
        return this.nxClass;
    }

    @Override
    public void setParentNode(INexusTree parentNode) {
        this.parentNode = parentNode;
    }

    @Override
    public INexusTree getParentNode() {
        return this.parentNode;
    }

    public NexusTreeNode(String name, String nxClass, INexusTree parentNode, NexusGroupData groupData) {
        this.name = name;
        this.nxClass = nxClass;
        this.parentNode = parentNode;
        this.groupData = groupData;
    }

    public NexusTreeNode(String name, String nxClass, INexusTree parentNode) {
        this(name, nxClass, parentNode, null);
    }

    public String toString() {
        return this.toText("", ":", "/", "|", false);
    }

    protected String dataToTxt(boolean newlineAfterEach, boolean dataAsString, boolean wrap) {
        StringBuffer msg = new StringBuffer();
        if (this.groupData.getBuffer() != null) {
            if (this.groupData.type == 4 && this.groupData.getBuffer() instanceof byte[]) {
                if (wrap) {
                    msg.append("<value>");
                }
                String s = new String((byte[])this.groupData.getBuffer());
                msg.append(s);
                if (wrap) {
                    msg.append("</value>");
                }
                if (newlineAfterEach) {
                    msg.append("\n");
                }
            } else if (dataAsString) {
                if (wrap) {
                    msg.append("<value>");
                }
                if (this.groupData.getBuffer() instanceof double[]) {
                    double[] ddata;
                    double[] dArray = ddata = (double[])this.groupData.getBuffer();
                    int n = ddata.length;
                    int n2 = 0;
                    while (n2 < n) {
                        double d = dArray[n2];
                        msg.append(String.valueOf(Double.toString(d)) + ",");
                        ++n2;
                    }
                } else if (this.groupData.getBuffer() instanceof int[]) {
                    int[] ddata;
                    int[] nArray = ddata = (int[])this.groupData.getBuffer();
                    int n = ddata.length;
                    int n3 = 0;
                    while (n3 < n) {
                        int d = nArray[n3];
                        msg.append(String.valueOf(Integer.toString(d)) + ",");
                        ++n3;
                    }
                } else if (this.groupData.getBuffer() instanceof byte[]) {
                    byte[] ddata;
                    byte[] byArray = ddata = (byte[])this.groupData.getBuffer();
                    int n = ddata.length;
                    int n4 = 0;
                    while (n4 < n) {
                        byte d = byArray[n4];
                        msg.append(String.valueOf(Byte.toString(d)) + ",");
                        ++n4;
                    }
                } else if (this.groupData.getBuffer() instanceof float[]) {
                    float[] ddata;
                    float[] fArray = ddata = (float[])this.groupData.getBuffer();
                    int n = ddata.length;
                    int n5 = 0;
                    while (n5 < n) {
                        float d = fArray[n5];
                        msg.append(String.valueOf(Float.toString(d)) + ",");
                        ++n5;
                    }
                } else if (this.groupData.getBuffer() instanceof long[]) {
                    long[] ddata;
                    long[] lArray = ddata = (long[])this.groupData.getBuffer();
                    int n = ddata.length;
                    int n6 = 0;
                    while (n6 < n) {
                        long d = lArray[n6];
                        msg.append(String.valueOf(Long.toString(d)) + ",");
                        ++n6;
                    }
                } else {
                    msg.append(this.groupData.getBuffer().toString());
                }
                if (wrap) {
                    msg.append("</value>");
                }
                if (newlineAfterEach) {
                    msg.append("\n");
                }
            } else {
                msg.append("<values>");
                if (newlineAfterEach) {
                    msg.append("\n");
                }
                if (this.groupData.getBuffer() instanceof double[]) {
                    double[] ddata;
                    double[] dArray = ddata = (double[])this.groupData.getBuffer();
                    int n = ddata.length;
                    int n7 = 0;
                    while (n7 < n) {
                        double d = dArray[n7];
                        msg.append("<value>");
                        msg.append(Double.toString(d));
                        msg.append("</value>");
                        if (newlineAfterEach) {
                            msg.append("\n");
                        }
                        ++n7;
                    }
                } else if (this.groupData.getBuffer() instanceof int[]) {
                    int[] ddata;
                    int[] nArray = ddata = (int[])this.groupData.getBuffer();
                    int n = ddata.length;
                    int n8 = 0;
                    while (n8 < n) {
                        int d = nArray[n8];
                        msg.append("<value>");
                        msg.append(Integer.toString(d));
                        msg.append("</value>");
                        if (newlineAfterEach) {
                            msg.append("\n");
                        }
                        ++n8;
                    }
                } else if (this.groupData.getBuffer() instanceof byte[]) {
                    byte[] ddata;
                    byte[] byArray = ddata = (byte[])this.groupData.getBuffer();
                    int n = ddata.length;
                    int n9 = 0;
                    while (n9 < n) {
                        byte d = byArray[n9];
                        msg.append("<value>");
                        msg.append(Byte.toString(d));
                        msg.append("</value>");
                        if (newlineAfterEach) {
                            msg.append("\n");
                        }
                        ++n9;
                    }
                } else if (this.groupData.getBuffer() instanceof float[]) {
                    float[] ddata;
                    float[] fArray = ddata = (float[])this.groupData.getBuffer();
                    int n = ddata.length;
                    int n10 = 0;
                    while (n10 < n) {
                        float d = fArray[n10];
                        msg.append("<value>");
                        msg.append(Float.toString(d));
                        msg.append("</value>");
                        if (newlineAfterEach) {
                            msg.append("\n");
                        }
                        ++n10;
                    }
                } else if (this.groupData.getBuffer() instanceof long[]) {
                    long[] ddata;
                    long[] lArray = ddata = (long[])this.groupData.getBuffer();
                    int n = ddata.length;
                    int n11 = 0;
                    while (n11 < n) {
                        long d = lArray[n11];
                        msg.append("<value>");
                        msg.append(Long.toString(d));
                        msg.append("</value>");
                        if (newlineAfterEach) {
                            msg.append("\n");
                        }
                        ++n11;
                    }
                } else {
                    msg.append(this.groupData.getBuffer().toString());
                }
                msg.append("</values>");
                if (newlineAfterEach) {
                    msg.append("\n");
                }
            }
        }
        return msg.toString();
    }

    @Override
    public String toXML(boolean newlineAfterEach, boolean dataAsString) {
        return String.valueOf(this.toXMLbegin(newlineAfterEach, dataAsString).toString()) + this.toXMLend(newlineAfterEach, dataAsString).toString();
    }

    @Override
    public StringBuffer toXMLbegin(boolean newlineAfterEach, boolean dataAsString) {
        StringBuffer msg = new StringBuffer("<");
        msg.append(this.nxClass.isEmpty() ? "top" : this.nxClass);
        msg.append(" @name=" + this.name);
        msg.append(">");
        if (newlineAfterEach) {
            msg.append("\n");
        }
        if (this.groupData != null) {
            msg.append("<dimensions>");
            int[] nArray = this.groupData.dimensions;
            int n = this.groupData.dimensions.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                msg.append("<dimension>" + i + "</dimension>");
                ++n2;
            }
            msg.append("</dimensions>");
            if (newlineAfterEach) {
                msg.append("\n");
            }
            msg.append("<type>");
            switch (this.groupData.type) {
                case 4: {
                    msg.append("NX_CHAR");
                    break;
                }
                case 6: {
                    msg.append("NX_FLOAT64");
                    break;
                }
                default: {
                    msg.append(this.groupData.type);
                }
            }
            msg.append("</type>");
            if (newlineAfterEach) {
                msg.append("\n");
            }
            msg.append(this.dataToTxt(newlineAfterEach, dataAsString, true));
        }
        for (INexusTree ntn : this.childNodes) {
            msg.append(ntn.toXMLbegin(newlineAfterEach, dataAsString));
            msg.append(ntn.toXMLend(newlineAfterEach, dataAsString));
        }
        return msg;
    }

    @Override
    public StringBuffer toXMLend(boolean newlineAfterEach, boolean dataAsString) {
        StringBuffer msg = new StringBuffer("</");
        msg.append(this.nxClass.isEmpty() ? "top" : this.nxClass);
        msg.append(">");
        if (newlineAfterEach) {
            msg.append("\n");
        }
        return msg;
    }

    @Override
    public NexusGroupData getData() {
        return this.groupData;
    }

    @Override
    public int getNumberOfChildNodes() {
        return this.childNodes.size();
    }

    @Override
    public void addChildNode(INexusTree e) {
        this.childNodes.add(e);
        e.setParentNode(this);
        this.sort(nameComparator);
    }

    @Override
    public void removeChildNode(INexusTree e) {
        this.childNodes.remove(e);
        e.setParentNode(null);
    }

    @Override
    public INexusTree getChildNode(int index) {
        return this.childNodes.get(index);
    }

    public int getChildCount() {
        return this.childNodes.size();
    }

    @Override
    public String toText(String prefix, String keyValueSep, String dataItemSep, String nodeSep) {
        return this.toText(prefix, keyValueSep, dataItemSep, nodeSep, true);
    }

    @Override
    public String toText(String prefix, String keyValueSep, String dataItemSep, String nodeSep, boolean includeData) {
        StringBuffer msg = new StringBuffer(String.valueOf(prefix) + nodeSep + this.nxClass + keyValueSep + this.name);
        if (this.groupData != null) {
            msg.append(String.valueOf(dataItemSep) + "dimensions");
            int[] nArray = this.groupData.dimensions;
            int n = this.groupData.dimensions.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                msg.append(String.valueOf(keyValueSep) + i);
                ++n2;
            }
            msg.append(String.valueOf(dataItemSep) + "type");
            switch (this.groupData.type) {
                case 4: {
                    msg.append(String.valueOf(keyValueSep) + "NX_CHAR");
                    break;
                }
                case 6: {
                    msg.append(String.valueOf(keyValueSep) + "NX_FLOAT64");
                    break;
                }
                default: {
                    msg.append(". type - " + this.groupData.type);
                }
            }
            if (includeData) {
                msg.append(String.valueOf(dataItemSep) + "data" + keyValueSep + this.dataToTxt(false, true, false));
            }
        }
        prefix = msg.toString();
        msg.append("\n");
        for (INexusTree ntn : this.childNodes) {
            msg.append(ntn.toText(prefix, keyValueSep, dataItemSep, nodeSep, includeData));
        }
        return msg.toString();
    }

    @Override
    public Iterator<INexusTree> iterator() {
        return this.childNodes.iterator();
    }

    public NexusTreeNode findNode(String nodeName) {
        NexusTreeNode node = this;
        if (!node.getName().equals(nodeName)) {
            for (INexusTree c : node) {
                NexusTreeNode n = ((NexusTreeNode)c).findNode(nodeName);
                if (n == null) continue;
                return n;
            }
        } else {
            return node;
        }
        return null;
    }

    @Override
    public String getNodePath() {
        String nodePath = this.getName();
        INexusTree pnode = this.parentNode;
        while (pnode != null) {
            nodePath = String.valueOf(pnode.getName()) + "/" + nodePath;
            pnode = pnode.getParentNode();
        }
        return "/" + nodePath;
    }

    @Override
    public String getNodePathWithClasses() {
        INexusTree node = this;
        StringBuffer totalPath = new StringBuffer("");
        while (node != null) {
            StringBuffer nodePath = new StringBuffer(node.getName());
            nodePath.append("/");
            nodePath.append(node.getNxClass());
            nodePath.append("/");
            totalPath.insert(0, nodePath);
            node = node.getParentNode();
        }
        return totalPath.toString();
    }

    @Override
    public INexusTree getNode(String path) {
        String[] nodeIds = path.split("/", 2);
        for (INexusTree child : this) {
            if (!child.getName().equals(nodeIds[0])) continue;
            return nodeIds.length == 1 ? child : child.getNode(nodeIds[1]);
        }
        return null;
    }

    @Override
    public Serializable getAttribute(String name) {
        int j = 0;
        while (j < this.getNumberOfChildNodes()) {
            NexusTreeNode c = (NexusTreeNode)this.getChildNode(j);
            if (c.getNxClass().equals("Attr") && c.getName().equals(name)) {
                return c.getData().getFirstValue();
            }
            ++j;
        }
        return null;
    }

    @Override
    public HashMap<String, Serializable> getAttributes() {
        HashMap<String, Serializable> attributes = null;
        int j = 0;
        while (j < this.getNumberOfChildNodes()) {
            NexusTreeNode c = (NexusTreeNode)this.getChildNode(j);
            if (c.getNxClass().equals("Attr")) {
                if (attributes == null) {
                    attributes = new HashMap<String, Serializable>();
                }
                attributes.put(c.getName(), c.getData().getFirstValue());
            }
            ++j;
        }
        return attributes;
    }

    @Override
    public boolean equals(Object obj) {
        return this.equals(obj, false);
    }

    private boolean childNodesEqual(List<INexusTree> otherChildNodes, boolean reportFalse) {
        int iotherlen;
        int ilen = this.childNodes.size();
        if (ilen != (iotherlen = otherChildNodes.size())) {
            if (reportFalse) {
                logger.info("childNode lengths differ");
            }
            return false;
        }
        int i = 0;
        while (i < ilen) {
            INexusTree other;
            INexusTree tree = this.childNodes.get(i);
            if (!tree.equals(other = otherChildNodes.get(i), reportFalse)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj, boolean reportFalse) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NexusTreeNode other = (NexusTreeNode)obj;
        if (this.childNodes == null) {
            if (other.childNodes != null) {
                return false;
            }
        } else if (!this.childNodesEqual(other.childNodes, reportFalse)) {
            if (reportFalse) {
                logger.info("childNodes differ - " + this.name + " " + this.nxClass);
            }
            return false;
        }
        if (this.groupData == null) {
            if (other.groupData != null) {
                return false;
            }
        } else if (!this.groupData.equals(other.groupData, reportFalse)) {
            if (reportFalse) {
                logger.info(String.valueOf(this.getNodePathWithClasses()) + " groupData differ - " + this.name + " " + this.nxClass);
            }
            return false;
        }
        if (this.name == null) {
            if (other.name != null) {
                return false;
            }
        } else if (!this.name.equals(other.name)) {
            if (reportFalse) {
                logger.info("name differ - " + this.name + " " + this.nxClass);
            }
            return false;
        }
        if (this.nxClass == null) {
            if (other.nxClass != null) {
                return false;
            }
        } else if (!this.nxClass.equals(other.nxClass)) {
            if (reportFalse) {
                logger.info("nxClass differ - " + this.name + " " + this.nxClass);
            }
            return false;
        }
        return true;
    }

    @Override
    public void sort(Comparator<INexusTree> comparator) {
        Collections.sort(this.childNodes, comparator);
        for (INexusTree tree : this.childNodes) {
            tree.sort(comparator);
        }
    }

    @Override
    public INexusTree getChildNode(String name, String className) {
        for (INexusTree tree : this.childNodes) {
            if (!tree.getName().equals(name) || !tree.getNxClass().equals(className)) continue;
            return tree;
        }
        return null;
    }

    public void setIsPointDependent(boolean val) {
        this.isPointDependent = val;
    }

    @Override
    public boolean isPointDependent() {
        return this.isPointDependent;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

