/*
 * Decompiled with CFR 0.152.
 */
package gda.data.nexus.tree;

import gda.data.nexus.extractor.NexusExtractorException;
import gda.data.nexus.tree.INexusTree;
import gda.data.nexus.tree.NexusTreeBuilder;
import gda.data.nexus.tree.NexusTreeNodeSelection;
import gda.util.TestUtils;
import java.io.StringReader;
import java.net.URL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nexusformat.NexusException;
import org.xml.sax.InputSource;

public class NexusTreeBuilderTest {
    String scratchFolder;
    URL testdataFile;
    static String TestFileFolder;

    @BeforeClass
    public static void setUpClass() {
        TestFileFolder = TestUtils.getGDALargeTestFilesLocation();
        if (TestFileFolder == null) {
            Assert.fail((String)"TestUtils.getGDALargeTestFilesLocation() returned null - test aborted");
        }
    }

    @Before
    public void setUp() throws Exception {
        this.scratchFolder = TestUtils.setUpTest(NexusTreeBuilderTest.class, (String)"setUp", (boolean)true);
    }

    @After
    public void tearDown() {
    }

    private NexusTreeNodeSelection getSelForAllButData() throws Exception {
        String xml = "<?xml version='1.0' encoding='UTF-8'?><nexusTreeNodeSelection><nexusTreeNodeSelection><nxClass>NXentry</nxClass><wanted>2</wanted><dataType>2</dataType><nexusTreeNodeSelection><nxClass>NXdata</nxClass><wanted>2</wanted><dataType>2</dataType><nexusTreeNodeSelection><nxClass>SDS</nxClass><wanted>2</wanted><dataType>1</dataType></nexusTreeNodeSelection></nexusTreeNodeSelection><nexusTreeNodeSelection><nxClass>NXinstrument</nxClass><wanted>2</wanted><dataType>2</dataType><nexusTreeNodeSelection><nxClass>NXdetector</nxClass><wanted>2</wanted><dataType>2</dataType><nexusTreeNodeSelection><nxClass>SDS</nxClass><wanted>2</wanted><dataType>1</dataType></nexusTreeNodeSelection></nexusTreeNodeSelection></nexusTreeNodeSelection></nexusTreeNodeSelection></nexusTreeNodeSelection>";
        return NexusTreeNodeSelection.createFromXML(new InputSource(new StringReader(xml)));
    }

    @Test
    public void testNexusTreeBuilderToGetStructureButNotData() throws NexusException, NexusExtractorException, Exception {
        INexusTree tree = NexusTreeBuilder.getNexusTree(String.valueOf(TestFileFolder) + "327.nxs", this.getSelForAllButData());
        Assert.assertEquals((String)"test", (long)tree.getChildNode((int)0).getChildNode((int)26).getChildNode((int)22).getChildNode((int)5).getData().dimensions[0], (long)11L);
        Assert.assertEquals((String)"test", (Object)tree.getChildNode(0).getChildNode(26).getChildNode(22).getChildNode(5).getData().getBuffer(), null);
    }
}

