/*
 * Decompiled with CFR 0.152.
 */
package gda.data.nexus.tree;

import gda.data.nexus.extractor.INexusDataGetter;
import gda.data.nexus.extractor.INexusTreeProcessor;
import gda.data.nexus.extractor.NexusExtractor;
import gda.data.nexus.extractor.NexusExtractorException;
import gda.data.nexus.extractor.NexusGroupData;
import gda.data.nexus.tree.Group;
import gda.data.nexus.tree.INexusTree;
import gda.data.nexus.tree.NexusTreeNode;
import gda.data.nexus.tree.NexusTreeNodeSelection;
import gda.data.nexus.tree.NexusTreeTopNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.nexusformat.NexusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.monitor.IMonitor;

public class NexusTreeBuilder
implements INexusTreeProcessor {
    private static final Logger logger = LoggerFactory.getLogger(NexusTreeBuilder.class);
    NexusTreeNodeSelection currentSelectedNode = null;
    INexusTree parentNode = null;
    final NexusTreeNodeSelection selectionTree;
    INexusTree tree;
    TREE_CONTENTS requiredContents;
    Map<String, NexusGroupData> targetNodes = new HashMap<String, NexusGroupData>();

    NexusTreeBuilder(TREE_CONTENTS requiredContents) {
        this.requiredContents = requiredContents;
        this.selectionTree = null;
    }

    NexusTreeBuilder(NexusTreeNodeSelection selectionTree) {
        this.selectionTree = selectionTree;
        this.currentSelectedNode = selectionTree;
    }

    @Override
    public INexusTreeProcessor.RESPONSE beginElement(String name, String nxClass, INexusDataGetter nexusDataGetter) throws NexusException, NexusExtractorException {
        NexusTreeNode treeNode = new NexusTreeNode(name, nxClass, this.parentNode, null);
        NexusTreeNodeSelection thismatch = this.match(this.currentSelectedNode, treeNode);
        INexusTreeProcessor.RESPONSE response = INexusTreeProcessor.RESPONSE.SKIP_OVER;
        if (!thismatch.isSkip()) {
            response = INexusTreeProcessor.RESPONSE.GO_INTO;
            treeNode = new NexusTreeNode(name, nxClass, this.parentNode, null);
            Boolean isAttr = nxClass.equals("Attr");
            Boolean isSDS = nxClass.equals("SDS");
            if (isSDS.booleanValue() || isAttr.booleanValue()) {
                NexusGroupData data;
                if (this.parentNode == null) {
                    throw new NexusExtractorException("NexusTreeProcessor.begin - no parent found for SDS or Attr element.");
                }
                response = isAttr != false ? INexusTreeProcessor.RESPONSE.SKIP_OVER : INexusTreeProcessor.RESPONSE.SDS_ATTR;
                NexusGroupData nexusGroupData = null;
                String targetVal = null;
                if (!isAttr.booleanValue() && (data = nexusDataGetter.getAttributeOfCurrentProcessedGroup("target")) != null && data.type == 4 && data.getBuffer() != null) {
                    targetVal = new String((byte[])data.getBuffer());
                    nexusGroupData = this.targetNodes.get(targetVal);
                }
                if (nexusGroupData == null) {
                    nexusGroupData = nexusDataGetter.getDataForCurrentProcessedGroup(name, nxClass, isAttr != false || thismatch.isGetData());
                    if (targetVal != null) {
                        this.targetNodes.put(targetVal, nexusGroupData);
                    }
                }
                treeNode = new NexusTreeNode(name, nxClass, this.parentNode, nexusGroupData);
            }
            if (this.parentNode != null) {
                this.parentNode.addChildNode(treeNode);
            } else {
                try {
                    treeNode = new NexusTreeTopNode(treeNode, nexusDataGetter.getSourceId());
                    this.tree = treeNode;
                }
                catch (Exception e) {
                    throw new NexusExtractorException("Error getting source", e);
                }
            }
            if (!isAttr.booleanValue()) {
                this.parentNode = treeNode;
            }
        }
        return response;
    }

    @Override
    public void endElement() {
        this.parentNode = this.parentNode.getParentNode();
    }

    public static INexusTree getNexusTree(String fileName, NexusTreeNodeSelection selectionTree) throws NexusException, NexusExtractorException {
        return NexusTreeBuilder.getNexusTree(fileName, selectionTree, null);
    }

    public static synchronized INexusTree getNexusTree(String fileName, NexusTreeNodeSelection selectionTree, IMonitor mon) throws NexusException, NexusExtractorException {
        NexusExtractor extractor = new NexusExtractor(fileName);
        NexusTreeBuilder proc = new NexusTreeBuilder(selectionTree);
        extractor.runLoop(proc, System.getProperty("gda.nexus.instrumentApi") != null, mon);
        return proc.getTree();
    }

    public static INexusTree getNexusTree(String fileName, String nexusSelectionFilename) throws NexusException, NexusExtractorException, Exception {
        return NexusTreeBuilder.getNexusTree(fileName, nexusSelectionFilename, null);
    }

    public static INexusTree getNexusTree(String fileName, String nexusSelectionFilename, IMonitor mon) throws NexusException, NexusExtractorException, Exception {
        NexusTreeNodeSelection selectionTree = nexusSelectionFilename == null ? null : (nexusSelectionFilename.isEmpty() ? NexusTreeNodeSelection.createTreeForAllNXEntries() : NexusTreeNodeSelection.createFromXML(nexusSelectionFilename));
        return NexusTreeBuilder.getNexusTree(fileName, selectionTree, mon);
    }

    public static INexusTree getNexusTree(String fileName, TREE_CONTENTS requiredContents) throws Exception {
        NexusExtractor extractor = new NexusExtractor(fileName);
        NexusTreeBuilder proc = new NexusTreeBuilder(requiredContents);
        try {
            extractor.runLoop(proc, System.getProperty("gda.nexus.instrumentApi") != null);
        }
        catch (Exception e) {
            String msg = proc.getTree() != null ? proc.getTree().toString() : "tree empty";
            throw new Exception("Error in getNexusTree for file=" + fileName + ". Tree = " + msg, e);
        }
        return proc.getTree();
    }

    INexusTree getTree() {
        return this.tree;
    }

    private NexusTreeNodeSelection match(NexusTreeNodeSelection selectionTree, INexusTree treeNode) {
        if (this.requiredContents != null) {
            NexusTreeNodeSelection match = NexusTreeNodeSelection.SKIP;
            if (this.requiredContents == TREE_CONTENTS.ALL) {
                match = NexusTreeNodeSelection.GET_ALL;
            } else {
                INexusTree node;
                INexusTree childOfTop = node = treeNode;
                while (node.getParentNode() != null) {
                    childOfTop = node;
                    node = node.getParentNode();
                }
                if (!node.getNxClass().equals("") || !node.getName().equals("")) {
                    logger.error("top node is not correct");
                } else if (childOfTop == node) {
                    match = NexusTreeNodeSelection.GET_ALL;
                } else if (this.requiredContents == TREE_CONTENTS.ALLNXENTRY && childOfTop.getNxClass().equals("NXentry")) {
                    match = NexusTreeNodeSelection.GET_ALL;
                }
            }
            return match;
        }
        if (selectionTree == null) {
            return NexusTreeNodeSelection.GET_ALL;
        }
        INexusTree node = treeNode;
        LinkedList<Group> path = new LinkedList<Group>();
        path.add(new Group(node));
        while (node.getParentNode() != null) {
            node = node.getParentNode();
            path.add(new Group(node));
        }
        Iterator iter = path.descendingIterator();
        Vector<NexusTreeNodeSelection> selectionNodesV = new Vector<NexusTreeNodeSelection>();
        selectionNodesV.add(selectionTree);
        List<NexusTreeNodeSelection> selectionNodes = selectionNodesV;
        NexusTreeNodeSelection match = NexusTreeNodeSelection.SKIP;
        while (iter.hasNext()) {
            Group item = (Group)iter.next();
            if (!match.isGetThisAndBelow()) {
                match = NexusTreeNodeSelection.SKIP;
            }
            for (NexusTreeNodeSelection selectionNode : selectionNodes) {
                if (!selectionNode.MatchesNXClass(item.NXclass) || !selectionNode.MatchesName(item.name)) continue;
                match = selectionNode;
                selectionNodes = selectionNode.getChildNodes();
                break;
            }
            if (match.isSkip()) break;
        }
        return match;
    }

    public static enum TREE_CONTENTS {
        ALLNXENTRY,
        ALL;

    }
}

